/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases.inlining;

import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.phases.inlining.CallNode;
import jdk.graal.compiler.truffle.phases.inlining.CallTree;
import jdk.graal.compiler.truffle.phases.inlining.InliningPolicy;

final class DefaultInliningPolicy
implements InliningPolicy {
    private static final int MAX_DEPTH = 15;
    private static final Comparator<CallNode> CALL_NODE_COMPARATOR = (o1, o2) -> {
        if (o1.isTrivial() && !o2.isTrivial()) {
            return 1;
        }
        if (o2.isTrivial() && !o1.isTrivial()) {
            return -1;
        }
        int compare = Double.compare(o2.getRootRelativeFrequency(), o1.getRootRelativeFrequency());
        if (compare == 0) {
            return o1.compareTo((CallNode)o2);
        }
        return compare;
    };
    private final OptionValues options;
    private int expanded;

    DefaultInliningPolicy(OptionValues options) {
        this.options = options;
    }

    private static PriorityQueue<CallNode> getQueue(CallTree tree, CallNode.State state) {
        PriorityQueue<CallNode> queue = new PriorityQueue<CallNode>(CALL_NODE_COMPARATOR);
        for (CallNode child : tree.getRoot().getChildren()) {
            if (child.getState() != state) continue;
            queue.add(child);
        }
        return queue;
    }

    private static void updateQueue(CallNode candidate, PriorityQueue<CallNode> inlineQueue, CallNode.State expanded) {
        for (CallNode child : candidate.getChildren()) {
            if (child.getState() != expanded) continue;
            inlineQueue.add(child);
        }
    }

    @Override
    public void run(CallTree tree) {
        this.expand(tree);
        this.analyse(tree.getRoot());
        this.inline(tree);
    }

    private void analyse(CallNode node) {
        for (CallNode child : node.getChildren()) {
            this.analyse(child);
        }
        Data data = DefaultInliningPolicy.data(node);
        if (node.getState() == CallNode.State.Cutoff && node.getRecursionDepth() == 0) {
            data.callDiff = node.getRootRelativeFrequency();
        }
        if (node.getState() == CallNode.State.Expanded) {
            data.callDiff = -1.0 * node.getRootRelativeFrequency();
            for (CallNode child : node.getChildren()) {
                switch (child.getState()) {
                    case Indirect: 
                    case Removed: 
                    case BailedOut: {
                        break;
                    }
                    case Cutoff: 
                    case Inlined: 
                    case Expanded: {
                        data.callDiff += DefaultInliningPolicy.data((CallNode)child).callDiff;
                    }
                }
            }
            if (data.callDiff > 0.0) {
                data.callDiff = node.getRootRelativeFrequency();
            }
        }
    }

    private static Data data(CallNode node) {
        return (Data)node.getPolicyData();
    }

    @Override
    public Object newCallNodeData(CallNode callNode) {
        return new Data();
    }

    private void inline(CallTree tree) {
        CallNode candidate;
        String inlineOnly = TruffleCompilerOptions.InlineOnly.getValue(this.options);
        int inliningBudget = TruffleCompilerOptions.InliningInliningBudget.getValue(this.options);
        PriorityQueue<CallNode> inlineQueue = DefaultInliningPolicy.getQueue(tree, CallNode.State.Expanded);
        int rootSize = tree.getRoot().getSize();
        while ((candidate = inlineQueue.poll()) != null) {
            if (!InliningPolicy.acceptForInline(candidate, inlineOnly)) continue;
            if (candidate.isTrivial()) {
                candidate.inline();
                continue;
            }
            int candidateCost = candidate.getSize();
            if (rootSize + candidateCost > inliningBudget && (rootSize = tree.getRoot().recalculateSize()) + candidateCost > inliningBudget) break;
            if (!(DefaultInliningPolicy.data((CallNode)candidate).callDiff <= 0.0)) continue;
            candidate.inline();
            rootSize += candidateCost;
            DefaultInliningPolicy.updateQueue(candidate, inlineQueue, CallNode.State.Expanded);
        }
    }

    private void expand(CallTree tree) {
        CallNode candidate;
        int expansionBudget = TruffleCompilerOptions.InliningExpansionBudget.getValue(this.options);
        int maximumRecursiveInliningValue = TruffleCompilerOptions.InliningRecursionDepth.getValue(this.options);
        this.expanded = tree.getRoot().getSize();
        PriorityQueue<CallNode> expandQueue = DefaultInliningPolicy.getQueue(tree, CallNode.State.Cutoff);
        while ((candidate = expandQueue.poll()) != null && this.expanded < expansionBudget) {
            if (candidate.getRecursionDepth() > maximumRecursiveInliningValue || candidate.getDepth() > 15) continue;
            this.expand(candidate, expandQueue);
        }
    }

    private void expand(CallNode candidate, PriorityQueue<CallNode> expandQueue) {
        candidate.expand();
        if (candidate.getState() == CallNode.State.Expanded) {
            this.expanded += candidate.getSize();
            DefaultInliningPolicy.updateQueue(candidate, expandQueue, CallNode.State.Cutoff);
        }
    }

    @Override
    public void afterExpand(CallNode callNode) {
        for (CallNode child : callNode.getChildren()) {
            if (!child.isTrivial()) continue;
            child.expand();
        }
    }

    @Override
    public void putProperties(CallNode callNode, Map<Object, Object> properties) {
        Data data = DefaultInliningPolicy.data(callNode);
        properties.put("call diff", data != null ? data.callDiff : 0.0);
    }

    private static final class Data {
        double callDiff;

        private Data() {
        }
    }
}

