/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.loop.phases.LoopSafepointEliminationPhase;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.graal.compiler.truffle.KnownTruffleTypes;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class TruffleLoopSafepointEliminationPhase
extends LoopSafepointEliminationPhase {
    private final ResolvedJavaMethod callBoundary;

    public TruffleLoopSafepointEliminationPhase(KnownTruffleTypes types) {
        this.callBoundary = types.OptimizedCallTarget_callBoundary;
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        LoopSafepointEliminationPhase.Instance instance = new LoopSafepointEliminationPhase.Instance(graph, context){

            @Override
            protected void onSafepointDisabledLoopBegin(Loop loop) {
                for (Node node : loop.whole().nodes()) {
                    if (!(node instanceof CommitAllocationNode) && !(node instanceof AbstractNewObjectNode)) continue;
                    return;
                }
                loop.loopBegin().disableGuestSafepoint(loop.loopBegin().getLoopEndsSafepointState());
            }

            @Override
            protected boolean onCallInLoop(LoopEndNode loopEnd, FixedNode currentCallNode) {
                if (currentCallNode instanceof Invoke && TruffleLoopSafepointEliminationPhase.this.isTruffleCall((Invoke)((Object)currentCallNode))) {
                    loopEnd.disableGuestSafepoint();
                    return true;
                }
                return false;
            }

            @Override
            protected boolean allowGuestSafepoints() {
                return true;
            }
        };
        instance.optimizeSafepoints();
    }

    private boolean isTruffleCall(Invoke call) {
        CallTargetNode target = call.callTarget();
        if (target == null) {
            return false;
        }
        ResolvedJavaMethod method = target.targetMethod();
        if (method == null) {
            return false;
        }
        return method.equals((Object)this.callBoundary);
    }
}

