/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectState;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;
import jdk.graal.compiler.truffle.nodes.AnyExtendNode;
import jdk.graal.compiler.truffle.nodes.AnyNarrowNode;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicSet;

public final class PhiTransformPhase
extends BasePhase<CoreProviders> {
    private static final int MAX_ITERATIONS = 3;
    private final CanonicalizerPhase canonicalizer;

    public PhiTransformPhase(CanonicalizerPhase canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    private static ValidTransformation collectNodes(ValueNode node, EconomicSet<ValueNode> nodes, UnaryNode transformation, ResolvedJavaType longClass) {
        ValidTransformation valid = ValidTransformation.Valid;
        nodes.add((Object)node);
        for (Node usage : node.usages()) {
            NarrowNode n2;
            if (usage instanceof VirtualObjectState) {
                if (!PhiTransformPhase.isValidStateUsage(usage, longClass)) {
                    return ValidTransformation.Invalid;
                }
                valid = ValidTransformation.WithState;
                continue;
            }
            if (usage instanceof NarrowNode) {
                NarrowNode n1 = (NarrowNode)usage;
                if (!(transformation instanceof NarrowNode)) {
                    return ValidTransformation.Invalid;
                }
                n2 = (NarrowNode)transformation;
                if (n1.getInputBits() == n2.getInputBits() && n1.getResultBits() == n2.getResultBits()) continue;
                return ValidTransformation.Invalid;
            }
            if (usage instanceof AnyNarrowNode) {
                AnyNarrowNode n1 = (AnyNarrowNode)usage;
                if (!(transformation instanceof NarrowNode)) {
                    return ValidTransformation.Invalid;
                }
                n2 = (NarrowNode)transformation;
                if (64 == n2.getInputBits() && 32 == n2.getResultBits()) continue;
                return ValidTransformation.Invalid;
            }
            if (usage instanceof ReinterpretNode) {
                if (transformation instanceof ReinterpretNode) continue;
                return ValidTransformation.Invalid;
            }
            if (usage.getClass() == ValuePhiNode.class || usage.getClass() == ValueProxyNode.class) {
                if (!nodes.add((Object)((ValueNode)usage))) continue;
                ValidTransformation result = PhiTransformPhase.collectNodes((ValueNode)usage, nodes, transformation, longClass);
                if (result == ValidTransformation.Invalid) {
                    return ValidTransformation.Invalid;
                }
                if (result != ValidTransformation.WithState) continue;
                valid = result;
                continue;
            }
            return ValidTransformation.Invalid;
        }
        return valid;
    }

    private static boolean isValidStateUsage(Node usage, ResolvedJavaType longClass) {
        VirtualObjectNode object;
        if (usage instanceof VirtualObjectState && (object = ((VirtualObjectState)usage).object()) instanceof VirtualArrayNode) {
            return longClass.equals((Object)((VirtualArrayNode)object).componentType());
        }
        return false;
    }

    private static boolean isValidInput(ValueNode value, UnaryNode transformation, boolean usedInState, EconomicSet<ValueNode> nodes) {
        if (nodes.contains((Object)value)) {
            return true;
        }
        if (value.isJavaConstant()) {
            return true;
        }
        if (transformation instanceof NarrowNode) {
            NarrowNode narrow = (NarrowNode)transformation;
            if (value instanceof IntegerConvertNode) {
                IntegerConvertNode convert = (IntegerConvertNode)value;
                if (convert.getInputBits() != narrow.getResultBits() || convert.getResultBits() != narrow.getInputBits()) {
                    return false;
                }
                return !usedInState;
            }
            if (value instanceof AnyExtendNode) {
                return narrow.getResultBits() == 32 && narrow.getInputBits() == 64;
            }
        } else {
            assert (transformation instanceof ReinterpretNode) : Assertions.errorMessage(transformation);
            return value instanceof ReinterpretNode;
        }
        return false;
    }

    private static ValueNode transformInputValue(StructuredGraph graph, ValueNode value, UnaryNode transformation, EconomicSet<ValueNode> nodes, EconomicSetNodeEventListener ec) {
        ValueNode newValue;
        if (nodes.contains((Object)value)) {
            newValue = value;
        } else {
            if (transformation instanceof NarrowNode) {
                NarrowNode narrow = (NarrowNode)transformation;
                if (value instanceof AnyExtendNode && narrow.getInputBits() == 64 && narrow.getResultBits() == 32) {
                    return ((AnyExtendNode)value).getValue();
                }
                newValue = graph.unique(new NarrowNode(value, narrow.getInputBits(), narrow.getResultBits()));
            } else {
                assert (transformation instanceof ReinterpretNode) : Assertions.errorMessage(transformation);
                newValue = graph.addOrUnique(ReinterpretNode.create(transformation.stamp(NodeView.DEFAULT), value, NodeView.DEFAULT));
            }
            ec.changed(Graph.NodeEvent.INPUT_CHANGED, newValue);
        }
        return newValue;
    }

    private static boolean checkTransformedNode(StructuredGraph graph, EconomicSetNodeEventListener ec, ResolvedJavaType longClass, Node node) {
        if (node.getClass() == ValuePhiNode.class || node.getClass() == ValueProxyNode.class) {
            boolean narrowUsage = false;
            UnaryNode transformation = null;
            for (Node usage : node.usages()) {
                if (usage instanceof NarrowNode || usage instanceof ReinterpretNode) {
                    narrowUsage = usage instanceof NarrowNode;
                    if (transformation == null) {
                        transformation = (UnaryNode)usage;
                        continue;
                    }
                    return false;
                }
                if (usage instanceof AnyNarrowNode) {
                    if (transformation == null) {
                        transformation = new NarrowNode((ValueNode)node, 64, 32);
                        continue;
                    }
                    return false;
                }
                if (usage.getClass() == ValuePhiNode.class || usage.getClass() == ValueProxyNode.class || usage.getClass() == VirtualObjectState.class) continue;
                return false;
            }
            if (transformation == null) {
                if (node.getClass() == ValuePhiNode.class) {
                    ReinterpretNode reinterpret = ((ValuePhiNode)node).values().filter(ReinterpretNode.class).first();
                    AnyExtendNode convert = ((ValuePhiNode)node).values().filter(AnyExtendNode.class).first();
                    if (reinterpret != null && convert == null) {
                        transformation = new ReinterpretNode(reinterpret.getValue().getStackKind(), (ValueNode)node);
                    } else if (reinterpret == null && convert != null) {
                        transformation = new NarrowNode((ValueNode)node, 64, 32);
                    }
                }
                if (transformation == null) {
                    return false;
                }
            }
            assert (transformation instanceof NarrowNode || transformation instanceof ReinterpretNode) : transformation;
            EconomicSet nodes = EconomicSet.create();
            ValidTransformation valid = PhiTransformPhase.collectNodes((ValueNode)node, (EconomicSet<ValueNode>)nodes, transformation, longClass);
            if (valid == ValidTransformation.Invalid) {
                return false;
            }
            if (valid == ValidTransformation.WithState && narrowUsage) {
                return false;
            }
            for (ValueNode target : nodes) {
                if (target.getClass() == ValuePhiNode.class) {
                    for (ValueNode value : ((ValuePhiNode)target).values()) {
                        if (PhiTransformPhase.isValidInput(value, transformation, valid == ValidTransformation.WithState, (EconomicSet<ValueNode>)nodes)) continue;
                        return false;
                    }
                    continue;
                }
                if (PhiTransformPhase.isValidInput(((ValueProxyNode)target).value(), transformation, valid == ValidTransformation.WithState, (EconomicSet<ValueNode>)nodes)) continue;
                return false;
            }
            Stamp stamp = transformation.stamp(NodeView.DEFAULT).unrestricted();
            for (ValueNode target : EconomicSet.create((UnmodifiableEconomicSet)nodes)) {
                ValueNode duplicate;
                if (target.getClass() == ValuePhiNode.class) {
                    ValuePhiNode phi = (ValuePhiNode)target;
                    NodeInputList<ValueNode> phiValues = phi.values();
                    ValueNode[] values = new ValueNode[phiValues.count()];
                    for (int i = 0; i < phiValues.count(); ++i) {
                        values[i] = PhiTransformPhase.transformInputValue(graph, (ValueNode)phiValues.get(i), transformation, (EconomicSet<ValueNode>)nodes, ec);
                    }
                    ValuePhiNode duplicatePhi = graph.addWithoutUnique(new ValuePhiNode(stamp, phi.merge(), values));
                    nodes.add((Object)duplicatePhi);
                    duplicate = duplicatePhi;
                } else {
                    ValueProxyNode proxy = (ValueProxyNode)target;
                    duplicate = graph.addWithoutUnique(new ValueProxyNode(stamp, PhiTransformPhase.transformInputValue(graph, proxy.value(), transformation, (EconomicSet<ValueNode>)nodes, ec), proxy.proxyPoint()));
                }
                nodes.add((Object)duplicate);
                for (Node usage : target.usages()) {
                    if (!(usage instanceof NarrowNode) && !(usage instanceof ReinterpretNode) && !(usage instanceof AnyNarrowNode)) continue;
                    usage.replaceAtUsagesAndDelete(duplicate);
                    break;
                }
                target.replaceAndDelete(duplicate);
            }
            return true;
        }
        if (node.getClass() == AnyExtendNode.class) {
            AnyExtendNode extend = (AnyExtendNode)node;
            if (node.hasExactlyOneUsage() && PhiTransformPhase.isValidStateUsage(node.singleUsage(), longClass)) {
                node.replaceAtUsagesAndDelete(extend.getValue());
                return true;
            }
        } else if (node.getClass() == ReinterpretNode.class) {
            if (node.hasExactlyOneUsage() && PhiTransformPhase.isValidStateUsage(node.singleUsage(), longClass)) {
                node.replaceAtUsagesAndDelete(((ReinterpretNode)node).getValue());
                return true;
            }
        } else if (node.getClass() == AnyNarrowNode.class) {
            AnyNarrowNode narrow = (AnyNarrowNode)node;
            if (node.hasExactlyOneUsage() && PhiTransformPhase.isValidStateUsage(node.singleUsage(), longClass)) {
                node.replaceAtUsagesAndDelete(narrow.getValue());
                return true;
            }
        }
        return false;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        GraalError.guarantee(graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL), "not intended to run without loop proxies");
        ResolvedJavaType longClass = context.getMetaAccess().lookupJavaType(Long.TYPE);
        EconomicSetNodeEventListener ec = new EconomicSetNodeEventListener();
        try (Graph.NodeEventScope nes = graph.trackNodeEvents(ec);){
            boolean progress = false;
            int iteration = 0;
            do {
                if (!ec.getNodes().isEmpty()) {
                    this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)ec.getNodes());
                }
                ec.getNodes().clear();
                progress = false;
                for (Node node : graph.getNodes()) {
                    progress |= PhiTransformPhase.checkTransformedNode(graph, ec, longClass, node);
                }
            } while (progress && iteration++ < 3);
        }
        this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)ec.getNodes());
    }

    private static enum ValidTransformation {
        Valid,
        Invalid,
        WithState;

    }
}

