/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import java.util.Iterator;
import jdk.graal.compiler.core.common.GraalBailoutException;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.nodes.asserts.NeverPartOfCompilationNode;

public final class NeverPartOfCompilationPhase
extends BasePhase<TruffleTierContext> {
    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        graph.checkCancellation();
        Iterator iterator = graph.getNodes(NeverPartOfCompilationNode.TYPE).iterator();
        if (iterator.hasNext()) {
            NeverPartOfCompilationNode neverPartOfCompilationNode = (NeverPartOfCompilationNode)iterator.next();
            NeverPartOfCompilationException neverPartOfCompilationException = new NeverPartOfCompilationException(neverPartOfCompilationNode.getMessage());
            neverPartOfCompilationException.setStackTrace(GraphUtil.approxSourceStackTraceElement(neverPartOfCompilationNode));
            throw neverPartOfCompilationException;
        }
    }

    private static class NeverPartOfCompilationException
    extends GraalBailoutException {
        NeverPartOfCompilationException(String message) {
            super(null, message, new Object[0]);
        }

        @Override
        public boolean isCausedByCompilerAssert() {
            return true;
        }
    }
}

