/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.nodes.frame;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessFlags;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessType;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessorNode;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameGetTagNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameGetTagNode> TYPE = NodeClass.create(VirtualFrameGetTagNode.class);
    private static final int STATIC_TAG = 8;

    public VirtualFrameGetTagNode(InvocationPlugin.Receiver frame, int frameSlotIndex) {
        super(TYPE, StampFactory.forKind(JavaKind.Byte), frame, frameSlotIndex, 0, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.BENIGN);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        VirtualObjectNode tagVirtual;
        ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
        if (tagAlias instanceof VirtualObjectNode && this.frameSlotIndex < (tagVirtual = (VirtualObjectNode)tagAlias).entryCount()) {
            ValueNode actualTag = tool.getEntry(tagVirtual, this.frameSlotIndex);
            if (actualTag.isConstant()) {
                int constantTag = actualTag.asJavaConstant().asInt();
                tool.replaceWith(this.getConstant(constantTag < 8 ? constantTag : 8));
            } else {
                ValueNode staticTag = this.getConstant(8);
                IntegerLessThanNode comparison = new IntegerLessThanNode(actualTag, staticTag);
                tool.addNode(comparison);
                ConditionalNode result = new ConditionalNode(comparison, actualTag, staticTag);
                tool.addNode(result);
                tool.replaceWith(result);
            }
            return;
        }
        this.insertDeoptimization(tool);
    }
}

