/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public final class IsCompilationConstantNode
extends FloatingNode
implements Lowerable,
Canonicalizable {
    public static final NodeClass<IsCompilationConstantNode> TYPE = NodeClass.create(IsCompilationConstantNode.class);
    @Node.Input
    ValueNode value;

    public IsCompilationConstantNode(ValueNode value) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
        this.value = value;
    }

    @Override
    public void lower(LoweringTool tool) {
        ValueNode synonym = IsCompilationConstantNode.findSynonym(this.value);
        ValueNode result = synonym != null && synonym.isConstant() ? synonym : ConstantNode.forBoolean(false, this.graph());
        assert (result != null);
        this.replaceAtUsagesAndDelete(result);
    }

    public static ValueNode create(ValueNode value) {
        ValueNode synonym = IsCompilationConstantNode.findSynonym(value);
        if (synonym != null) {
            return synonym;
        }
        return new IsCompilationConstantNode(value);
    }

    public static ValueNode findSynonym(ValueNode value) {
        if (value instanceof BoxNode) {
            return IsCompilationConstantNode.create(((BoxNode)value).getValue());
        }
        if (value.isConstant()) {
            return ConstantNode.forBoolean(true);
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode synonym = IsCompilationConstantNode.findSynonym(this.value);
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native boolean check(Object var0);
}

