/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.hotspot;

import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.truffle.TruffleCompilerConfiguration;
import jdk.graal.compiler.truffle.hotspot.HotSpotKnownTruffleTypes;
import jdk.vm.ci.meta.MetaAccessProvider;

public abstract class TruffleEntryPointDecorator
implements EntryPointDecorator {
    protected MetaAccessProvider metaAccess;
    protected GraalHotSpotVMConfig config;
    protected HotSpotRegistersProvider registers;
    protected final int installedCodeOffset;
    protected final int entryPointOffset;

    public TruffleEntryPointDecorator(TruffleCompilerConfiguration compilerConfig, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        this.metaAccess = compilerConfig.lastTier().providers().getMetaAccess();
        this.config = config;
        this.registers = registers;
        HotSpotKnownTruffleTypes types = (HotSpotKnownTruffleTypes)compilerConfig.types();
        this.installedCodeOffset = types.HotSpotOptimizedCallTarget_installedCode.getOffset();
        this.entryPointOffset = types.InstalledCode_entryPoint.getOffset();
    }

    @Override
    public void initialize(CoreProviders providers, LIRGenerationResult lirGenRes) {
        if (this.config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
            ForeignCallLinkage callTarget = providers.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_LOAD_BARRIER);
            lirGenRes.getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        }
    }
}

