/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.host;

import com.oracle.truffle.compiler.HostMethodInfo;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.serviceprovider.LibGraalService;
import jdk.graal.compiler.truffle.TruffleCompilerImpl;
import jdk.graal.compiler.truffle.host.TruffleKnownHostTypes;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class TruffleHostEnvironment {
    protected static final int HOST_METHOD_CACHE_SIZE = 4096;
    private static Lookup lookup = GraalServices.loadSingle(Lookup.class, true);
    private final TruffleCompilerRuntime runtime;
    private final TruffleKnownHostTypes types;
    private volatile TruffleCompilerImpl compiler;

    public TruffleHostEnvironment(TruffleCompilerRuntime runtime, MetaAccessProvider metaAccess) {
        this.runtime = runtime;
        this.types = new TruffleKnownHostTypes(runtime, metaAccess);
    }

    public static void overrideLookup(Lookup l) {
        lookup = l;
    }

    public abstract HostMethodInfo getHostMethodInfo(ResolvedJavaMethod var1);

    public final TruffleCompilerRuntime runtime() {
        return this.runtime;
    }

    public final TruffleKnownHostTypes types() {
        return this.types;
    }

    public final TruffleCompilerImpl getTruffleCompiler(TruffleCompilable compilable) throws UnsupportedOperationException {
        TruffleCompilerImpl c = this.compiler;
        if (c == null) {
            c = this.initializeCompiler(compilable);
        }
        return c;
    }

    private synchronized TruffleCompilerImpl initializeCompiler(TruffleCompilable compilable) {
        if (this.compiler != null) {
            return this.compiler;
        }
        this.compiler = this.createCompiler(compilable);
        return this.compiler;
    }

    protected abstract TruffleCompilerImpl createCompiler(TruffleCompilable var1);

    public static TruffleHostEnvironment get(ResolvedJavaMethod relativeTo) {
        return TruffleHostEnvironment.get(relativeTo.getDeclaringClass());
    }

    public static TruffleHostEnvironment get(ResolvedJavaType relativeTo) {
        GraalError.guarantee(lookup != null, "Lookup not installed.");
        GraalError.guarantee(relativeTo.getJavaKind() == JavaKind.Object, "Must be object kind. Primitive types are not allowed.");
        return lookup.lookup(relativeTo);
    }

    public TruffleRuntimeScope openTruffleRuntimeScope() {
        return null;
    }

    @LibGraalService
    public static interface Lookup {
        public TruffleHostEnvironment lookup(ResolvedJavaType var1);
    }

    public static interface TruffleRuntimeScope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

