/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.util.Objects;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.RetryableBailoutException;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.Cancellable;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.truffle.KnownTruffleTypes;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.graal.compiler.truffle.PerformanceInformationHandler;
import jdk.graal.compiler.truffle.TruffleCompilerConfiguration;
import jdk.graal.compiler.truffle.TruffleCompilerImpl;
import jdk.graal.compiler.truffle.nodes.TruffleAssumption;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;

public final class TruffleTierContext
extends HighTierContext {
    public final PartialEvaluator partialEvaluator;
    public final OptionValues compilerOptions;
    public final DebugContext debug;
    public final JavaConstant compilableConstant;
    public final TruffleCompilable compilable;
    public final CompilationIdentifier compilationId;
    public final SpeculationLog log;
    public final TruffleCompilationTask task;
    public final StructuredGraph graph;
    public final PerformanceInformationHandler handler;

    private TruffleTierContext(PartialEvaluator partialEvaluator, OptionValues compilerOptions, DebugContext debug, TruffleCompilable compilable, CompilationIdentifier compilationId, SpeculationLog log, TruffleCompilationTask task, PerformanceInformationHandler handler, ResolvedJavaMethod initialMethod) {
        super(partialEvaluator.getProviders(), new PhaseSuite<HighTierContext>(), OptimisticOptimizations.NONE);
        Objects.requireNonNull(debug);
        Objects.requireNonNull(compilable);
        Objects.requireNonNull(compilationId);
        Objects.requireNonNull(task);
        this.compilerOptions = compilerOptions;
        this.partialEvaluator = partialEvaluator;
        this.debug = debug;
        this.compilableConstant = compilable.asJavaConstant();
        this.compilable = compilable;
        this.compilationId = compilationId;
        this.log = log;
        this.task = task;
        this.handler = handler;
        this.graph = this.createInitialGraph(initialMethod);
    }

    private TruffleTierContext(TruffleTierContext parent, TruffleCompilable compilable, ResolvedJavaMethod initialMethod) {
        this(parent.partialEvaluator, parent.compilerOptions, parent.debug, compilable, parent.compilationId, parent.log, parent.task, parent.handler, initialMethod);
    }

    public static TruffleTierContext createInitialContext(PartialEvaluator partialEvaluator, OptionValues compilerOptions, DebugContext debug, TruffleCompilable compilable, CompilationIdentifier compilationId, SpeculationLog log, TruffleCompilationTask task, PerformanceInformationHandler handler) {
        boolean readyForCompilation = compilable.prepareForCompilation(true, task.tier(), !task.hasNextTier());
        if (!readyForCompilation) {
            throw new RetryableBailoutException("Compilable not ready for compilation.");
        }
        ResolvedJavaMethod method = partialEvaluator.rootForCallTarget(compilable);
        TruffleTierContext context = new TruffleTierContext(partialEvaluator, compilerOptions, debug, compilable, compilationId, log, task, handler, method);
        context.recordStabilityAssumptions();
        return context;
    }

    public TruffleTierContext createInlineContext(TruffleCompilable inlinedCompilable) {
        boolean readyForCompilation = inlinedCompilable.prepareForCompilation(false, this.task.tier(), !this.task.hasNextTier());
        if (!readyForCompilation) {
            throw new RetryableBailoutException("Compilable not ready for compilation.");
        }
        TruffleTierContext context = new TruffleTierContext(this, inlinedCompilable, this.partialEvaluator.inlineRootForCallTarget(this.compilable));
        context.recordStabilityAssumptions();
        return context;
    }

    public TruffleTierContext createFinalizationContext(TruffleCompilable inlinedCompilable) {
        return new TruffleTierContext(this, inlinedCompilable, this.partialEvaluator.getCallDirect());
    }

    private StructuredGraph createInitialGraph(ResolvedJavaMethod method) {
        StructuredGraph.Builder builder = new StructuredGraph.Builder(this.debug.getOptions(), this.debug, StructuredGraph.AllowAssumptions.YES).name(this.compilable.getName()).method(method).speculationLog(this.log).compilationId(this.compilationId).trackNodeSourcePosition(this.partialEvaluator.graphBuilderConfigForParsing.trackNodeSourcePosition()).cancellable(new CancellableTask(this.task));
        return this.partialEvaluator.customizeStructuredGraphBuilder(builder).build();
    }

    private void recordStabilityAssumptions() {
        this.graph.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(this.getValidRootAssumption(this.partialEvaluator.getProviders())));
        this.graph.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(this.getNodeRewritingAssumption(this.partialEvaluator.getProviders())));
    }

    public PartialEvaluator getPartialEvaluator() {
        return this.partialEvaluator;
    }

    public TruffleCompilerConfiguration config() {
        return this.partialEvaluator.config;
    }

    public KnownTruffleTypes types() {
        return this.config().types();
    }

    public TruffleCompilerRuntime runtime() {
        return this.config().runtime();
    }

    public JavaConstant getNodeRewritingAssumption(Providers providers) {
        JavaConstant constant = this.readCompilableField(providers, this.types().OptimizedCallTarget_nodeRewritingAssumption);
        if (constant.isNull()) {
            throw GraalError.shouldNotReachHere("OptimizedCallTarget.nodeRewritingAssumption must not be null.");
        }
        return constant;
    }

    public JavaConstant getValidRootAssumption(Providers providers) {
        JavaConstant constant = this.readCompilableField(providers, this.types().OptimizedCallTarget_validRootAssumption);
        if (constant.isNull()) {
            throw GraalError.shouldNotReachHere("OptimizedCallTarget_validRootAssumption must not be null.");
        }
        return constant;
    }

    private JavaConstant readCompilableField(Providers providers, ResolvedJavaField field) {
        return providers.getConstantReflection().readFieldValue(field, this.compilableConstant);
    }

    public boolean isFirstTier() {
        return this.task.isFirstTier();
    }

    public static SpeculationLog getSpeculationLog(TruffleCompilerImpl.TruffleCompilationWrapper wrapper) {
        SpeculationLog speculationLog = wrapper.compilable.getCompilationSpeculationLog();
        if (speculationLog != null) {
            speculationLog.collectFailedSpeculations();
        }
        return speculationLog;
    }

    private static final class CancellableTask
    implements Cancellable {
        private final TruffleCompilationTask delegate;

        CancellableTask(TruffleCompilationTask delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }
    }
}

