/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.truffle.KnownTruffleTypes;
import jdk.graal.compiler.truffle.PartialEvaluatorConfiguration;
import jdk.graal.compiler.truffle.TruffleStringConstantFieldProvider;
import jdk.graal.compiler.truffle.phases.TruffleCompilerPhases;

public final class TruffleTierConfiguration {
    private final PartialEvaluatorConfiguration configuration;
    private final Backend backend;
    private final Providers providers;
    private final Suites suites;
    private final LIRSuites lirSuites;

    public TruffleTierConfiguration(PartialEvaluatorConfiguration configuration, Backend backend, OptionValues options, KnownTruffleTypes knownTruffleTypes) {
        this(configuration, backend, backend.getProviders(), backend.getSuites().getDefaultSuites(options, backend.getTarget().arch), backend.getSuites().getDefaultLIRSuites(options), knownTruffleTypes);
    }

    public TruffleTierConfiguration(PartialEvaluatorConfiguration configuration, Backend backend, Providers providers, Suites suites, LIRSuites lirSuites, KnownTruffleTypes knownTruffleTypes) {
        this.configuration = configuration;
        this.backend = backend;
        this.providers = providers.copyWith(new TruffleStringConstantFieldProvider(providers, knownTruffleTypes));
        this.suites = suites;
        this.lirSuites = lirSuites;
        TruffleCompilerPhases.register(knownTruffleTypes, providers, suites);
        this.suites.setImmutable();
    }

    public PartialEvaluatorConfiguration partialEvaluator() {
        return this.configuration;
    }

    public Backend backend() {
        return this.backend;
    }

    public Providers providers() {
        return this.providers;
    }

    public Suites suites() {
        return this.suites;
    }

    public LIRSuites lirSuites() {
        return this.lirSuites;
    }
}

