/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import java.io.Closeable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.truffle.phases.inlining.CallTree;

public final class TruffleInliningScope
implements Closeable {
    private static final TruffleInliningScope DISABLED = new TruffleInliningScope();
    private static final ThreadLocal<TruffleInliningScope> CURRENT_SCOPE = new ThreadLocal();
    private CallTree callTree;

    static TruffleInliningScope open(DebugContext debug) {
        if (debug.isDumpEnabled(1)) {
            TruffleInliningScope scope = new TruffleInliningScope();
            CURRENT_SCOPE.set(scope);
            return scope;
        }
        return DISABLED;
    }

    TruffleInliningScope() {
    }

    public static TruffleInliningScope getCurrent(DebugContext debug) {
        if (debug.isDumpEnabled(1)) {
            return CURRENT_SCOPE.get();
        }
        return DISABLED;
    }

    public void setCallTree(CallTree callTree) {
        if (this == DISABLED) {
            return;
        }
        if (this.callTree != null) {
            throw GraalError.shouldNotReachHere("Only one call tree expected.");
        }
        this.callTree = callTree;
    }

    public CallTree getCallTree() {
        return this.callTree;
    }

    @Override
    public void close() {
        if (this == DISABLED) {
            return;
        }
        this.callTree = null;
    }
}

