/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import java.util.Objects;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public final class TruffleDebugJavaMethod
implements JavaMethod {
    private final TruffleCompilable compilable;
    private final TruffleCompilationTask task;
    private static final int NUMBER_OF_TIERS = 3;
    private static final TruffleJavaType[] TIERS = new TruffleJavaType[3];

    public TruffleDebugJavaMethod(TruffleCompilationTask task, TruffleCompilable compilable) {
        this.compilable = compilable;
        this.task = task;
    }

    public TruffleCompilable getCompilable() {
        return this.compilable;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TruffleDebugJavaMethod) {
            TruffleDebugJavaMethod other = (TruffleDebugJavaMethod)obj;
            return this.compilable.equals((Object)other.compilable);
        }
        return false;
    }

    public int hashCode() {
        return this.compilable.hashCode();
    }

    public Signature getSignature() {
        return new TruffleSignature(TIERS[this.task.tier()]);
    }

    public String getName() {
        return Objects.toString(this.compilable.getName()).replace('.', '_').replace(' ', '_');
    }

    public TruffleJavaType getDeclaringClass() {
        return TIERS[this.task.tier()];
    }

    public String toString() {
        return this.format("Truffle<%n(%p)>");
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TruffleDebugJavaMethod.TIERS[i] = new TruffleJavaType(i);
        }
    }

    public static final class TruffleSignature
    implements Signature {
        private final TruffleJavaType returnType;

        public TruffleSignature(TruffleJavaType returnType) {
            this.returnType = returnType;
        }

        public JavaType getReturnType(ResolvedJavaType accessingClass) {
            return this.returnType;
        }

        public int getParameterCount(boolean receiver) {
            return 0;
        }

        public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
            throw new IndexOutOfBoundsException();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TruffleSignature)) {
                return false;
            }
            TruffleSignature truffleSignature = (TruffleSignature)obj;
            return this.returnType.equals(truffleSignature.returnType);
        }

        public int hashCode() {
            return this.returnType.hashCode();
        }
    }

    public static final class TruffleJavaType
    implements JavaType {
        private final String name;

        TruffleJavaType(int tier) {
            this.name = "LTruffleIR/Tier" + tier + ";";
        }

        public String getName() {
            return this.name;
        }

        public JavaType getComponentType() {
            return null;
        }

        public JavaType getArrayClass() {
            throw new UnsupportedOperationException();
        }

        public JavaKind getJavaKind() {
            return JavaKind.Object;
        }

        public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TruffleJavaType) {
                TruffleJavaType t = (TruffleJavaType)obj;
                return this.getName().equals(t.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

