/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.truffle.KnownTruffleTypes;
import jdk.graal.compiler.truffle.TruffleTierConfiguration;
import jdk.graal.compiler.truffle.host.TruffleHostEnvironment;
import jdk.vm.ci.code.Architecture;

public final class TruffleCompilerConfiguration {
    private final TruffleCompilerRuntime runtime;
    private final GraphBuilderConfiguration.Plugins plugins;
    private final SnippetReflectionProvider provider;
    private final TruffleTierConfiguration firstTier;
    private final TruffleTierConfiguration lastTier;
    private final KnownTruffleTypes types;
    private final Suites hostSuite;
    private final Supplier<TruffleHostEnvironment.TruffleRuntimeScope> openCanCallTruffleRuntimeScope;

    public TruffleCompilerConfiguration(TruffleCompilerRuntime runtime, GraphBuilderConfiguration.Plugins plugins, SnippetReflectionProvider provider, TruffleTierConfiguration firstTier, TruffleTierConfiguration lastTier, KnownTruffleTypes knownTruffleTypes, Suites hostSuite, Supplier<TruffleHostEnvironment.TruffleRuntimeScope> openCanCallTruffleRuntimeScope) {
        this.runtime = runtime;
        this.plugins = plugins;
        this.provider = provider;
        this.firstTier = firstTier;
        this.lastTier = lastTier;
        this.types = knownTruffleTypes;
        this.hostSuite = hostSuite;
        this.openCanCallTruffleRuntimeScope = openCanCallTruffleRuntimeScope;
    }

    public TruffleCompilerRuntime runtime() {
        return this.runtime;
    }

    public GraphBuilderConfiguration.Plugins plugins() {
        return this.plugins;
    }

    public SnippetReflectionProvider snippetReflection() {
        return this.provider;
    }

    public TruffleTierConfiguration firstTier() {
        return this.firstTier;
    }

    public TruffleTierConfiguration lastTier() {
        return this.lastTier;
    }

    public KnownTruffleTypes types() {
        return this.types;
    }

    public Suites hostSuite() {
        return this.hostSuite;
    }

    public TruffleCompilerConfiguration withFirstTier(TruffleTierConfiguration tier) {
        return new TruffleCompilerConfiguration(this.runtime, this.plugins, this.provider, tier, this.lastTier, this.types, this.hostSuite, this.openCanCallTruffleRuntimeScope);
    }

    public List<Backend> backends() {
        if (this.lastTier.backend() == this.firstTier.backend()) {
            return Arrays.asList(this.lastTier.backend());
        }
        return Arrays.asList(this.firstTier.backend(), this.lastTier.backend());
    }

    public Architecture architecture() {
        Architecture arch = this.lastTier().backend().getTarget().arch;
        assert (arch.equals((Object)this.firstTier().backend().getTarget().arch)) : "target architecture must be the same for first and last tier.";
        return arch;
    }

    TruffleHostEnvironment.TruffleRuntimeScope openCanCallTruffleRuntimeScope() {
        return this.openCanCallTruffleRuntimeScope != null ? this.openCanCallTruffleRuntimeScope.get() : null;
    }
}

