/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public abstract class AbstractKnownTruffleTypes {
    private final TruffleCompilerRuntime runtime;
    protected final MetaAccessProvider metaAccess;
    private TypeCache typeCache;

    protected AbstractKnownTruffleTypes(TruffleCompilerRuntime runtime, MetaAccessProvider metaAccess) {
        this.runtime = runtime;
        this.metaAccess = metaAccess;
    }

    public final ResolvedJavaType lookupType(String className) {
        ResolvedJavaType type = this.runtime.resolveType(this.metaAccess, className);
        this.onTypeLookup(type);
        return type;
    }

    public final ResolvedJavaType lookupTypeOptional(String className) {
        ResolvedJavaType type = this.runtime.resolveType(this.metaAccess, className, false);
        this.onTypeLookup(type);
        return type;
    }

    protected final ResolvedJavaType lookupType(Class<?> c) {
        ResolvedJavaType type = this.metaAccess.lookupJavaType(c);
        this.onTypeLookup(type);
        return type;
    }

    protected final ResolvedJavaType lookupTypeCached(String className) {
        ResolvedJavaType type = this.runtime.resolveType(this.metaAccess, className);
        this.onTypeLookup(type);
        this.typeCache = this.createTypeCache(type);
        return this.typeCache.declaringClass;
    }

    protected final ResolvedJavaType lookupTypeCached(Class<?> c) {
        ResolvedJavaType type = this.metaAccess.lookupJavaType(c);
        this.onTypeLookup(type);
        this.typeCache = this.createTypeCache(type);
        return this.typeCache.declaringClass;
    }

    protected void onTypeLookup(ResolvedJavaType type) {
    }

    protected final ResolvedJavaMethod findMethod(ResolvedJavaType declaringClass, String name, ResolvedJavaType ... types) {
        Collection methods = this.getTypeCache((ResolvedJavaType)declaringClass).methods.get(name);
        return AbstractKnownTruffleTypes.findMethod(declaringClass, name, methods, types);
    }

    private static ResolvedJavaMethod findMethod(ResolvedJavaType declaringClass, String name, Collection<ResolvedJavaMethod> methods, ResolvedJavaType ... types) throws NoSuchMethodError {
        for (ResolvedJavaMethod method : methods) {
            assert (method.getName().equals(name));
            Signature signature = method.getSignature();
            int parameterCount = signature.getParameterCount(false);
            if (parameterCount != types.length) continue;
            boolean allValid = true;
            for (int i = 0; i < parameterCount; ++i) {
                JavaType searchType = signature.getParameterType(i, declaringClass);
                if (searchType.equals((Object)types[i])) continue;
                allValid = false;
                break;
            }
            if (!allValid) continue;
            return method;
        }
        throw new NoSuchMethodError(declaringClass.toJavaName() + "." + name + Arrays.toString(types));
    }

    ResolvedJavaMethod findMethod(ResolvedJavaType declaringClass, String name, String descriptor) {
        for (ResolvedJavaMethod method : this.getTypeCache((ResolvedJavaType)declaringClass).methods.get(name)) {
            if (!method.getSignature().toMethodDescriptor().equals(descriptor)) continue;
            return method;
        }
        throw new NoSuchMethodError(declaringClass.toJavaName() + "." + name + descriptor);
    }

    protected ResolvedJavaField[] findInstanceFields(ResolvedJavaType declaringClass) {
        return this.getTypeCache((ResolvedJavaType)declaringClass).instanceFields;
    }

    protected final ResolvedJavaField findField(ResolvedJavaType declaringClass, String name, boolean required) {
        TypeCache fc = this.getTypeCache(declaringClass);
        ResolvedJavaField field = fc.fields.get(name);
        if (field == null && required) {
            throw new GraalError("Could not find required field %s.%s", declaringClass.getName(), name);
        }
        return field;
    }

    protected final ResolvedJavaField findField(ResolvedJavaType declaringClass, String name) {
        return this.findField(declaringClass, name, true);
    }

    private TypeCache getTypeCache(ResolvedJavaType declaringClass) {
        if (this.typeCache == null || !this.typeCache.declaringClass.equals((Object)declaringClass)) {
            GraalError.shouldNotReachHere("Use lookupTypeCached instead to lookup methods or fields.");
        }
        return this.typeCache;
    }

    private TypeCache createTypeCache(ResolvedJavaType declaringClass) {
        ResolvedJavaField field;
        int i;
        GraalError.guarantee(this.typeCache == null || !declaringClass.equals((Object)this.typeCache.declaringClass), "duplicate consecutive cached type lookup");
        ResolvedJavaField[] instanceFields = declaringClass.getInstanceFields(false);
        ResolvedJavaField[] staticFields = declaringClass.getStaticFields();
        Map.Entry[] entries = new Map.Entry[instanceFields.length + staticFields.length];
        for (i = 0; i < instanceFields.length; ++i) {
            field = instanceFields[i];
            entries[i] = Map.entry(field.getName(), field);
        }
        for (i = 0; i < staticFields.length; ++i) {
            field = staticFields[i];
            entries[instanceFields.length + i] = Map.entry(field.getName(), field);
        }
        Map<String, ResolvedJavaField> fields = Map.ofEntries(entries);
        GraalError.guarantee(fields.size() == entries.length, "duplicate field name");
        HashMap<String, List<ResolvedJavaMethod>> methods = new HashMap<String, List<ResolvedJavaMethod>>();
        for (ResolvedJavaMethod method : declaringClass.getDeclaredMethods(false)) {
            methods.computeIfAbsent(method.getName(), v -> new ArrayList(2)).add(method);
        }
        return new TypeCache(declaringClass, instanceFields, fields, methods);
    }

    private record TypeCache(ResolvedJavaType declaringClass, ResolvedJavaField[] instanceFields, Map<String, ResolvedJavaField> fields, Map<String, List<ResolvedJavaMethod>> methods) {
    }
}

