/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.serviceprovider;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.options.ExcludeFromJacocoGeneratedReport;
import jdk.graal.compiler.serviceprovider.GlobalAtomicLong;
import jdk.graal.compiler.serviceprovider.JMXService;
import jdk.graal.compiler.serviceprovider.LibGraalService;
import jdk.graal.compiler.serviceprovider.SpeculationEncodingAdapter;
import jdk.graal.compiler.serviceprovider.VMSupport;
import jdk.internal.misc.VM;
import jdk.vm.ci.meta.EncodedSpeculationReason;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.services.Services;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class GraalServices {
    private static Map<Class<?>, List<?>> libgraalServices;
    private static final Module JVMCI_MODULE;
    private static final String JVMCI_RUNTIME_PACKAGE = "jdk.vm.ci.runtime";
    private static final GlobalAtomicLong globalTimeStamp;

    public static boolean isBuildingLibgraal() {
        return Services.IS_BUILDING_NATIVE_IMAGE;
    }

    public static boolean isInLibgraal() {
        return Services.IS_IN_NATIVE_IMAGE;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    @ExcludeFromJacocoGeneratedReport(value="only called when building libgraal")
    public static void setLibgraalServices(Map<Class<?>, List<?>> services) {
        GraalError.guarantee(libgraalServices == null, "Libgraal services must be set exactly once");
        libgraalServices = services;
    }

    private GraalServices() {
    }

    public static <S> Iterable<S> load(Class<S> service) {
        if (ImageInfo.inImageRuntimeCode() || libgraalServices != null) {
            List<?> list = libgraalServices.get(service);
            if (list == null) {
                throw new InternalError(String.format("No %s providers found in libgraal (missing %s annotation on %s?)", service.getName(), LibGraalService.class.getName(), service.getName()));
            }
            return list;
        }
        return GraalServices.load0(service);
    }

    public static Map<String, String> getSavedProperties() {
        if (ImageInfo.inImageBuildtimeCode()) {
            return VM.getSavedProperties();
        }
        return Services.getSavedProperties();
    }

    public static String getSavedProperty(String name, String def) {
        return GraalServices.getSavedProperties().getOrDefault(name, def);
    }

    public static String getSavedProperty(String name) {
        return GraalServices.getSavedProperties().get(name);
    }

    private static <S> Iterable<S> load0(Class<S> service) {
        Module module = GraalServices.class.getModule();
        if (!module.canUse(service)) {
            module.addUses(service);
        }
        return () -> {
            ModuleLayer layer = module.getLayer();
            final Iterator iterator = ServiceLoader.load(layer, service).iterator();
            return new Iterator<S>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public S next() {
                    Object provider = iterator.next();
                    GraalServices.openJVMCITo(provider.getClass());
                    return provider;
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        };
    }

    static void openJVMCITo(Class<?> other) {
        if (ImageInfo.inImageRuntimeCode()) {
            return;
        }
        Module jvmciModule = JVMCI_MODULE;
        Module otherModule = other.getModule();
        if (jvmciModule != otherModule) {
            for (String pkg : jvmciModule.getPackages()) {
                if (jvmciModule.isOpen(pkg, otherModule)) continue;
                JVMCI.getRuntime();
                jvmciModule.addOpens(pkg, otherModule);
            }
        }
    }

    public static <S> S loadSingle(Class<S> service, boolean required) {
        assert (!service.getName().startsWith("jdk.vm.ci")) : "JVMCI services must be loaded via " + Services.class.getName();
        Iterable<S> providers = GraalServices.load(service);
        Object singleProvider = null;
        try {
            Iterator<S> it = providers.iterator();
            while (it.hasNext()) {
                singleProvider = it.next();
                if (!it.hasNext()) continue;
                S other = it.next();
                throw new InternalError(String.format("Multiple %s providers found: %s, %s", service.getName(), singleProvider.getClass().getName(), other.getClass().getName()));
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        if (singleProvider == null && required) {
            throw new InternalError(String.format("No provider for %s found", service.getName()));
        }
        return (S)singleProvider;
    }

    public static InputStream getClassfileAsStream(Class<?> c) throws IOException {
        String classfilePath = c.getName().replace('.', '/') + ".class";
        return c.getModule().getResourceAsStream(classfilePath);
    }

    public static boolean isToStringTrusted(Class<?> c) {
        Module jvmciModule;
        if (ImageInfo.inImageRuntimeCode()) {
            return true;
        }
        Module module = c.getModule();
        return module == (jvmciModule = JVMCI_MODULE) || jvmciModule.isOpen(JVMCI_RUNTIME_PACKAGE, module);
    }

    static SpeculationLog.SpeculationReason createSpeculationReason(int groupId, String groupName, Object ... context) {
        SpeculationEncodingAdapter adapter = new SpeculationEncodingAdapter();
        Object[] flattened = adapter.flatten(context);
        return new EncodedSpeculationReason(groupId, groupName, flattened);
    }

    public static String getExecutionID() {
        return Long.toString(ProcessHandle.current().pid());
    }

    public static long getGlobalTimeStamp() {
        if (globalTimeStamp.get() == 0L) {
            globalTimeStamp.compareAndSet(0L, GraalServices.milliTimeStamp());
        }
        return globalTimeStamp.get();
    }

    public static long milliTimeStamp() {
        return System.currentTimeMillis();
    }

    public static long getThreadAllocatedBytes(long id) {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            throw new UnsupportedOperationException();
        }
        return jmx.getThreadAllocatedBytes(id);
    }

    public static long getCurrentThreadAllocatedBytes() {
        return GraalServices.getThreadAllocatedBytes(GraalServices.getCurrentThreadId());
    }

    public static long getThreadId(Thread thread) {
        return thread.getId();
    }

    public static long getCurrentThreadId() {
        return GraalServices.getThreadId(Thread.currentThread());
    }

    public static long getCurrentThreadCpuTime() {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            throw new UnsupportedOperationException();
        }
        return jmx.getCurrentThreadCpuTime();
    }

    public static boolean isThreadAllocatedMemorySupported() {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            return false;
        }
        return jmx.isThreadAllocatedMemorySupported();
    }

    public static boolean isCurrentThreadCpuTimeSupported() {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            return false;
        }
        return jmx.isCurrentThreadCpuTimeSupported();
    }

    public static List<String> getInputArguments() {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            return null;
        }
        return jmx.getInputArguments();
    }

    public static float fma(float a, float b, float c) {
        return Math.fma(a, b, c);
    }

    public static double fma(double a, double b, double c) {
        return Math.fma(a, b, c);
    }

    public static int getJavaUpdateVersion() {
        return Runtime.version().update();
    }

    public static void notifyLowMemoryPoint(boolean forceFullGC) {
        GraalServices.notifyLowMemoryPoint(true, forceFullGC);
    }

    public static void notifyLowMemoryPoint() {
        GraalServices.notifyLowMemoryPoint(false, false);
    }

    private static void notifyLowMemoryPoint(boolean hintFullGC, boolean forceFullGC) {
        VMSupport.notifyLowMemoryPoint(hintFullGC, forceFullGC);
    }

    static {
        JVMCI_MODULE = Services.class.getModule();
        assert (JVMCI_MODULE.getPackages().contains(JVMCI_RUNTIME_PACKAGE));
        globalTimeStamp = new GlobalAtomicLong(0L);
    }
}

