/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.serviceprovider;

import java.lang.ref.Cleaner;
import jdk.internal.misc.Unsafe;

public class GlobalAtomicLong {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static Cleaner cleaner;
    private volatile long address;
    private final long initialValue;

    public GlobalAtomicLong(long initialValue) {
        this.initialValue = initialValue;
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public String toString() {
        long addr = this.getAddress();
        if (addr == 0L) {
            return String.valueOf(this.initialValue);
        }
        return String.format("%d (@0x%x)", this.get(), addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getAddress() {
        if (this.address != 0L) return this.address;
        GlobalAtomicLong globalAtomicLong = this;
        synchronized (globalAtomicLong) {
            if (this.address != 0L) return this.address;
            long addr = UNSAFE.allocateMemory(8L);
            Class<GlobalAtomicLong> clazz = GlobalAtomicLong.class;
            synchronized (GlobalAtomicLong.class) {
                if (cleaner == null) {
                    cleaner = Cleaner.create();
                }
                cleaner.register(this, () -> UNSAFE.freeMemory(addr));
                // ** MonitorExit[var4_3] (shouldn't be in output)
                UNSAFE.putLongVolatile(null, addr, this.initialValue);
                this.address = addr;
                return this.address;
            }
        }
    }

    public long get() {
        return UNSAFE.getLongVolatile(null, this.getAddress());
    }

    public void set(long newValue) {
        UNSAFE.putLongVolatile(null, this.getAddress(), newValue);
    }

    public long getAndSet(long newValue) {
        return UNSAFE.getAndSetLong(null, this.getAddress(), newValue);
    }

    public long getAndAdd(long delta) {
        return UNSAFE.getAndAddLong(null, this.getAddress(), delta);
    }

    public long addAndGet(long delta) {
        return this.getAndAdd(delta) + delta;
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public long getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    public boolean compareAndSet(long expectedValue, long newValue) {
        return UNSAFE.compareAndSetLong(null, this.getAddress(), expectedValue, newValue);
    }
}

