/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_2, cyclesRationale="neg+cmp", size=NodeSize.SIZE_2)
public final class IntegerNegExactSplitNode
extends IntegerExactArithmeticSplitNode {
    public static final NodeClass<IntegerNegExactSplitNode> TYPE = NodeClass.create(IntegerNegExactSplitNode.class);
    @Node.Input
    protected ValueNode value;

    public IntegerNegExactSplitNode(Stamp stamp, ValueNode value, AbstractBeginNode next, AbstractBeginNode overflowSuccessor) {
        super(TYPE, stamp, next, overflowSuccessor);
        this.value = value;
    }

    @Override
    protected Value generateArithmetic(NodeLIRBuilderTool gen) {
        return gen.getLIRGeneratorTool().getArithmetic().emitNegate(gen.operand(this.value), true);
    }

    public ValueNode getValue() {
        return this.value;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        NodeView view = NodeView.from(tool);
        if (!IntegerStamp.negateCanOverflow((IntegerStamp)this.value.stamp(view))) {
            tool.deleteBranch(this.overflowSuccessor);
            tool.addToWorkList(this.next);
            NegateNode replacement = this.graph().unique(new NegateNode(this.value));
            this.graph().replaceSplitWithFloating(this, replacement, this.next);
            tool.addToWorkList(replacement);
        }
    }
}

