/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import java.util.List;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerNegExactNode;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerNegExactSplitNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_4, cyclesRationale="neg+cmp", size=NodeSize.SIZE_2)
public class IntegerNegExactOverflowNode
extends LogicNode
implements Simplifiable,
Canonicalizable {
    public static final NodeClass<IntegerNegExactOverflowNode> TYPE = NodeClass.create(IntegerNegExactOverflowNode.class);
    @Node.Input
    protected ValueNode value;

    public IntegerNegExactOverflowNode(ValueNode value) {
        super((NodeClass<? extends LogicNode>)TYPE);
        this.value = value;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (this.value.isConstant()) {
            JavaConstant cst = this.value.asJavaConstant();
            try {
                if (cst.getJavaKind() == JavaKind.Int) {
                    Math.negateExact(cst.asInt());
                } else {
                    assert (cst.getJavaKind() == JavaKind.Long) : Assertions.errorMessage(cst);
                    Math.negateExact(cst.asLong());
                }
            }
            catch (ArithmeticException ex) {
                return LogicConstantNode.forBoolean(true);
            }
            return LogicConstantNode.forBoolean(false);
        }
        if (!IntegerStamp.negateCanOverflow((IntegerStamp)this.value.stamp(NodeView.DEFAULT))) {
            return LogicConstantNode.forBoolean(false);
        }
        return this;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        for (IfNode ifNode : this.usages().filter(IfNode.class).snapshot()) {
            AbstractBeginNode next = ifNode.falseSuccessor();
            AbstractBeginNode overflow = ifNode.trueSuccessor();
            ifNode.clearSuccessors();
            List<IntegerNegExactNode> coupledNodes = next.usages().filter(IntegerNegExactNode.class).filter(n -> this.value == ((IntegerNegExactNode)n).getValue()).snapshot();
            Stamp splitStamp = this.value.stamp(NodeView.DEFAULT).unrestricted();
            if (!coupledNodes.isEmpty()) {
                splitStamp = ((IntegerNegExactNode)coupledNodes.iterator().next()).stamp(NodeView.DEFAULT);
            }
            IntegerExactArithmeticSplitNode split = this.graph().add(new IntegerNegExactSplitNode(splitStamp, this.value, next, overflow));
            ifNode.replaceAndDelete(split);
            coupledNodes.forEach(n -> n.replaceAndDelete(split));
        }
    }
}

