/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.extended.GuardedNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerNegExactNode
extends NegateNode
implements GuardedNode,
IntegerExactArithmeticNode,
IterableNodeType {
    public static final NodeClass<IntegerNegExactNode> TYPE = NodeClass.create(IntegerNegExactNode.class);
    @Node.Input(value=InputType.Guard)
    protected GuardingNode guard;

    public IntegerNegExactNode(ValueNode value, GuardingNode guard) {
        super(TYPE, value);
        this.setStamp(value.stamp(NodeView.DEFAULT).unrestricted());
        this.guard = guard;
    }

    @Override
    public boolean inferStamp() {
        return false;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        IntegerStamp integerStamp = (IntegerStamp)newStamp;
        if (IntegerStamp.negateCanOverflow(integerStamp)) {
            return integerStamp.unrestricted();
        }
        return super.foldStamp(newStamp);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isConstant()) {
            JavaConstant cst = forValue.asJavaConstant();
            try {
                if (cst.getJavaKind() == JavaKind.Int) {
                    return ConstantNode.forInt(Math.negateExact(cst.asInt()));
                }
                assert (cst.getJavaKind() == JavaKind.Long) : Assertions.errorMessage(cst);
                return ConstantNode.forLong(Math.negateExact(cst.asLong()));
            }
            catch (ArithmeticException arithmeticException) {
                return this;
            }
        }
        if (!IntegerStamp.negateCanOverflow((IntegerStamp)forValue.stamp(NodeView.DEFAULT))) {
            return (ValueNode)new NegateNode(forValue).canonical(tool);
        }
        return this;
    }

    @Override
    public GuardingNode getGuard() {
        return this.guard;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.guard, guard);
        this.guard = guard;
    }
}

