/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactOverflowNode;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerMulExactNode;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerMulExactSplitNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_4, cyclesRationale="mul+cmp", size=NodeSize.SIZE_2)
public class IntegerMulExactOverflowNode
extends IntegerExactOverflowNode
implements Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<IntegerMulExactOverflowNode> TYPE = NodeClass.create(IntegerMulExactOverflowNode.class);

    public IntegerMulExactOverflowNode(ValueNode x, ValueNode y) {
        super(TYPE, x, y);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        long c;
        if (forX.isConstant() && !forY.isConstant()) {
            return (ValueNode)new IntegerMulExactOverflowNode(forY, forX).canonical(tool);
        }
        if (forX.isConstant() && forY.isConstant()) {
            return IntegerMulExactOverflowNode.canonicalXYconstant(forX, forY);
        }
        if (forY.isConstant() && ((c = forY.asJavaConstant().asLong()) == 1L || c == 0L)) {
            return LogicConstantNode.forBoolean(false);
        }
        if (!IntegerStamp.multiplicationCanOverflow((IntegerStamp)this.x.stamp(NodeView.DEFAULT), (IntegerStamp)this.y.stamp(NodeView.DEFAULT))) {
            return LogicConstantNode.forBoolean(false);
        }
        return this;
    }

    private static LogicConstantNode canonicalXYconstant(ValueNode forX, ValueNode forY) {
        JavaConstant xConst = forX.asJavaConstant();
        JavaConstant yConst = forY.asJavaConstant();
        assert (xConst.getJavaKind() == yConst.getJavaKind()) : Assertions.errorMessageContext("x", xConst, "y", yConst);
        try {
            if (xConst.getJavaKind() == JavaKind.Int) {
                Math.multiplyExact(xConst.asInt(), yConst.asInt());
            } else {
                assert (xConst.getJavaKind() == JavaKind.Long) : Assertions.errorMessage(forX, forY);
                Math.multiplyExact(xConst.asLong(), yConst.asLong());
            }
        }
        catch (ArithmeticException ex) {
            return LogicConstantNode.forBoolean(true);
        }
        return LogicConstantNode.forBoolean(false);
    }

    @Override
    protected IntegerExactArithmeticSplitNode createSplit(Stamp splitStamp, AbstractBeginNode next, AbstractBeginNode overflow) {
        return new IntegerMulExactSplitNode(splitStamp, this.x, this.y, next, overflow);
    }

    @Override
    protected Class<? extends BinaryNode> getCoupledType() {
        return IntegerMulExactNode.class;
    }
}

