/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import java.util.List;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public abstract class IntegerExactOverflowNode
extends LogicNode
implements Canonicalizable.Binary<ValueNode>,
Simplifiable {
    public static final NodeClass<IntegerExactOverflowNode> TYPE = NodeClass.create(IntegerExactOverflowNode.class);
    @Node.Input
    protected ValueNode x;
    @Node.Input
    protected ValueNode y;

    public IntegerExactOverflowNode(NodeClass<? extends IntegerExactOverflowNode> c, ValueNode x, ValueNode y) {
        super((NodeClass<? extends LogicNode>)c);
        this.x = x;
        this.y = y;
    }

    @Override
    public ValueNode getX() {
        return this.x;
    }

    @Override
    public ValueNode getY() {
        return this.y;
    }

    public LogicNode maybeCommuteInputs() {
        assert (this instanceof Canonicalizable.BinaryCommutative) : this;
        if (!this.y.isConstant() && (this.x.isConstant() || this.x.getId() > this.y.getId())) {
            LogicNode duplicate;
            ValueNode tmp = this.x;
            this.x = this.y;
            this.y = tmp;
            if (this.graph() != null && (duplicate = (LogicNode)this.graph().findDuplicate(this)) != null) {
                return duplicate;
            }
        }
        return this;
    }

    protected abstract IntegerExactArithmeticSplitNode createSplit(Stamp var1, AbstractBeginNode var2, AbstractBeginNode var3);

    protected abstract Class<? extends BinaryNode> getCoupledType();

    @Override
    public void simplify(SimplifierTool tool) {
        for (IfNode ifNode : this.usages().filter(IfNode.class).snapshot()) {
            AbstractBeginNode next = ifNode.falseSuccessor();
            AbstractBeginNode overflow = ifNode.trueSuccessor();
            ifNode.clearSuccessors();
            List<BinaryNode> coupledNodes = next.usages().filter(this.getCoupledType()).filter(n -> {
                BinaryNode exact = (BinaryNode)n;
                return exact.getX() == this.getX() && exact.getY() == this.getY();
            }).snapshot();
            Stamp splitStamp = this.x.stamp(NodeView.DEFAULT).unrestricted();
            if (!coupledNodes.isEmpty()) {
                splitStamp = ((BinaryNode)coupledNodes.iterator().next()).stamp(NodeView.DEFAULT);
            }
            IntegerExactArithmeticSplitNode split = this.graph().add(this.createSplit(splitStamp, next, overflow));
            ifNode.replaceAndDelete(split);
            coupledNodes.forEach(n -> n.replaceAndDelete(split));
        }
    }
}

