/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.vm.ci.meta.Value;

@NodeInfo
public abstract class IntegerExactArithmeticSplitNode
extends ControlSplitNode
implements Simplifiable,
LIRLowerable {
    public static final NodeClass<IntegerExactArithmeticSplitNode> TYPE = NodeClass.create(IntegerExactArithmeticSplitNode.class);
    @Node.Successor
    AbstractBeginNode next;
    @Node.Successor
    AbstractBeginNode overflowSuccessor;

    protected IntegerExactArithmeticSplitNode(NodeClass<? extends IntegerExactArithmeticSplitNode> c, Stamp stamp, AbstractBeginNode next, AbstractBeginNode overflowSuccessor) {
        super((NodeClass<? extends ControlSplitNode>)c, stamp);
        this.overflowSuccessor = overflowSuccessor;
        this.next = next;
    }

    @Override
    public AbstractBeginNode getPrimarySuccessor() {
        return this.next;
    }

    @Override
    public double probability(AbstractBeginNode successor) {
        return successor == this.next ? this.getProfileData().getDesignatedSuccessorProbability() : this.getProfileData().getNegatedProbability();
    }

    @Override
    public boolean setProbability(AbstractBeginNode successor, ProfileData.BranchProbabilityData profileData) {
        return false;
    }

    @Override
    public ProfileData.BranchProbabilityData getProfileData() {
        return BranchProbabilityNode.ALWAYS_TAKEN_PROFILE;
    }

    public AbstractBeginNode getNext() {
        return this.next;
    }

    public AbstractBeginNode getOverflowSuccessor() {
        return this.overflowSuccessor;
    }

    public void setNext(AbstractBeginNode next) {
        this.updatePredecessor(this.next, next);
        this.next = next;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.setResult(this, this.generateArithmetic(generator));
        generator.emitOverflowCheckBranch(this.getOverflowSuccessor(), this.getNext(), this.stamp, this.probability(this.getOverflowSuccessor()));
    }

    protected abstract Value generateArithmetic(NodeLIRBuilderTool var1);

    @Override
    public int getSuccessorCount() {
        return 2;
    }
}

