/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.GenerateStub;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.ForeignCalls;
import jdk.graal.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public class VectorizedMismatchNode
extends PureFunctionStubIntrinsicNode {
    public static final NodeClass<VectorizedMismatchNode> TYPE = NodeClass.create(VectorizedMismatchNode.class);
    public static final ForeignCallDescriptor STUB = ForeignCalls.pureFunctionForeignCallDescriptor("vectorizedMismatch", Integer.TYPE, Pointer.class, Pointer.class, Integer.TYPE, Integer.TYPE);
    @Node.Input
    protected ValueNode arrayA;
    @Node.Input
    protected ValueNode arrayB;
    @Node.Input
    protected ValueNode length;
    @Node.Input
    protected ValueNode stride;

    public VectorizedMismatchNode(ValueNode arrayA, ValueNode arrayB, ValueNode length, ValueNode stride) {
        this(TYPE, arrayA, arrayB, length, stride, null);
    }

    public VectorizedMismatchNode(ValueNode arrayA, ValueNode arrayB, ValueNode length, ValueNode stride, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(TYPE, arrayA, arrayB, length, stride, runtimeCheckedCPUFeatures);
    }

    protected VectorizedMismatchNode(NodeClass<? extends VectorizedMismatchNode> c, ValueNode arrayA, ValueNode arrayB, ValueNode length, ValueNode stride, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(c, StampFactory.forKind(JavaKind.Int), runtimeCheckedCPUFeatures, LocationIdentity.ANY_LOCATION);
        this.arrayA = arrayA;
        this.arrayB = arrayB;
        this.length = length;
        this.stride = stride;
    }

    @Node.NodeIntrinsic
    @GenerateStub
    public static native int vectorizedMismatch(Pointer var0, Pointer var1, int var2, int var3);

    @Node.NodeIntrinsic
    public static native int vectorizedMismatch(Pointer var0, Pointer var1, int var2, int var3, @Node.ConstantNodeParameter EnumSet<?> var4);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.arrayA, this.arrayB, this.length, this.stride};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitVectorizedMismatch(this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arrayA), gen.operand(this.arrayB), gen.operand(this.length), gen.operand(this.stride)));
    }

    public static boolean isSupported(Architecture arch) {
        if (arch instanceof AMD64) {
            return true;
        }
        return arch instanceof AArch64;
    }
}

