/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;

@NodeInfo(nameTemplate="MathIntrinsic#{p#operation/s}", cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_1)
public final class UnaryMathIntrinsicNode
extends UnaryNode
implements ArithmeticLIRLowerable,
Lowerable {
    public static final NodeClass<UnaryMathIntrinsicNode> TYPE = NodeClass.create(UnaryMathIntrinsicNode.class);
    protected final UnaryOperation operation;

    public UnaryOperation getOperation() {
        return this.operation;
    }

    public static ValueNode create(ValueNode value, UnaryOperation op) {
        ValueNode c = UnaryMathIntrinsicNode.tryConstantFold(value, op);
        if (c != null) {
            return c;
        }
        return new UnaryMathIntrinsicNode(value, op);
    }

    protected static ValueNode tryConstantFold(ValueNode value, UnaryOperation op) {
        if (value.isConstant()) {
            return ConstantNode.forDouble(UnaryOperation.compute(op, value.asJavaConstant().asDouble()));
        }
        return null;
    }

    protected UnaryMathIntrinsicNode(ValueNode value, UnaryOperation op) {
        super(TYPE, UnaryOperation.computeStamp(op, value.stamp(NodeView.DEFAULT)), value);
        assert (value.stamp(NodeView.DEFAULT) instanceof FloatStamp) : Assertions.errorMessageContext("value", value);
        assert (PrimitiveStamp.getBits(value.stamp(NodeView.DEFAULT)) == 64) : value;
        this.operation = op;
    }

    @Override
    public Stamp foldStamp(Stamp valueStamp) {
        return UnaryOperation.computeStamp(this.operation, valueStamp);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value input = nodeValueMap.operand(this.getValue());
        nodeValueMap.setResult(this, switch (this.getOperation().ordinal()) {
            case 0 -> gen.emitMathLog(input, false);
            case 1 -> gen.emitMathLog(input, true);
            case 6 -> gen.emitMathExp(input);
            case 2 -> gen.emitMathSin(input);
            case 3 -> gen.emitMathCos(input);
            case 4 -> gen.emitMathTan(input);
            case 5 -> gen.emitMathTanh(input);
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.getOperation());
        });
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode c = UnaryMathIntrinsicNode.tryConstantFold(forValue, this.getOperation());
        if (c != null) {
            return c;
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native double compute(double var0, @Node.ConstantNodeParameter UnaryOperation var2);

    public static enum UnaryOperation {
        LOG(new ForeignCallSignature("arithmeticLog", Double.TYPE, Double.TYPE)),
        LOG10(new ForeignCallSignature("arithmeticLog10", Double.TYPE, Double.TYPE)),
        SIN(new ForeignCallSignature("arithmeticSin", Double.TYPE, Double.TYPE)),
        COS(new ForeignCallSignature("arithmeticCos", Double.TYPE, Double.TYPE)),
        TAN(new ForeignCallSignature("arithmeticTan", Double.TYPE, Double.TYPE)),
        TANH(new ForeignCallSignature("arithmeticTanh", Double.TYPE, Double.TYPE)),
        EXP(new ForeignCallSignature("arithmeticExp", Double.TYPE, Double.TYPE));

        public final ForeignCallSignature foreignCallSignature;

        private UnaryOperation(ForeignCallSignature foreignCallSignature) {
            this.foreignCallSignature = foreignCallSignature;
        }

        public static double compute(UnaryOperation op, double value) {
            switch (op.ordinal()) {
                case 0: {
                    return Math.log(value);
                }
                case 1: {
                    return Math.log10(value);
                }
                case 6: {
                    return Math.exp(value);
                }
                case 2: {
                    return Math.sin(value);
                }
                case 3: {
                    return Math.cos(value);
                }
                case 4: {
                    return Math.tan(value);
                }
                case 5: {
                    return Math.tanh(value);
                }
            }
            throw new GraalError("unknown op %s", new Object[]{op});
        }

        public static Stamp computeStamp(UnaryOperation op, Stamp valueStamp) {
            if (valueStamp.isEmpty()) {
                return StampFactory.forKind(JavaKind.Double).empty();
            }
            if (valueStamp instanceof FloatStamp) {
                FloatStamp floatStamp = (FloatStamp)valueStamp;
                switch (op.ordinal()) {
                    case 2: 
                    case 3: 
                    case 5: {
                        boolean nonNaN = floatStamp.lowerBound() != Double.NEGATIVE_INFINITY && floatStamp.upperBound() != Double.POSITIVE_INFINITY && floatStamp.isNonNaN();
                        return StampFactory.forFloat(JavaKind.Double, -1.0, 1.0, nonNaN);
                    }
                    case 4: {
                        boolean nonNaN = floatStamp.lowerBound() != Double.NEGATIVE_INFINITY && floatStamp.upperBound() != Double.POSITIVE_INFINITY && floatStamp.isNonNaN();
                        return StampFactory.forFloat(JavaKind.Double, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, nonNaN);
                    }
                    case 0: 
                    case 1: {
                        double lowerBound = UnaryOperation.compute(op, floatStamp.lowerBound());
                        double upperBound = UnaryOperation.compute(op, floatStamp.upperBound());
                        if (floatStamp.contains(0.0)) {
                            lowerBound = Double.NEGATIVE_INFINITY;
                        }
                        boolean nonNaN = floatStamp.lowerBound() >= 0.0 && floatStamp.isNonNaN();
                        return StampFactory.forFloat(JavaKind.Double, lowerBound, upperBound, nonNaN);
                    }
                    case 6: {
                        double lowerBound = Math.exp(floatStamp.lowerBound());
                        double upperBound = Math.exp(floatStamp.upperBound());
                        boolean nonNaN = floatStamp.isNonNaN();
                        return StampFactory.forFloat(JavaKind.Double, lowerBound, upperBound, nonNaN);
                    }
                }
            }
            return StampFactory.forKind(JavaKind.Double);
        }
    }
}

