/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

@NodeInfo(nameTemplate="ReadRegister %{p#register}", cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class ReadRegisterNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<ReadRegisterNode> TYPE = NodeClass.create(ReadRegisterNode.class);
    protected final Register register;
    protected final boolean directUse;
    protected final boolean incoming;

    public ReadRegisterNode(Register register, JavaKind kind, boolean directUse, boolean incoming) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(kind));
        assert (register != null);
        this.register = register;
        this.directUse = directUse;
        this.incoming = incoming;
    }

    public ReadRegisterNode(@Node.InjectedNodeParameter Stamp stamp, Register register, boolean directUse, boolean incoming) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        assert (register != null);
        this.register = register;
        this.directUse = directUse;
        this.incoming = incoming;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        LIRKind kind = generator.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        Object result = this.register.asValue((ValueKind)kind);
        if (this.incoming) {
            ((LIRGenerator)generator.getLIRGeneratorTool()).emitIncomingValues(new Value[]{result});
        }
        if (!this.directUse) {
            result = generator.getLIRGeneratorTool().emitReadRegister(this.register, kind);
        }
        generator.setResult(this, (Value)result);
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(Verbosity.Name) + "%" + String.valueOf(this.register);
        }
        return super.toString(verbosity);
    }
}

