/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.ConstantReflectionUtil;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public class ProfileBooleanNode
extends MacroNode
implements Simplifiable {
    public static final NodeClass<ProfileBooleanNode> TYPE = NodeClass.create(ProfileBooleanNode.class);
    private final ConstantReflectionProvider constantProvider;

    public ProfileBooleanNode(ConstantReflectionProvider constantProvider, MacroNode.MacroParams p) {
        super(TYPE, p);
        this.constantProvider = constantProvider;
    }

    ValueNode getResult() {
        return this.getArgument(0);
    }

    ValueNode getCounters() {
        return this.getArgument(1);
    }

    @Override
    public void simplify(SimplifierTool b) {
        ValueNode result = this.getResult();
        if (result.isConstant()) {
            this.replaceAtUsages(result);
            this.graph().removeFixed(this);
            return;
        }
        ValueNode counters = this.getCounters();
        if (counters.isConstant()) {
            ValueNode newResult = result;
            int[] counts = ConstantReflectionUtil.loadIntArrayConstant(this.constantProvider, (JavaConstant)counters.asConstant(), 2);
            if (counts != null && counts.length == 2) {
                int trueCount = counts[1];
                int falseCount = counts[0];
                int totalCount = trueCount + falseCount;
                if (totalCount == 0) {
                    this.graph().addBeforeFixed(this, this.graph().addOrUniqueWithInputs(new FixedGuardNode(LogicConstantNode.contradiction(), DeoptimizationReason.TransferToInterpreter, DeoptimizationAction.InvalidateReprofile, false)));
                } else if (falseCount == 0 || trueCount == 0) {
                    boolean expected = falseCount == 0;
                    LogicNode condition = this.graph().addOrUniqueWithInputs(IntegerEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), null, result, ConstantNode.forBoolean(!expected), NodeView.DEFAULT));
                    this.graph().addBeforeFixed(this, this.graph().add(new FixedGuardNode(condition, DeoptimizationReason.UnreachedCode, DeoptimizationAction.InvalidateReprofile, true)));
                    newResult = this.graph().unique(ConstantNode.forBoolean(expected));
                }
            }
            this.replaceAtUsages(newResult);
            this.graph().removeFixed(this);
        }
    }
}

