/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.Collections;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.spi.ArrayLengthProvider;
import jdk.graal.compiler.nodes.spi.VirtualizableAllocation;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public interface ObjectClone
extends StateSplit,
VirtualizableAllocation,
ArrayLengthProvider {
    public ValueNode getObject();

    public int bci();

    public static Stamp computeStamp(ValueNode object, Stamp currentStamp) {
        if (ObjectClone.getConcreteType(object.stamp(NodeView.DEFAULT)) != null) {
            return AbstractPointerStamp.pointerNonNull(object.stamp(NodeView.DEFAULT));
        }
        return AbstractPointerStamp.pointerMaybeNull(currentStamp);
    }

    public static ResolvedJavaType getConcreteType(Stamp forStamp) {
        if (!(forStamp instanceof ObjectStamp)) {
            return null;
        }
        ObjectStamp objectStamp = (ObjectStamp)forStamp;
        if (objectStamp.type() == null) {
            return null;
        }
        if (objectStamp.isExactType()) {
            return objectStamp.type().isCloneableWithAllocation() ? objectStamp.type() : null;
        }
        if (objectStamp.type().isArray()) {
            return objectStamp.type();
        }
        return null;
    }

    default public LoadFieldNode genLoadFieldNode(Assumptions assumptions, ValueNode originalAlias, ResolvedJavaField field) {
        return LoadFieldNode.create(assumptions, originalAlias, field);
    }

    default public LoadIndexedNode genLoadIndexedNode(Assumptions assumptions, ValueNode originalAlias, ValueNode index, JavaKind elementKind) {
        return new LoadIndexedNode(assumptions, originalAlias, index, null, elementKind);
    }

    @Override
    default public void virtualize(VirtualizerTool tool) {
        ValueNode original = this.getObject();
        ValueNode originalAlias = tool.getAlias(original);
        NodeSourcePosition sourcePosition = original.getNodeSourcePosition();
        if (originalAlias instanceof VirtualObjectNode) {
            VirtualObjectNode originalVirtual = (VirtualObjectNode)originalAlias;
            if (originalVirtual.type().isCloneableWithAllocation()) {
                ValueNode[] newEntryState = new ValueNode[originalVirtual.entryCount()];
                for (int i = 0; i < newEntryState.length; ++i) {
                    newEntryState[i] = tool.getEntry(originalVirtual, i);
                }
                VirtualObjectNode newVirtual = originalVirtual.duplicate();
                tool.createVirtualObject(newVirtual, newEntryState, Collections.emptyList(), null, false);
                tool.replaceWithVirtual(newVirtual);
            }
        } else {
            ResolvedJavaType type = ObjectClone.getConcreteType(originalAlias.stamp(NodeView.DEFAULT));
            if (type == null) {
                return;
            }
            if (!type.isArray()) {
                VirtualInstanceNode newVirtual = new VirtualInstanceNode(type, true);
                ResolvedJavaField[] fields = newVirtual.getFields();
                ValueNode[] state = new ValueNode[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    LoadFieldNode load = this.genLoadFieldNode(this.asNode().graph().getAssumptions(), originalAlias, fields[i]);
                    state[i] = load;
                    tool.addNode(load);
                }
                tool.createVirtualObject(newVirtual, state, Collections.emptyList(), sourcePosition, false);
                tool.replaceWithVirtual(newVirtual);
            } else {
                ValueNode length = this.findLength(ArrayLengthProvider.FindLengthMode.SEARCH_ONLY, tool.getConstantReflection());
                if (length == null) {
                    return;
                }
                ValueNode lengthAlias = tool.getAlias(length);
                if (!lengthAlias.isConstant()) {
                    return;
                }
                int constantLength = lengthAlias.asJavaConstant().asInt();
                if (constantLength >= 0 && constantLength <= tool.getMaximumEntryCount()) {
                    ValueNode[] state = new ValueNode[constantLength];
                    ResolvedJavaType componentType = type.getComponentType();
                    for (int i = 0; i < constantLength; ++i) {
                        ConstantNode index = ConstantNode.forInt(i);
                        LoadIndexedNode load = this.genLoadIndexedNode(this.asNode().graph().getAssumptions(), originalAlias, index, componentType.getJavaKind());
                        state[i] = load;
                        tool.addNode(index);
                        tool.addNode(load);
                    }
                    VirtualArrayNode virtualObject = new VirtualArrayNode(componentType, constantLength);
                    tool.createVirtualObject(virtualObject, state, Collections.emptyList(), sourcePosition, false);
                    tool.replaceWithVirtual(virtualObject);
                }
            }
        }
    }

    @Override
    default public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
        return GraphUtil.arrayLength(this.getObject(), mode, constantReflection);
    }
}

