/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.MacroWithExceptionNode;
import jdk.graal.compiler.replacements.nodes.MethodHandleNode;
import jdk.vm.ci.meta.MethodHandleAccessProvider;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="see MacroNode", size=NodeSize.SIZE_UNKNOWN, sizeRationale="see MacroNode")
public final class MethodHandleWithExceptionNode
extends MacroWithExceptionNode
implements Simplifiable {
    public static final NodeClass<MethodHandleWithExceptionNode> TYPE = NodeClass.create(MethodHandleWithExceptionNode.class);
    protected final MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod;

    public MethodHandleWithExceptionNode(MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod, MacroNode.MacroParams p) {
        super(TYPE, p);
        this.intrinsicMethod = intrinsicMethod;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        MethodHandleAccessProvider methodHandleAccess = tool.getConstantReflection().getMethodHandleAccess();
        this.trySimplify(methodHandleAccess);
    }

    public WithExceptionNode trySimplify(MethodHandleAccessProvider methodHandleAccess) {
        MethodHandleNode.InvokeFactory<InvokeWithExceptionNode> invokeFactory;
        ValueNode[] argumentsArray = this.arguments.toArray((A[])new ValueNode[this.arguments.size()]);
        MethodHandleNode.GraphAdder adder = MethodHandleNode.getGraphAdderBeforeNode(this);
        InvokeWithExceptionNode invoke = MethodHandleNode.tryResolveTargetInvoke(adder, invokeFactory = (callTarget, bi, stmp) -> {
            InvokeWithExceptionNode invoke = new InvokeWithExceptionNode(callTarget, null, bi);
            invoke.setStamp(stmp);
            return invoke;
        }, methodHandleAccess, this.intrinsicMethod, this.targetMethod, this.bci, this.returnStamp, argumentsArray);
        if (invoke == null) {
            return this;
        }
        assert (invoke.graph() == null);
        invoke.setNodeSourcePosition(this.getNodeSourcePosition());
        invoke = this.graph().addOrUniqueWithInputs(invoke);
        invoke.setStateAfter(this.stateAfter());
        this.graph().replaceWithExceptionSplit(this, invoke);
        return invoke;
    }
}

