/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.GenerateStub;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory})
public abstract class MessageDigestNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<MessageDigestNode> TYPE = NodeClass.create(MessageDigestNode.class);
    private static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Int), NamedLocationIdentity.getArrayLocation(JavaKind.Long)};
    @Node.Input
    protected ValueNode buf;
    @Node.Input
    protected ValueNode state;

    private static ForeignCallDescriptor foreignCallDescriptor(String name) {
        return new ForeignCallDescriptor(name, Void.TYPE, new Class[]{Pointer.class, Pointer.class}, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, KILLED_LOCATIONS, false, false);
    }

    public MessageDigestNode(NodeClass<? extends MessageDigestNode> c, ValueNode buf, ValueNode state, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(c, StampFactory.forVoid(), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.buf = buf;
        this.state = state;
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.buf, this.state};
    }

    @NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_64)
    public static final class MD5Node
    extends MessageDigestNode {
        public static final NodeClass<MD5Node> TYPE = NodeClass.create(MD5Node.class);
        public static final ForeignCallDescriptor STUB = MessageDigestNode.foreignCallDescriptor("md5ImplCompress");

        public MD5Node(ValueNode buf, ValueNode state) {
            super(TYPE, buf, state, null);
        }

        public MD5Node(ValueNode buf, ValueNode state, EnumSet<?> runtimeCheckedCPUFeatures) {
            super(TYPE, buf, state, runtimeCheckedCPUFeatures);
        }

        @Override
        public ForeignCallDescriptor getForeignCallDescriptor() {
            return STUB;
        }

        @Override
        public void emitIntrinsic(NodeLIRBuilderTool gen) {
            gen.getLIRGeneratorTool().emitMD5ImplCompress(gen.operand(this.buf), gen.operand(this.state));
        }

        @Node.NodeIntrinsic
        @GenerateStub(name="md5ImplCompress")
        public static native void md5ImplCompress(Pointer var0, Pointer var1);

        @Node.NodeIntrinsic
        public static native void md5ImplCompress(Pointer var0, Pointer var1, @Node.ConstantNodeParameter EnumSet<?> var2);
    }

    @NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_256)
    public static final class SHA512Node
    extends MessageDigestNode {
        public static final NodeClass<SHA512Node> TYPE = NodeClass.create(SHA512Node.class);
        public static final ForeignCallDescriptor STUB = MessageDigestNode.foreignCallDescriptor("sha512ImplCompress");

        public SHA512Node(ValueNode buf, ValueNode state) {
            super(TYPE, buf, state, null);
        }

        public SHA512Node(ValueNode buf, ValueNode state, EnumSet<?> runtimeCheckedCPUFeatures) {
            super(TYPE, buf, state, runtimeCheckedCPUFeatures);
        }

        public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
            return EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, AMD64.CPUFeature.BMI2);
        }

        public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
            return EnumSet.of(AArch64.CPUFeature.SHA512);
        }

        public static boolean isSupported(Architecture arch) {
            if (arch instanceof AMD64) {
                return ((AMD64)arch).getFeatures().containsAll(SHA512Node.minFeaturesAMD64());
            }
            if (arch instanceof AArch64) {
                return ((AArch64)arch).getFeatures().containsAll(SHA512Node.minFeaturesAARCH64());
            }
            return false;
        }

        @Override
        public boolean canBeEmitted(Architecture arch) {
            return SHA512Node.isSupported(arch);
        }

        @Override
        public ForeignCallDescriptor getForeignCallDescriptor() {
            return STUB;
        }

        @Override
        public void emitIntrinsic(NodeLIRBuilderTool gen) {
            gen.getLIRGeneratorTool().emitSha512ImplCompress(gen.operand(this.buf), gen.operand(this.state));
        }

        @Node.NodeIntrinsic
        @GenerateStub(name="sha512ImplCompress", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")
        public static native void sha512ImplCompress(Pointer var0, Pointer var1);

        @Node.NodeIntrinsic
        public static native void sha512ImplCompress(Pointer var0, Pointer var1, @Node.ConstantNodeParameter EnumSet<?> var2);
    }

    @NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_128)
    public static final class SHA3Node
    extends MessageDigestNode {
        public static final NodeClass<SHA3Node> TYPE = NodeClass.create(SHA3Node.class);
        public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("sha3ImplCompress", Void.TYPE, new Class[]{Pointer.class, Pointer.class, Integer.TYPE}, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, KILLED_LOCATIONS, false, false);
        @Node.Input
        protected ValueNode blockSize;

        public SHA3Node(ValueNode buf, ValueNode state, ValueNode blockSize) {
            super(TYPE, buf, state, null);
            this.blockSize = blockSize;
        }

        public SHA3Node(ValueNode buf, ValueNode state, ValueNode blockSize, EnumSet<?> runtimeCheckedCPUFeatures) {
            super(TYPE, buf, state, runtimeCheckedCPUFeatures);
            this.blockSize = blockSize;
        }

        public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
            return EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW);
        }

        public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
            return EnumSet.of(AArch64.CPUFeature.SHA3);
        }

        public static boolean isSupported(Architecture arch) {
            if (arch instanceof AMD64) {
                return ((AMD64)arch).getFeatures().containsAll(SHA3Node.minFeaturesAMD64());
            }
            if (arch instanceof AArch64) {
                return ((AArch64)arch).getFeatures().containsAll(SHA3Node.minFeaturesAARCH64());
            }
            return false;
        }

        @Override
        public boolean canBeEmitted(Architecture arch) {
            return SHA3Node.isSupported(arch);
        }

        @Override
        public ForeignCallDescriptor getForeignCallDescriptor() {
            return STUB;
        }

        @Override
        public ValueNode[] getForeignCallArguments() {
            return new ValueNode[]{this.buf, this.state, this.blockSize};
        }

        @Override
        public void emitIntrinsic(NodeLIRBuilderTool gen) {
            gen.getLIRGeneratorTool().emitSha3ImplCompress(gen.operand(this.buf), gen.operand(this.state), gen.operand(this.blockSize));
        }

        @Node.NodeIntrinsic
        @GenerateStub(name="sha3ImplCompress", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")
        public static native void sha3ImplCompress(Pointer var0, Pointer var1, int var2);

        @Node.NodeIntrinsic
        public static native void sha3ImplCompress(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter EnumSet<?> var3);
    }

    @NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_64)
    public static final class SHA256Node
    extends MessageDigestNode {
        public static final NodeClass<SHA256Node> TYPE = NodeClass.create(SHA256Node.class);
        public static final ForeignCallDescriptor STUB = MessageDigestNode.foreignCallDescriptor("sha256ImplCompress");

        public SHA256Node(ValueNode buf, ValueNode state) {
            super(TYPE, buf, state, null);
        }

        public SHA256Node(ValueNode buf, ValueNode state, EnumSet<?> runtimeCheckedCPUFeatures) {
            super(TYPE, buf, state, runtimeCheckedCPUFeatures);
        }

        public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
            return EnumSet.of(AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.SSE4_1, AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, AMD64.CPUFeature.BMI2);
        }

        public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
            return EnumSet.of(AArch64.CPUFeature.SHA2);
        }

        public static boolean isSupported(Architecture arch) {
            if (arch instanceof AMD64) {
                return ((AMD64)arch).getFeatures().containsAll(SHA256Node.minFeaturesAMD64());
            }
            if (arch instanceof AArch64) {
                return ((AArch64)arch).getFeatures().containsAll(SHA256Node.minFeaturesAARCH64());
            }
            return false;
        }

        @Override
        public boolean canBeEmitted(Architecture arch) {
            return SHA256Node.isSupported(arch);
        }

        @Override
        public ForeignCallDescriptor getForeignCallDescriptor() {
            return STUB;
        }

        @Override
        public void emitIntrinsic(NodeLIRBuilderTool gen) {
            gen.getLIRGeneratorTool().emitSha256ImplCompress(gen.operand(this.buf), gen.operand(this.state));
        }

        @Node.NodeIntrinsic
        @GenerateStub(name="sha256ImplCompress", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")
        public static native void sha256ImplCompress(Pointer var0, Pointer var1);

        @Node.NodeIntrinsic
        public static native void sha256ImplCompress(Pointer var0, Pointer var1, @Node.ConstantNodeParameter EnumSet<?> var2);
    }

    @NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_64)
    public static final class SHA1Node
    extends MessageDigestNode {
        public static final NodeClass<SHA1Node> TYPE = NodeClass.create(SHA1Node.class);
        public static final ForeignCallDescriptor STUB = MessageDigestNode.foreignCallDescriptor("sha1ImplCompress");

        public SHA1Node(ValueNode buf, ValueNode state) {
            super(TYPE, buf, state, null);
        }

        public SHA1Node(ValueNode buf, ValueNode state, EnumSet<?> runtimeCheckedCPUFeatures) {
            super(TYPE, buf, state, runtimeCheckedCPUFeatures);
        }

        public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
            return EnumSet.of(AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.SSE4_1, AMD64.CPUFeature.SHA);
        }

        public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
            return EnumSet.of(AArch64.CPUFeature.SHA1);
        }

        public static boolean isSupported(Architecture arch) {
            if (arch instanceof AMD64) {
                return ((AMD64)arch).getFeatures().containsAll(SHA1Node.minFeaturesAMD64());
            }
            if (arch instanceof AArch64) {
                return ((AArch64)arch).getFeatures().containsAll(SHA1Node.minFeaturesAARCH64());
            }
            return false;
        }

        @Override
        public boolean canBeEmitted(Architecture arch) {
            return SHA1Node.isSupported(arch);
        }

        @Override
        public ForeignCallDescriptor getForeignCallDescriptor() {
            return STUB;
        }

        @Override
        public void emitIntrinsic(NodeLIRBuilderTool gen) {
            gen.getLIRGeneratorTool().emitSha1ImplCompress(gen.operand(this.buf), gen.operand(this.state));
        }

        @Node.NodeIntrinsic
        @GenerateStub(name="sha1ImplCompress", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")
        public static native void sha1ImplCompress(Pointer var0, Pointer var1);

        @Node.NodeIntrinsic
        public static native void sha1ImplCompress(Pointer var0, Pointer var1, @Node.ConstantNodeParameter EnumSet<?> var2);
    }
}

