/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.Collection;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.InliningLog;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", size=NodeSize.SIZE_UNKNOWN, sizeRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate")
public abstract class MacroWithExceptionNode
extends WithExceptionNode
implements MacroInvokable {
    public static final NodeClass<MacroWithExceptionNode> TYPE = NodeClass.create(MacroWithExceptionNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;
    protected final int bci;
    protected final ResolvedJavaMethod callerMethod;
    protected final ResolvedJavaMethod targetMethod;
    protected final CallTargetNode.InvokeKind invokeKind;
    protected final StampPair returnStamp;
    protected ResolvedJavaMethod originalTargetMethod;
    protected StampPair originalReturnStamp;
    @Node.Input
    NodeInputList<ValueNode> originalArguments;

    protected MacroWithExceptionNode(NodeClass<? extends MacroWithExceptionNode> c, MacroNode.MacroParams p) {
        super((NodeClass<? extends WithExceptionNode>)c, p.returnStamp != null ? p.returnStamp.getTrustedStamp() : null);
        this.arguments = new NodeInputList((Node)this, (Node[])p.arguments);
        this.bci = p.bci;
        this.callerMethod = p.callerMethod;
        this.targetMethod = p.targetMethod;
        this.returnStamp = p.returnStamp;
        this.invokeKind = p.invokeKind;
        assert (!BytecodeFrame.isPlaceholderBci((int)p.bci));
        assert (MacroInvokable.assertArgumentCount(this));
        this.originalArguments = new NodeInputList(this);
    }

    @Override
    public boolean inferStamp() {
        this.verifyStamp();
        return false;
    }

    protected void verifyStamp() {
        GraalError.guarantee(this.returnStamp.getTrustedStamp().equals(this.stamp(NodeView.DEFAULT)), "Stamp of replaced node %s must be the same as the original Invoke %s, but is %s ", (Object)this, (Object)this.returnStamp.getTrustedStamp(), (Object)this.stamp(NodeView.DEFAULT));
    }

    @Override
    public ResolvedJavaMethod getContextMethod() {
        return this.callerMethod;
    }

    @Override
    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public ResolvedJavaMethod getTargetMethod() {
        return this.targetMethod;
    }

    @Override
    public CallTargetNode.InvokeKind getInvokeKind() {
        return this.invokeKind;
    }

    @Override
    public StampPair getReturnStamp() {
        return this.returnStamp;
    }

    @Override
    public NodeInputList<ValueNode> getOriginalArguments() {
        return this.originalArguments;
    }

    @Override
    public ResolvedJavaMethod getOriginalTargetMethod() {
        return this.originalTargetMethod;
    }

    @Override
    public StampPair getOriginalReturnStamp() {
        return this.originalReturnStamp;
    }

    @Override
    protected void afterClone(Node other) {
        this.updateInliningLogAfterClone(other);
    }

    @Override
    public Invoke replaceWithInvoke() {
        try (DebugCloseable context = this.withNodeSourcePosition();){
            InliningLog.UpdateScope updateScope = InliningLog.openUpdateScopeTrackingReplacement(this.graph().getInliningLog(), this);
            try {
                InvokeWithExceptionNode invoke = this.createInvoke(this);
                this.graph().replaceWithExceptionSplit(this, invoke);
                assert (invoke.verify());
                InvokeWithExceptionNode invokeWithExceptionNode = invoke;
                if (updateScope != null) {
                    updateScope.close();
                }
                return invokeWithExceptionNode;
            }
            catch (Throwable throwable) {
                if (updateScope != null) {
                    try {
                        updateScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public InvokeWithExceptionNode createInvoke(Node oldResult) {
        MethodCallTargetNode callTarget = this.createCallTarget();
        InvokeWithExceptionNode invoke = this.graph().add(new InvokeWithExceptionNode(callTarget, null, this.bci));
        if (this.stateAfter() != null) {
            invoke.setStateAfter(this.stateAfter().duplicate());
            if (this.getStackKind() != JavaKind.Void) {
                invoke.stateAfter().replaceFirstInput(oldResult, invoke);
            }
        }
        this.verifyStamp();
        return invoke;
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public final boolean hasSideEffect() {
        return true;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public void addMethodHandleInfo(ResolvedMethodHandleCallTargetNode methodHandle) {
        assert (this.originalArguments.size() == 0 && this.originalReturnStamp == null & this.originalTargetMethod == null) : this;
        this.originalReturnStamp = methodHandle.originalReturnStamp;
        this.originalTargetMethod = methodHandle.originalTargetMethod;
        this.originalArguments.addAll((Collection<ValueNode>)methodHandle.originalArguments);
    }
}

