/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", size=NodeSize.SIZE_UNKNOWN, sizeRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", allowedUsageTypes={InputType.Memory})
public class LateLoweredNode
extends AbstractBeginNode
implements SingleMemoryKill,
StateSplit,
DeoptimizingNode,
DeoptimizingNode.DeoptDuring,
DeoptimizingNode.DeoptBefore,
DeoptimizingNode.DeoptAfter {
    public static final NodeClass<LateLoweredNode> TYPE = NodeClass.create(LateLoweredNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateDuring;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateBefore;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateAfter;
    protected int bci;
    protected ResolvedJavaMethod targetMethod;
    protected Stamp returnStamp;
    private Consumer<BasicBlock<?>> afterInlineeBasicBlockAction;
    private Supplier<SnippetTemplate> templateProducer;

    public LateLoweredNode(ResolvedJavaMethod targetMethod, Stamp returnStamp, ValueNode[] arguments, Supplier<SnippetTemplate> templateProducer) {
        super((NodeClass<? extends AbstractBeginNode>)TYPE, returnStamp);
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.targetMethod = targetMethod;
        this.returnStamp = returnStamp;
        this.templateProducer = templateProducer;
    }

    public LateLoweredNode(int bci, ResolvedJavaMethod targetMethod, Stamp returnStamp, ValueNode[] arguments, Supplier<SnippetTemplate> templateProducer) {
        super((NodeClass<? extends AbstractBeginNode>)TYPE, returnStamp);
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.targetMethod = targetMethod;
        this.returnStamp = returnStamp;
        this.templateProducer = templateProducer;
        this.bci = bci;
    }

    public void setAfterInlineeBasicBlockAction(Consumer<BasicBlock<?>> afterInlineeBasicBlockAction) {
        this.afterInlineeBasicBlockAction = afterInlineeBasicBlockAction;
    }

    public Consumer<BasicBlock<?>> getAfterInlineeBasicBlockAction() {
        return this.afterInlineeBasicBlockAction;
    }

    public void setTemplateProducer(Supplier<SnippetTemplate> templateProducer) {
        this.templateProducer = templateProducer;
    }

    public Supplier<SnippetTemplate> getTemplateProducer() {
        return this.templateProducer;
    }

    @Override
    public final boolean hasSideEffect() {
        return true;
    }

    public ResolvedJavaMethod getTargetMethod() {
        return this.targetMethod;
    }

    public Stamp getReturnStamp() {
        return this.returnStamp;
    }

    @Override
    public boolean mustNotMoveAttachedGuards() {
        return true;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    public void setBci(int bci) {
        this.bci = bci;
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public void setStateBefore(FrameState x) {
        this.updateUsages(this.stateBefore, x);
        this.stateBefore = x;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    @Override
    public void computeStateDuring(FrameState stateAfter1) {
        FrameState newStateDuring = stateAfter1.duplicateModifiedDuringCall(this.bci, this.asNode().getStackKind());
        this.setStateDuring(newStateDuring);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.ANY_LOCATION;
    }
}

