/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.ArrayList;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.spi.NodeWithIdentity;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.LoopBeginNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class ExplodeLoopNode
extends FixedWithNextNode
implements NodeWithIdentity {
    public static final NodeClass<ExplodeLoopNode> TYPE = NodeClass.create(ExplodeLoopNode.class);

    public ExplodeLoopNode() {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
    }

    public LoopBeginNode findLoopBegin() {
        Node currentNext = this.next();
        ArrayList<Node> succs = new ArrayList<Node>();
        while (!(currentNext instanceof LoopBeginNode)) {
            assert (currentNext != null) : "cannot find loop after " + String.valueOf(this);
            for (Node node : currentNext.cfgSuccessors()) {
                succs.add(node);
            }
            if (succs.size() == 1 && succs.get(0) != currentNext) {
                currentNext = (Node)succs.get(0);
                continue;
            }
            return null;
        }
        return (LoopBeginNode)currentNext;
    }

    @Node.NodeIntrinsic
    public static native void explodeLoop();
}

