/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.GenerateStub;
import jdk.graal.compiler.lir.GenerateStubs;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_64)
public final class EncodeArrayNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<EncodeArrayNode> TYPE = NodeClass.create(EncodeArrayNode.class);
    private static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte)};
    private static final ForeignCallDescriptor STUB_ASCII = EncodeArrayNode.foreignCallDescriptor("stringCodingEncodeArrayAscii");
    private static final ForeignCallDescriptor STUB_LATIN_1 = EncodeArrayNode.foreignCallDescriptor("stringCodingEncodeArrayLatin1");
    public static final ForeignCallDescriptor[] STUBS = new ForeignCallDescriptor[]{STUB_ASCII, STUB_LATIN_1};
    @Node.Input
    protected ValueNode src;
    @Node.Input
    protected ValueNode dst;
    @Node.Input
    protected ValueNode len;
    private final LIRGeneratorTool.CharsetName charset;

    private static ForeignCallDescriptor foreignCallDescriptor(String name) {
        return new ForeignCallDescriptor(name, Integer.TYPE, new Class[]{Pointer.class, Pointer.class, Integer.TYPE}, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, KILLED_LOCATIONS, false, false);
    }

    public EncodeArrayNode(ValueNode src, ValueNode dst, ValueNode len, LIRGeneratorTool.CharsetName charset, JavaKind readKind) {
        this(src, dst, len, charset, null, NamedLocationIdentity.getArrayLocation(readKind));
    }

    public EncodeArrayNode(ValueNode src, ValueNode dst, ValueNode len, LIRGeneratorTool.CharsetName charset) {
        this(src, dst, len, charset, null, LocationIdentity.any());
    }

    public EncodeArrayNode(ValueNode src, ValueNode dst, ValueNode len, LIRGeneratorTool.CharsetName charset, EnumSet<?> runtimeCheckedCPUFeatures) {
        this(src, dst, len, charset, runtimeCheckedCPUFeatures, LocationIdentity.any());
    }

    private EncodeArrayNode(ValueNode src, ValueNode dst, ValueNode len, LIRGeneratorTool.CharsetName charset, EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity) {
        super(TYPE, IntegerStamp.create(32, 0L, ((IntegerStamp)len.stamp(NodeView.DEFAULT)).upperBound()), runtimeCheckedCPUFeatures, locationIdentity);
        this.src = src;
        this.dst = dst;
        this.len = len;
        this.charset = charset;
        GraalError.guarantee(charset == LIRGeneratorTool.CharsetName.ASCII || charset == LIRGeneratorTool.CharsetName.ISO_8859_1, "charset must be one of: ASCII, ISO_8859_1");
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return this.charset == LIRGeneratorTool.CharsetName.ASCII ? STUB_ASCII : STUB_LATIN_1;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.src, this.dst, this.len};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitEncodeArray(this.runtimeCheckedCPUFeatures, gen.operand(this.src), gen.operand(this.dst), gen.operand(this.len), this.charset));
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="stringCodingEncodeArrayAscii", parameters={"ASCII"}), @GenerateStub(name="stringCodingEncodeArrayLatin1", parameters={"ISO_8859_1"})})
    public static native int stringCodingEncodeArray(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter LIRGeneratorTool.CharsetName var3);

    @Node.NodeIntrinsic
    public static native int stringCodingEncodeArray(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter LIRGeneratorTool.CharsetName var3, @Node.ConstantNodeParameter EnumSet<?> var4);
}

