/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class CountTrailingZerosNode
extends UnaryNode
implements ArithmeticLIRLowerable,
Lowerable {
    public static final NodeClass<CountTrailingZerosNode> TYPE = NodeClass.create(CountTrailingZerosNode.class);

    protected CountTrailingZerosNode(ValueNode value) {
        super(TYPE, CountTrailingZerosNode.computeStamp(value.stamp(NodeView.DEFAULT), value), value);
        assert (value.getStackKind() == JavaKind.Int || value.getStackKind() == JavaKind.Long) : Assertions.errorMessage(value);
    }

    public static ValueNode create(ValueNode value) {
        ValueNode folded = CountTrailingZerosNode.tryFold(value);
        if (folded != null) {
            return folded;
        }
        return new CountTrailingZerosNode(value);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        return CountTrailingZerosNode.computeStamp(newStamp, this.getValue());
    }

    static Stamp computeStamp(Stamp newStamp, ValueNode value) {
        assert (newStamp.isCompatible(value.stamp(NodeView.DEFAULT)));
        IntegerStamp valueStamp = (IntegerStamp)newStamp;
        return StampTool.stampForTrailingZeros(valueStamp);
    }

    public static ValueNode tryFold(ValueNode value) {
        if (value.isConstant()) {
            JavaConstant c = value.asJavaConstant();
            if (value.getStackKind() == JavaKind.Int) {
                return ConstantNode.forInt(Integer.numberOfTrailingZeros(c.asInt()));
            }
            return ConstantNode.forInt(Long.numberOfTrailingZeros(c.asLong()));
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = CountTrailingZerosNode.tryFold(forValue);
        return folded != null ? folded : this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitCountTrailingZeros(builder.operand(this.getValue())));
    }
}

