/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class CountLeadingZerosNode
extends UnaryNode
implements ArithmeticLIRLowerable,
Lowerable {
    public static final NodeClass<CountLeadingZerosNode> TYPE = NodeClass.create(CountLeadingZerosNode.class);

    protected CountLeadingZerosNode(ValueNode value) {
        super(TYPE, CountLeadingZerosNode.computeStamp(value.stamp(NodeView.DEFAULT), value), value);
        assert (value.getStackKind() == JavaKind.Int || value.getStackKind() == JavaKind.Long) : Assertions.errorMessage(value);
    }

    public static ValueNode create(ValueNode value) {
        ValueNode folded = CountLeadingZerosNode.tryFold(value);
        if (folded != null) {
            return folded;
        }
        return new CountLeadingZerosNode(value);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        return CountLeadingZerosNode.computeStamp(newStamp, this.getValue());
    }

    private static Stamp computeStamp(Stamp newStamp, ValueNode theValue) {
        assert (newStamp.isCompatible(theValue.stamp(NodeView.DEFAULT)));
        assert (theValue.getStackKind() == JavaKind.Int || theValue.getStackKind() == JavaKind.Long) : Assertions.errorMessage(theValue, newStamp);
        return StampTool.stampForLeadingZeros((IntegerStamp)newStamp);
    }

    public static ValueNode tryFold(ValueNode value) {
        if (value.isConstant()) {
            JavaConstant c = value.asJavaConstant();
            if (value.getStackKind() == JavaKind.Int) {
                return ConstantNode.forInt(Integer.numberOfLeadingZeros(c.asInt()));
            }
            return ConstantNode.forInt(Long.numberOfLeadingZeros(c.asLong()));
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = CountLeadingZerosNode.tryFold(forValue);
        return folded != null ? folded : this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitCountLeadingZeros(builder.operand(this.getValue())));
    }
}

