/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.GenerateStub;
import jdk.graal.compiler.lir.GenerateStubs;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.util.ConstantReflectionUtil;
import jdk.graal.compiler.replacements.nodes.CalcStringAttributesForeignCalls;
import jdk.graal.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public final class CalcStringAttributesNode
extends PureFunctionStubIntrinsicNode
implements Canonicalizable {
    public static final NodeClass<CalcStringAttributesNode> TYPE = NodeClass.create(CalcStringAttributesNode.class);
    private static final EnumSet<AMD64.CPUFeature> MINIMUM_FEATURES_AMD64 = EnumSet.of(AMD64.CPUFeature.SSE, new AMD64.CPUFeature[]{AMD64.CPUFeature.SSE2, AMD64.CPUFeature.SSE3, AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.SSE4_1, AMD64.CPUFeature.SSE4_2, AMD64.CPUFeature.POPCNT});
    public static final int MAX_ASCII_VALUE = 127;
    public static final int MAX_LATIN_1_VALUE = 255;
    private final LIRGeneratorTool.CalcStringAttributesEncoding encoding;
    private final boolean assumeValid;
    @Node.Input
    protected ValueNode array;
    @Node.Input
    protected ValueNode offset;
    @Node.Input
    protected ValueNode length;

    protected CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding encoding, @Node.ConstantNodeParameter boolean assumeValid) {
        this(array, offset, length, encoding, assumeValid, null, LocationIdentity.any());
    }

    protected CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding encoding, @Node.ConstantNodeParameter boolean assumeValid, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(array, offset, length, encoding, assumeValid, runtimeCheckedCPUFeatures, LocationIdentity.any());
    }

    public CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding encoding, @Node.ConstantNodeParameter boolean assumeValid, LocationIdentity locationIdentity) {
        this(array, offset, length, encoding, assumeValid, null, locationIdentity);
    }

    public CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding encoding, @Node.ConstantNodeParameter boolean assumeValid, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity) {
        super(TYPE, StampFactory.forKind(CalcStringAttributesNode.getReturnValueKind(encoding)), runtimeCheckedCPUFeatures, locationIdentity);
        this.encoding = encoding;
        this.assumeValid = assumeValid;
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    private static JavaKind getReturnValueKind(LIRGeneratorTool.CalcStringAttributesEncoding encoding) {
        return encoding == LIRGeneratorTool.CalcStringAttributesEncoding.UTF_8 || encoding == LIRGeneratorTool.CalcStringAttributesEncoding.UTF_16 ? JavaKind.Long : JavaKind.Int;
    }

    public LIRGeneratorTool.CalcStringAttributesEncoding getOp() {
        return this.encoding;
    }

    public boolean isAssumeValid() {
        return this.assumeValid;
    }

    public ValueNode getArray() {
        return this.array;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getLength() {
        return this.length;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        if (ConstantReflectionUtil.isStableJavaArray(this.array) && this.offset.isJavaConstant() && this.length.isJavaConstant()) {
            int lengthConstant;
            Stride stride = this.encoding.stride;
            ConstantReflectionProvider provider = tool.getConstantReflection();
            JavaConstant arrayConstant = this.array.asJavaConstant();
            JavaKind constantArrayKind = this.array.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
            int actualArrayLength = provider.readArrayLength(arrayConstant);
            long arrayBaseOffsetBytesConstant = this.offset.asJavaConstant().asLong();
            long offsetConstantScaled = (arrayBaseOffsetBytesConstant -= (long)tool.getMetaAccess().getArrayBaseOffset(constantArrayKind)) >> stride.log2;
            if (!ConstantReflectionUtil.boundsCheckTypePunned(offsetConstantScaled, lengthConstant = this.length.asJavaConstant().asInt(), stride, actualArrayLength, constantArrayKind)) {
                return this;
            }
            int offsetConstant = NumUtil.safeToInt(offsetConstantScaled);
            if (ConstantReflectionUtil.shouldConstantFoldArrayOperation(tool, lengthConstant)) {
                switch (this.encoding) {
                    case LATIN1: {
                        for (int i = 0; i < lengthConstant; ++i) {
                            int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, stride, offsetConstant + i);
                            if (value <= 127) continue;
                            return ConstantNode.forInt(1);
                        }
                        return ConstantNode.forInt(0);
                    }
                    case BMP: {
                        int ret = 0;
                        for (int i = 0; i < lengthConstant; ++i) {
                            int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, stride, offsetConstant + i);
                            if (value > 255) {
                                ret = 2;
                                break;
                            }
                            if (value <= 127) continue;
                            ret = 1;
                        }
                        return ConstantNode.forInt(ret);
                    }
                    case UTF_8: {
                        int ret = 0;
                        int state = 0;
                        long nCodePoints = 0L;
                        for (int i = 0; i < lengthConstant; ++i) {
                            int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, stride, offsetConstant + i);
                            if (!CalcStringAttributesNode.isUTF8ContinuationByte(value)) {
                                ++nCodePoints;
                            }
                            if (value > 127) {
                                ret = 11;
                            }
                            state = LIRGeneratorTool.CalcStringAttributesEncoding.utf8GetNextState(state, value);
                        }
                        if (!this.assumeValid && state != 0) {
                            ret = 12;
                        }
                        return ConstantNode.forLong(nCodePoints << 32 | (long)ret);
                    }
                    case UTF_16: {
                        long nCodePoints = lengthConstant;
                        int last = 0;
                        int ret = 0;
                        for (int i = 0; i < lengthConstant; ++i) {
                            int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, stride, offsetConstant + i);
                            if (this.assumeValid) {
                                if (Character.isHighSurrogate((char)value)) {
                                    --nCodePoints;
                                    ret = 11;
                                }
                            } else if (Character.isLowSurrogate((char)value)) {
                                if (Character.isSurrogatePair((char)last, (char)value)) {
                                    if (ret != 12) {
                                        ret = 11;
                                    }
                                    --nCodePoints;
                                } else {
                                    ret = 12;
                                }
                            } else if (Character.isHighSurrogate((char)last)) {
                                ret = 12;
                            }
                            if (ret == 0 && value > 127) {
                                ret = 1;
                            }
                            if (ret == 1 && value > 255) {
                                ret = 2;
                            }
                            last = value;
                        }
                        if (!this.assumeValid && Character.isHighSurrogate((char)last)) {
                            ret = 12;
                        }
                        return ConstantNode.forLong(nCodePoints << 32 | (long)ret);
                    }
                    case UTF_32: {
                        int ret = 0;
                        for (int i = 0; i < lengthConstant; ++i) {
                            int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, stride, offsetConstant + i);
                            if (Integer.compareUnsigned(value, 0x10FFFF) > 0 || value <= 65535 && Character.isSurrogate((char)value)) {
                                ret = 4;
                                break;
                            }
                            if (value > 65535) {
                                ret = 3;
                            }
                            if (ret == 0 && value > 127) {
                                ret = 1;
                            }
                            if (ret != 1 || value <= 255) continue;
                            ret = 2;
                        }
                        return ConstantNode.forInt(ret);
                    }
                }
            }
        }
        return this;
    }

    private static boolean isUTF8ContinuationByte(int value) {
        return (value & 0xC0) == 128;
    }

    public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
        return MINIMUM_FEATURES_AMD64;
    }

    public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
        return EnumSet.noneOf(AArch64.CPUFeature.class);
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return CalcStringAttributesForeignCalls.getStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.array, this.offset, this.length};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitCalcStringAttributes(this.encoding, this.getRuntimeCheckedCPUFeatures(), gen.operand(this.array), gen.operand(this.offset), gen.operand(this.length), this.assumeValid));
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="calcStringAttributesLatin1", parameters={"LATIN1", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesBMP", parameters={"BMP", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF32", parameters={"UTF_32", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")})
    public static native int intReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding var4, @Node.ConstantNodeParameter boolean var5);

    @Node.NodeIntrinsic
    public static native int intReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding var4, @Node.ConstantNodeParameter boolean var5, @Node.ConstantNodeParameter EnumSet<?> var6);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="calcStringAttributesUTF8Valid", parameters={"UTF_8", "true"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF8Unknown", parameters={"UTF_8", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF16Valid", parameters={"UTF_16", "true"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF16Unknown", parameters={"UTF_16", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")})
    public static native long longReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding var4, @Node.ConstantNodeParameter boolean var5);

    @Node.NodeIntrinsic
    public static native long longReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding var4, @Node.ConstantNodeParameter boolean var5, @Node.ConstantNodeParameter EnumSet<?> var6);
}

