/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.BitScanForwardNode;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class BitScanReverseNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<BitScanReverseNode> TYPE = NodeClass.create(BitScanReverseNode.class);

    public BitScanReverseNode(ValueNode value) {
        super(TYPE, StampFactory.forInteger(JavaKind.Int, 0L, ((PrimitiveStamp)value.stamp(NodeView.DEFAULT)).getBits()), value);
        assert (value.getStackKind() == JavaKind.Int || value.getStackKind() == JavaKind.Long) : Assertions.errorMessage(value);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        int lastMaybeSetBit;
        int firstMaybeSetBit;
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        IntegerStamp valueStamp = (IntegerStamp)newStamp;
        long mask = CodeUtil.mask((int)valueStamp.getBits());
        int lastAlwaysSetBit = BitScanReverseNode.scan(valueStamp.mustBeSet() & mask);
        int min = lastAlwaysSetBit == -1 ? (firstMaybeSetBit = BitScanForwardNode.scan(valueStamp.mayBeSet() & mask)) : lastAlwaysSetBit;
        int max = lastMaybeSetBit = BitScanReverseNode.scan(valueStamp.mayBeSet() & mask);
        return StampFactory.forInteger(JavaKind.Int, min, max);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        JavaConstant c;
        if (forValue.isConstant() && (c = forValue.asJavaConstant()).asLong() != 0L) {
            return ConstantNode.forInt(forValue.getStackKind() == JavaKind.Int ? BitScanReverseNode.scan(c.asInt()) : BitScanReverseNode.scan(c.asLong()));
        }
        return this;
    }

    public static int scan(long v) {
        return 63 - Long.numberOfLeadingZeros(v);
    }

    public static int scan(int v) {
        return 31 - Integer.numberOfLeadingZeros(v);
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitBitScanReverse(builder.operand(this.getValue())));
    }
}

