/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.GenerateStub;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_1024, size=NodeSize.SIZE_32)
public class BigIntegerMulAddNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<BigIntegerMulAddNode> TYPE = NodeClass.create(BigIntegerMulAddNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Int)};
    public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("mulAdd", Integer.TYPE, new Class[]{Pointer.class, Pointer.class, Integer.TYPE, Integer.TYPE, Integer.TYPE}, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, KILLED_LOCATIONS, false, false);
    @Node.Input
    protected ValueNode out;
    @Node.Input
    protected ValueNode in;
    @Node.Input
    protected ValueNode offset;
    @Node.Input
    protected ValueNode len;
    @Node.Input
    protected ValueNode k;

    public BigIntegerMulAddNode(ValueNode out, ValueNode in, ValueNode offset, ValueNode len, ValueNode k) {
        this(out, in, offset, len, k, null);
    }

    public BigIntegerMulAddNode(ValueNode out, ValueNode in, ValueNode offset, ValueNode len, ValueNode k, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.intValue(), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.out = out;
        this.in = in;
        this.offset = offset;
        this.len = len;
        this.k = k;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.out, this.in, this.offset, this.len, this.k};
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    @Node.NodeIntrinsic
    @GenerateStub(name="mulAdd")
    public static native int apply(Pointer var0, Pointer var1, int var2, int var3, int var4);

    @Node.NodeIntrinsic
    public static native int apply(Pointer var0, Pointer var1, int var2, int var3, int var4, @Node.ConstantNodeParameter EnumSet<?> var5);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitBigIntegerMulAdd(gen.operand(this.out), gen.operand(this.in), gen.operand(this.offset), gen.operand(this.len), gen.operand(this.k)));
    }
}

