/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.replacements.nodes.ArrayIndexOfNode;
import jdk.graal.compiler.replacements.nodes.ForeignCalls;
import jdk.vm.ci.amd64.AMD64;

public class ArrayIndexOfForeignCalls {
    public static final ForeignCallDescriptor STUB_INDEX_OF_1_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf1S1", 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_2_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf2S1", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_3_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf3S1", 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_4_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf4S1", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_1_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf1S2", 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_2_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf2S2", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_3_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf3S2", 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_4_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf4S2", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_1_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf1S4", 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_2_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf2S4", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_3_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf3S4", 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_4_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf4S4", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_RANGE_1_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfRange1S1", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_RANGE_1_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfRange1S2", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_RANGE_1_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfRange1S4", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_RANGE_2_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfRange2S1", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_RANGE_2_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfRange2S2", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_RANGE_2_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfRange2S4", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfWithMaskS1", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfWithMaskS2", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfWithMaskS4", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveS1", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveS2", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveS4", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskS1", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskS2", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskS4", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TABLE_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTableS1", 1, byte[].class);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TABLE_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTableS2", 1, byte[].class);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TABLE_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTableS4", 1, byte[].class);
    private static final ForeignCallDescriptor[] STUBS_INDEX_OF_ANY = new ForeignCallDescriptor[]{STUB_INDEX_OF_1_S1, STUB_INDEX_OF_2_S1, STUB_INDEX_OF_3_S1, STUB_INDEX_OF_4_S1, STUB_INDEX_OF_1_S2, STUB_INDEX_OF_2_S2, STUB_INDEX_OF_3_S2, STUB_INDEX_OF_4_S2, STUB_INDEX_OF_1_S4, STUB_INDEX_OF_2_S4, STUB_INDEX_OF_3_S4, STUB_INDEX_OF_4_S4};
    public static final ForeignCallDescriptor[] STUBS = (ForeignCallDescriptor[])Stream.concat(Arrays.stream(STUBS_INDEX_OF_ANY), Stream.of(STUB_INDEX_OF_RANGE_1_S1, STUB_INDEX_OF_RANGE_1_S2, STUB_INDEX_OF_RANGE_1_S4, STUB_INDEX_OF_RANGE_2_S1, STUB_INDEX_OF_RANGE_2_S2, STUB_INDEX_OF_RANGE_2_S4, STUB_INDEX_OF_WITH_MASK_S1, STUB_INDEX_OF_WITH_MASK_S2, STUB_INDEX_OF_WITH_MASK_S4, STUB_INDEX_OF_TWO_CONSECUTIVE_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_S4, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S4, STUB_INDEX_OF_TABLE_S1, STUB_INDEX_OF_TABLE_S2, STUB_INDEX_OF_TABLE_S4)).toArray(ForeignCallDescriptor[]::new);

    private static ForeignCallDescriptor foreignCallDescriptor(String name, int nValues) {
        return ArrayIndexOfForeignCalls.foreignCallDescriptor(name, nValues, Integer.TYPE);
    }

    private static ForeignCallDescriptor foreignCallDescriptor(String name, int nValues, Class<?> valueClass) {
        Class[] argTypes = new Class[4 + nValues];
        argTypes[0] = Object.class;
        argTypes[1] = Long.TYPE;
        argTypes[2] = Integer.TYPE;
        argTypes[3] = Integer.TYPE;
        for (int i = 4; i < argTypes.length; ++i) {
            argTypes[i] = valueClass;
        }
        return ForeignCalls.pureFunctionForeignCallDescriptor(name, Integer.TYPE, argTypes);
    }

    public static EnumSet<AMD64.CPUFeature> getMinimumFeaturesAMD64(ForeignCallDescriptor foreignCallDescriptor) {
        return ArrayIndexOfNode.minFeaturesAMD64(ArrayIndexOfForeignCalls.getStride(foreignCallDescriptor), ArrayIndexOfForeignCalls.getVariant(foreignCallDescriptor));
    }

    private static Stride getStride(ForeignCallDescriptor foreignCallDescriptor) {
        return Stride.valueOf(foreignCallDescriptor.getName().substring(foreignCallDescriptor.getName().length() - 2));
    }

    private static LIRGeneratorTool.ArrayIndexOfVariant getVariant(ForeignCallDescriptor foreignCallDescriptor) {
        String name = foreignCallDescriptor.getName();
        if (name.startsWith("indexOfRange")) {
            return LIRGeneratorTool.ArrayIndexOfVariant.MatchRange;
        }
        if (name.startsWith("indexOfTable")) {
            return LIRGeneratorTool.ArrayIndexOfVariant.Table;
        }
        if (name.startsWith("indexOfTwoConsecutiveWithMask")) {
            return LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask;
        }
        if (name.startsWith("indexOfTwoConsecutive")) {
            return LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive;
        }
        if (name.startsWith("indexOfWithMask")) {
            return LIRGeneratorTool.ArrayIndexOfVariant.WithMask;
        }
        char n = name.charAt("indexOf".length());
        GraalError.guarantee(name.startsWith("indexOf") && '1' <= n && n <= '4', "unexpected foreign call descriptor name");
        return LIRGeneratorTool.ArrayIndexOfVariant.MatchAny;
    }

    public static ForeignCallDescriptor getStub(ArrayIndexOfNode indexOfNode) {
        Stride stride = indexOfNode.getStride();
        int valueCount = indexOfNode.getNumberOfValues();
        switch (indexOfNode.getVariant()) {
            case MatchAny: {
                int index = 4 * stride.log2 + (valueCount - 1);
                return STUBS_INDEX_OF_ANY[index];
            }
            case MatchRange: {
                switch (stride) {
                    case S1: {
                        return valueCount == 2 ? STUB_INDEX_OF_RANGE_1_S1 : STUB_INDEX_OF_RANGE_2_S1;
                    }
                    case S2: {
                        return valueCount == 2 ? STUB_INDEX_OF_RANGE_1_S2 : STUB_INDEX_OF_RANGE_2_S2;
                    }
                    case S4: {
                        return valueCount == 2 ? STUB_INDEX_OF_RANGE_1_S4 : STUB_INDEX_OF_RANGE_2_S4;
                    }
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)stride);
            }
            case WithMask: {
                switch (stride) {
                    case S1: {
                        return STUB_INDEX_OF_WITH_MASK_S1;
                    }
                    case S2: {
                        return STUB_INDEX_OF_WITH_MASK_S2;
                    }
                    case S4: {
                        return STUB_INDEX_OF_WITH_MASK_S4;
                    }
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)stride);
            }
            case FindTwoConsecutive: {
                switch (stride) {
                    case S1: {
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_S1;
                    }
                    case S2: {
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_S2;
                    }
                    case S4: {
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_S4;
                    }
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)stride);
            }
            case FindTwoConsecutiveWithMask: {
                switch (stride) {
                    case S1: {
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S1;
                    }
                    case S2: {
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S2;
                    }
                    case S4: {
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S4;
                    }
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)stride);
            }
            case Table: {
                switch (stride) {
                    case S1: {
                        return STUB_INDEX_OF_TABLE_S1;
                    }
                    case S2: {
                        return STUB_INDEX_OF_TABLE_S2;
                    }
                    case S4: {
                        return STUB_INDEX_OF_TABLE_S4;
                    }
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)stride);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)indexOfNode.getVariant());
    }
}

