/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.StrideUtil;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.replacements.nodes.ArrayEqualsNode;
import jdk.graal.compiler.replacements.nodes.ArrayRegionEqualsNode;
import jdk.graal.compiler.replacements.nodes.ForeignCalls;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.Pointer;

public final class ArrayEqualsForeignCalls {
    private static final ForeignCallDescriptor STUB_LONG_ARRAY_EQUALS = ArrayEqualsForeignCalls.foreignCallDescriptorPointers("longArraysEquals");
    private static final ForeignCallDescriptor STUB_FLOAT_ARRAY_EQUALS = ArrayEqualsForeignCalls.foreignCallDescriptorPointers("floatArraysEquals");
    private static final ForeignCallDescriptor STUB_DOUBLE_ARRAY_EQUALS = ArrayEqualsForeignCalls.foreignCallDescriptorPointers("doubleArraysEquals");
    private static final ForeignCallDescriptor STUB_REGION_EQUALS_DYNAMIC_STRIDES = ForeignCalls.pureFunctionForeignCallDescriptor("arrayRegionEqualsDynamicStrides", Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor[] STUBS = new ForeignCallDescriptor[]{ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS1S1"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS1S2"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS1S4"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS2S1"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS2S2"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS2S4"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS4S1"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS4S2"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS4S4"), STUB_REGION_EQUALS_DYNAMIC_STRIDES, STUB_LONG_ARRAY_EQUALS};
    public static final ForeignCallDescriptor[] STUBS_AMD64 = new ForeignCallDescriptor[]{STUB_FLOAT_ARRAY_EQUALS, STUB_DOUBLE_ARRAY_EQUALS};

    private static ForeignCallDescriptor foreignCallDescriptor(String name) {
        return ForeignCalls.pureFunctionForeignCallDescriptor(name, Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE);
    }

    private static ForeignCallDescriptor foreignCallDescriptorPointers(String name) {
        return ForeignCalls.pureFunctionForeignCallDescriptor(name, Boolean.TYPE, Pointer.class, Long.TYPE, Pointer.class, Long.TYPE, Integer.TYPE);
    }

    public static ForeignCallDescriptor getArrayEqualsStub(ArrayEqualsNode arrayEqualsNode) {
        JavaKind kind = arrayEqualsNode.getKind();
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: {
                return STUBS[StrideUtil.getDirectStubCallIndex(Stride.fromJavaKind((JavaKind)kind).log2, Stride.fromJavaKind((JavaKind)kind).log2)];
            }
            case Long: {
                return STUB_LONG_ARRAY_EQUALS;
            }
            case Float: {
                return STUB_FLOAT_ARRAY_EQUALS;
            }
            case Double: {
                return STUB_DOUBLE_ARRAY_EQUALS;
            }
        }
        return null;
    }

    public static ForeignCallDescriptor getRegionEqualsStub(ArrayRegionEqualsNode regionEqualsNode) {
        int directStubCallIndex = regionEqualsNode.getDirectStubCallIndex();
        GraalError.guarantee(-1 <= directStubCallIndex && directStubCallIndex < 9, "invalid direct stub call index");
        return directStubCallIndex < 0 ? STUB_REGION_EQUALS_DYNAMIC_STRIDES : STUBS[directStubCallIndex];
    }
}

