/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.GenerateStub;
import jdk.graal.compiler.lir.GenerateStubs;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.NodeStrideUtil;
import jdk.graal.compiler.replacements.nodes.ArrayCopyWithConversionsForeignCalls;
import jdk.graal.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public class ArrayCopyWithConversionsNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<ArrayCopyWithConversionsNode> TYPE = NodeClass.create(ArrayCopyWithConversionsNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte), NamedLocationIdentity.OFF_HEAP_LOCATION};
    private final Stride strideSrc;
    private final Stride strideDst;
    @Node.Input
    protected ValueNode arraySrc;
    @Node.Input
    protected ValueNode offsetSrc;
    @Node.Input
    protected ValueNode arrayDst;
    @Node.Input
    protected ValueNode offsetDst;
    @Node.Input
    protected ValueNode length;
    @Node.OptionalInput
    protected ValueNode dynamicStrides;

    public ArrayCopyWithConversionsNode(ValueNode arraySrc, ValueNode offsetSrc, ValueNode arrayDst, ValueNode offsetDst, ValueNode length, @Node.ConstantNodeParameter Stride strideSrc, @Node.ConstantNodeParameter Stride strideDst) {
        this(TYPE, arraySrc, offsetSrc, arrayDst, offsetDst, length, null, strideSrc, strideDst, null);
    }

    public ArrayCopyWithConversionsNode(ValueNode arraySrc, ValueNode offsetSrc, ValueNode arrayDst, ValueNode offsetDst, ValueNode length, @Node.ConstantNodeParameter Stride strideSrc, @Node.ConstantNodeParameter Stride strideDst, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(TYPE, arraySrc, offsetSrc, arrayDst, offsetDst, length, null, strideSrc, strideDst, runtimeCheckedCPUFeatures);
    }

    public ArrayCopyWithConversionsNode(ValueNode arraySrc, ValueNode offsetSrc, ValueNode arrayDst, ValueNode offsetDst, ValueNode length, ValueNode dynamicStrides) {
        this(TYPE, arraySrc, offsetSrc, arrayDst, offsetDst, length, dynamicStrides, null, null, null);
    }

    public ArrayCopyWithConversionsNode(ValueNode arraySrc, ValueNode offsetSrc, ValueNode arrayDst, ValueNode offsetDst, ValueNode length, ValueNode dynamicStrides, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(TYPE, arraySrc, offsetSrc, arrayDst, offsetDst, length, dynamicStrides, null, null, runtimeCheckedCPUFeatures);
    }

    protected ArrayCopyWithConversionsNode(NodeClass<? extends ArrayCopyWithConversionsNode> c, ValueNode arraySrc, ValueNode offsetSrc, ValueNode arrayDst, ValueNode offsetDst, ValueNode length, ValueNode dynamicStrides, @Node.ConstantNodeParameter Stride strideSrc, @Node.ConstantNodeParameter Stride strideDst, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        super(c, StampFactory.forKind(JavaKind.Void), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.strideSrc = strideSrc;
        this.strideDst = strideDst;
        this.arraySrc = arraySrc;
        this.offsetSrc = offsetSrc;
        this.arrayDst = arrayDst;
        this.offsetDst = offsetDst;
        this.length = length;
        this.dynamicStrides = dynamicStrides;
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="arrayCopyWithConversionsS1S1", parameters={"S1", "S1"}), @GenerateStub(name="arrayCopyWithConversionsS1S2", parameters={"S1", "S2"}), @GenerateStub(name="arrayCopyWithConversionsS1S4", parameters={"S1", "S4"}), @GenerateStub(name="arrayCopyWithConversionsS2S1", parameters={"S2", "S1"}), @GenerateStub(name="arrayCopyWithConversionsS2S2", parameters={"S2", "S2"}), @GenerateStub(name="arrayCopyWithConversionsS2S4", parameters={"S2", "S4"}), @GenerateStub(name="arrayCopyWithConversionsS4S1", parameters={"S4", "S1"}), @GenerateStub(name="arrayCopyWithConversionsS4S2", parameters={"S4", "S2"}), @GenerateStub(name="arrayCopyWithConversionsS4S4", parameters={"S4", "S4"})})
    public static native void arrayCopy(Object var0, long var1, Object var3, long var4, int var6, @Node.ConstantNodeParameter Stride var7, @Node.ConstantNodeParameter Stride var8);

    @Node.NodeIntrinsic
    public static native void arrayCopy(Object var0, long var1, Object var3, long var4, int var6, @Node.ConstantNodeParameter Stride var7, @Node.ConstantNodeParameter Stride var8, @Node.ConstantNodeParameter EnumSet<?> var9);

    @Node.NodeIntrinsic
    @GenerateStub(name="arrayCopyWithConversionsDynamicStrides")
    public static native void arrayCopy(Object var0, long var1, Object var3, long var4, int var6, int var7);

    @Node.NodeIntrinsic
    public static native void arrayCopy(Object var0, long var1, Object var3, long var4, int var6, int var7, @Node.ConstantNodeParameter EnumSet<?> var8);

    public int getDirectStubCallIndex() {
        return NodeStrideUtil.getDirectStubCallIndex(this.dynamicStrides, this.strideSrc, this.strideDst);
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return ArrayCopyWithConversionsForeignCalls.getStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        if (this.getDirectStubCallIndex() < 0) {
            return new ValueNode[]{this.arraySrc, this.offsetSrc, this.arrayDst, this.offsetDst, this.length, this.dynamicStrides};
        }
        return new ValueNode[]{this.arraySrc, this.offsetSrc, this.arrayDst, this.offsetDst, this.length};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        if (this.getDirectStubCallIndex() < 0) {
            gen.getLIRGeneratorTool().emitArrayCopyWithConversion(this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arraySrc), gen.operand(this.offsetSrc), gen.operand(this.arrayDst), gen.operand(this.offsetDst), gen.operand(this.length), gen.operand(this.dynamicStrides));
        } else {
            gen.getLIRGeneratorTool().emitArrayCopyWithConversion(NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideSrc), NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideDst), this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arraySrc), gen.operand(this.offsetSrc), gen.operand(this.arrayDst), gen.operand(this.offsetDst), gen.operand(this.length));
        }
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }
}

