/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.gc;

import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public abstract class WriteBarrierSnippets {
    public static final LocationIdentity GC_CARD_LOCATION = NamedLocationIdentity.mutable("GC-Card");

    protected static void verifyNotArray(Object object) {
        if (BranchProbabilityNode.probability(0.6, object != null)) {
            AssertionNode.dynamicAssert(!PiNode.piCastNonNull(object, SnippetAnchorNode.anchor()).getClass().isArray(), "imprecise card mark used with array");
        }
    }

    protected static Word getPointerToFirstArrayElement(AddressNode.Address address, long length, int elementStride) {
        long result = Word.fromAddress(address).rawValue();
        if (BranchProbabilityNode.probability(0.4, elementStride < 0)) {
            result += (long)elementStride * length;
        }
        return (Word)WordFactory.unsigned((long)result);
    }

    protected static Word getPointerToLastArrayElement(AddressNode.Address address, long length, int elementStride) {
        long result = Word.fromAddress(address).rawValue();
        result = BranchProbabilityNode.probability(0.4, elementStride < 0) ? (result += (long)elementStride) : (result += (length - 1L) * (long)elementStride);
        return (Word)WordFactory.unsigned((long)result);
    }
}

