/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.arraycopy;

import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.function.Supplier;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardedUnsafeLoadNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetIntegerHistogram;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyCallNode;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyNode;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyWithDelayedLoweringNode;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.word.LocationIdentity;

public abstract class ArrayCopySnippets
implements Snippets {
    protected static final MetaAccessProvider INJECTED_META_ACCESS = null;
    private static final int SRC_IDX = 0;
    private static final int DEST_IDX = 1;
    private static final int LENGTH_IDX = 2;
    private static final int LIMITS_SIZE = 3;

    public static void registerSystemArraycopyPlugin(InvocationPlugins.Registration r) {
        ArrayCopySnippets.registerSystemArraycopyPlugin(r, false);
    }

    public static void registerSystemArraycopyPlugin(InvocationPlugins.Registration r, final boolean forceAnyLocation) {
        r.register(new InvocationPlugin("arraycopy", new Type[]{Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode srcPos, ValueNode dst, ValueNode dstPos, ValueNode length) {
                ValueNode nonNullSrc = b.nullCheckedValue(src);
                ValueNode nonNullDst = b.nullCheckedValue(dst);
                b.add(new ArrayCopyNode(b.bci(), nonNullSrc, srcPos, nonNullDst, dstPos, length, forceAnyLocation));
                return true;
            }
        });
    }

    public abstract boolean hubsEqual(Object var1, Object var2);

    public abstract boolean layoutHelpersEqual(Object var1, Object var2);

    protected abstract int heapWordSize();

    protected boolean useOriginalArraycopy() {
        return true;
    }

    @Snippet
    public void delayedExactArraycopyWithExpandedLoopSnippet(@Snippet.NonNullParameter Object src, int srcPos, @Snippet.NonNullParameter Object dest, int destPos, int length, @Snippet.ConstantParameter ArrayCopyTypeCheck arrayTypeCheck, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity locationIdentity, @Snippet.ConstantParameter SnippetCounter elementKindCounter, @Snippet.ConstantParameter SnippetCounter elementKindCopiedCounter, @Snippet.ConstantParameter Counters counters) {
        this.checkArrayTypes(src, dest, arrayTypeCheck);
        int[] checked = this.checkLimits(src, srcPos, dest, destPos, length, elementKind, counters);
        int checkedSrcPos = checked[0];
        int checkedDestPos = checked[1];
        int checkedLength = checked[2];
        ArrayCopySnippets.incrementLengthCounter(checkedLength, counters);
        elementKindCounter.inc();
        elementKindCopiedCounter.add(checkedLength);
        ArrayCopyWithDelayedLoweringNode.arraycopyNonThrowing(src, checkedSrcPos, dest, checkedDestPos, checkedLength, WorkSnippetID.exactArraycopyWithExpandedLoopSnippet, GraphState.GuardsStage.FIXED_DEOPTS, elementKind);
    }

    @Snippet
    public void arraycopyExactStubCallSnippet(@Snippet.NonNullParameter Object src, int srcPos, @Snippet.NonNullParameter Object dest, int destPos, int length, @Snippet.ConstantParameter ArrayCopyTypeCheck arrayTypeCheck, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity locationIdentity, @Snippet.ConstantParameter SnippetCounter elementKindCounter, @Snippet.ConstantParameter SnippetCounter elementKindCopiedCounter, @Snippet.ConstantParameter Counters counters) {
        this.checkArrayTypes(src, dest, arrayTypeCheck);
        int[] checked = this.checkLimits(src, srcPos, dest, destPos, length, elementKind, counters);
        int checkedSrcPos = checked[0];
        int checkedDestPos = checked[1];
        int checkedLength = checked[2];
        ArrayCopySnippets.incrementLengthCounter(checkedLength, counters);
        elementKindCounter.inc();
        elementKindCopiedCounter.add(checkedLength);
        this.doArraycopyExactStubCallSnippet(src, checkedSrcPos, dest, checkedDestPos, checkedLength, elementKind, locationIdentity, counters);
    }

    protected void doArraycopyExactStubCallSnippet(Object src, int srcPos, Object dest, int destPos, int length, JavaKind elementKind, LocationIdentity locationIdentity, Counters counters) {
        ArrayCopyCallNode.arraycopy(src, srcPos, dest, destPos, length, elementKind, locationIdentity, this.heapWordSize());
    }

    @Snippet
    public void delayedCheckcastArraycopySnippet(@Snippet.NonNullParameter Object src, int srcPos, @Snippet.NonNullParameter Object dest, int destPos, int length, @Snippet.ConstantParameter ArrayCopyTypeCheck arrayTypeCheck, @Snippet.ConstantParameter Counters counters, @Snippet.ConstantParameter JavaKind elementKind) {
        this.checkArrayTypes(src, dest, arrayTypeCheck);
        int[] checked = this.checkLimits(src, srcPos, dest, destPos, length, elementKind, counters);
        int checkedSrcPos = checked[0];
        int checkedDestPos = checked[1];
        int checkedLength = checked[2];
        ArrayCopySnippets.incrementLengthCounter(checkedLength, counters);
        ArrayCopyWithDelayedLoweringNode.arraycopy(src, checkedSrcPos, dest, checkedDestPos, checkedLength, WorkSnippetID.checkcastArraycopySnippet, GraphState.GuardsStage.AFTER_FSA, elementKind);
    }

    @Snippet
    public void delayedGenericArraycopySnippet(@Snippet.NonNullParameter Object src, int srcPos, @Snippet.NonNullParameter Object dest, int destPos, int length, @Snippet.ConstantParameter ArrayCopyTypeCheck arrayTypeCheck, @Snippet.ConstantParameter Counters counters, @Snippet.ConstantParameter JavaKind elementKind) {
        this.checkArrayTypes(src, dest, arrayTypeCheck);
        int[] checked = this.checkLimits(src, srcPos, dest, destPos, length, elementKind, counters);
        int checkedSrcPos = checked[0];
        int checkedDestPos = checked[1];
        int checkedLength = checked[2];
        ArrayCopySnippets.incrementLengthCounter(checkedLength, counters);
        ArrayCopyWithDelayedLoweringNode.arraycopy(src, checkedSrcPos, dest, checkedDestPos, checkedLength, WorkSnippetID.genericArraycopySnippet, GraphState.GuardsStage.AFTER_FSA, elementKind);
    }

    @Snippet
    public static void arraycopyNativeExceptionSnippet(@Snippet.NonNullParameter Object src, int srcPos, @Snippet.NonNullParameter Object dest, int destPos, int length, @Snippet.ConstantParameter Counters counters) {
        ArrayCopySnippets.incrementLengthCounter(length, counters);
        counters.systemArraycopyCounter.inc();
        counters.systemArraycopyCopiedCounter.add(length);
        System.arraycopy(src, srcPos, dest, destPos, length);
        UnreachableNode.unreachable();
    }

    @Snippet(allowPartialIntrinsicArgumentMismatch=true)
    public void exactArraycopyWithExpandedLoopSnippet(@Snippet.NonNullParameter Object src, int srcPos, @Snippet.NonNullParameter Object dest, int destPos, int length, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity arrayLocation, @Snippet.ConstantParameter Counters counters) {
        this.doExactArraycopyWithExpandedLoopSnippet(src, srcPos, dest, destPos, length, elementKind, arrayLocation);
    }

    protected void doExactArraycopyWithExpandedLoopSnippet(Object src, int srcPos, Object dest, int destPos, int length, JavaKind elementKind, LocationIdentity arrayLocation) {
        long scale = ReplacementsUtil.arrayIndexScale(INJECTED_META_ACCESS, elementKind);
        int arrayBaseOffset = ReplacementsUtil.getArrayBaseOffset(INJECTED_META_ACCESS, elementKind);
        long sourceOffset = (long)arrayBaseOffset + (long)srcPos * scale;
        long destOffset = (long)arrayBaseOffset + (long)destPos * scale;
        GuardingNode anchor = SnippetAnchorNode.anchor();
        if (BranchProbabilityNode.probability(0.9, src == dest) && BranchProbabilityNode.probability(0.09999999999999998, srcPos < destPos)) {
            int position = length - 1;
            while (BranchProbabilityNode.probability(0.99, position >= 0)) {
                Object value = GuardedUnsafeLoadNode.guardedLoad(src, sourceOffset + (long)position * scale, elementKind, arrayLocation, anchor);
                RawStoreNode.storeObject(dest, destOffset + (long)position * scale, value, elementKind, arrayLocation, true);
                --position;
            }
        } else {
            int position = 0;
            while (BranchProbabilityNode.probability(0.99, position < length)) {
                Object value = GuardedUnsafeLoadNode.guardedLoad(src, sourceOffset + (long)position * scale, elementKind, arrayLocation, anchor);
                RawStoreNode.storeObject(dest, destOffset + (long)position * scale, value, elementKind, arrayLocation, true);
                ++position;
            }
        }
    }

    @Snippet(allowPartialIntrinsicArgumentMismatch=true)
    public void checkcastArraycopySnippet(@Snippet.NonNullParameter Object src, int srcPos, @Snippet.NonNullParameter Object dest, int destPos, int length, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity arrayLocation, @Snippet.ConstantParameter Counters counters) {
        this.doCheckcastArraycopySnippet(src, srcPos, dest, destPos, length, elementKind, arrayLocation, counters);
    }

    protected abstract void doCheckcastArraycopySnippet(Object var1, int var2, Object var3, int var4, int var5, JavaKind var6, LocationIdentity var7, Counters var8);

    @Snippet(allowPartialIntrinsicArgumentMismatch=true)
    public void genericArraycopySnippet(@Snippet.NonNullParameter Object src, int srcPos, @Snippet.NonNullParameter Object dest, int destPos, int length, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity arrayLocation, @Snippet.ConstantParameter Counters counters) {
        this.doGenericArraycopySnippet(src, srcPos, dest, destPos, length, elementKind, arrayLocation, counters);
    }

    protected abstract void doGenericArraycopySnippet(Object var1, int var2, Object var3, int var4, int var5, JavaKind var6, LocationIdentity var7, Counters var8);

    private static void incrementLengthCounter(int length, Counters counters) {
        counters.lengthHistogram.inc(length);
    }

    protected static int[] createCheckLimitsResult(int srcPos, int destPos, int length) {
        int[] values = new int[]{srcPos, destPos, length};
        return values;
    }

    protected int[] checkLimits(Object src, int srcPos, Object dest, int destPos, int length, JavaKind elementKind, Counters counters) {
        if (BranchProbabilityNode.probability(0.0, srcPos < 0)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        int newSrcPos = PiNode.piCastPositive(srcPos, SnippetAnchorNode.anchor());
        if (BranchProbabilityNode.probability(0.0, destPos < 0)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        int newDestPos = PiNode.piCastPositive(destPos, SnippetAnchorNode.anchor());
        if (BranchProbabilityNode.probability(0.0, length < 0)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        int newLength = PiNode.piCastPositive(length, SnippetAnchorNode.anchor());
        if (BranchProbabilityNode.probability(0.0, newSrcPos > ArrayLengthNode.arrayLength(src) - newLength)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        if (BranchProbabilityNode.probability(0.0, newDestPos > ArrayLengthNode.arrayLength(dest) - newLength)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        counters.checkSuccessCounter.inc();
        return ArrayCopySnippets.createCheckLimitsResult(newSrcPos, newDestPos, newLength);
    }

    protected void checkArrayTypes(Object nonNullSrc, Object nonNullDest, ArrayCopyTypeCheck arrayTypeCheck) {
        if (arrayTypeCheck != ArrayCopyTypeCheck.NO_ARRAY_TYPE_CHECK) {
            if (arrayTypeCheck == ArrayCopyTypeCheck.HUB_BASED_ARRAY_TYPE_CHECK) {
                if (BranchProbabilityNode.probability(0.0, !this.hubsEqual(nonNullSrc, nonNullDest))) {
                    DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
                }
            } else if (arrayTypeCheck == ArrayCopyTypeCheck.LAYOUT_HELPER_BASED_ARRAY_TYPE_CHECK) {
                if (BranchProbabilityNode.probability(0.0, !this.layoutHelpersEqual(nonNullSrc, nonNullDest))) {
                    DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
                }
            } else {
                ReplacementsUtil.staticAssert(false, "unknown array type check ", (Object)arrayTypeCheck);
            }
        }
    }

    protected Supplier<PhaseSuite<CoreProviders>> midTierPreLoweringPhaseFactory() {
        return () -> null;
    }

    protected static enum ArrayCopyTypeCheck {
        UNDEFINED_ARRAY_TYPE_CHECK,
        NO_ARRAY_TYPE_CHECK,
        HUB_BASED_ARRAY_TYPE_CHECK,
        LAYOUT_HELPER_BASED_ARRAY_TYPE_CHECK;

    }

    protected static class Counters {
        public final SnippetCounter checkSuccessCounter;
        public final SnippetCounter checkAIOOBECounter;
        public final SnippetCounter zeroLengthStaticCounter;
        public final SnippetIntegerHistogram lengthHistogram;
        public final SnippetCounter systemArraycopyCounter;
        public final SnippetCounter systemArraycopyCopiedCounter;
        public final SnippetCounter genericArraycopyDifferentTypeCopiedCounter;
        public final SnippetCounter genericArraycopyDifferentTypeCounter;
        public final SnippetCounter objectCheckcastSameTypeCopiedCounter;
        public final SnippetCounter objectCheckcastSameTypeCounter;
        public final SnippetCounter objectCheckcastDifferentTypeCopiedCounter;
        public final SnippetCounter objectCheckcastDifferentTypeCounter;
        public final EnumMap<JavaKind, SnippetCounter> arraycopyCallCounters = new EnumMap(JavaKind.class);
        public final EnumMap<JavaKind, SnippetCounter> arraycopyCallCopiedCounters = new EnumMap(JavaKind.class);

        Counters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group checkCounters = factory.createSnippetCounterGroup("System.arraycopy checkInputs");
            SnippetCounter.Group callCounters = factory.createSnippetCounterGroup("System.arraycopy calls");
            SnippetCounter.Group copiedElementsCounters = factory.createSnippetCounterGroup("System.arraycopy copied elements");
            SnippetCounter.Group lengthCounters = factory.createSnippetCounterGroup("System.arraycopy with 0-length");
            this.checkSuccessCounter = new SnippetCounter(checkCounters, "checkSuccess", "checkSuccess");
            this.checkAIOOBECounter = new SnippetCounter(checkCounters, "checkAIOOBE", "checkAIOOBE");
            this.zeroLengthStaticCounter = new SnippetCounter(lengthCounters, "0-length copy static", "calls where the length is statically 0");
            this.lengthHistogram = new SnippetIntegerHistogram(lengthCounters, 2, "length", "length");
            this.systemArraycopyCounter = new SnippetCounter(callCounters, "native System.arraycopy", "JNI-based System.arraycopy call");
            this.systemArraycopyCopiedCounter = new SnippetCounter(copiedElementsCounters, "native System.arraycopy", "JNI-based System.arraycopy call");
            this.genericArraycopyDifferentTypeCounter = new SnippetCounter(callCounters, "generic[] stub", "generic arraycopy stub");
            this.genericArraycopyDifferentTypeCopiedCounter = new SnippetCounter(copiedElementsCounters, "generic[] stub", "generic arraycopy stub");
            this.objectCheckcastSameTypeCounter = new SnippetCounter(callCounters, "checkcast object[] (same-type)", "checkcast object[] stub but src.klass == dest.klass Object[] arrays");
            this.objectCheckcastSameTypeCopiedCounter = new SnippetCounter(copiedElementsCounters, "checkcast object[] (same-type)", "checkcast object[] stub but src.klass == dest.klass Object[] arrays");
            this.objectCheckcastDifferentTypeCounter = new SnippetCounter(callCounters, "checkcast object[] (store-check)", "checkcast object[] stub with store check");
            this.objectCheckcastDifferentTypeCopiedCounter = new SnippetCounter(copiedElementsCounters, "checkcast object[] (store-check)", "checkcast object[] stub with store check");
            this.createArraycopyCounter(JavaKind.Byte, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Boolean, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Char, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Short, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Int, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Long, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Float, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Double, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Object, callCounters, copiedElementsCounters);
        }

        void createArraycopyCounter(JavaKind kind, SnippetCounter.Group counters, SnippetCounter.Group copiedCounters) {
            this.arraycopyCallCounters.put(kind, new SnippetCounter(counters, String.valueOf(kind) + "[] stub", "arraycopy call for " + String.valueOf(kind) + "[] arrays"));
            this.arraycopyCallCopiedCounters.put(kind, new SnippetCounter(copiedCounters, String.valueOf(kind) + "[] stub", "arraycopy call for " + String.valueOf(kind) + "[] arrays"));
        }
    }

    public static enum WorkSnippetID {
        exactArraycopyWithExpandedLoopSnippet,
        checkcastArraycopySnippet,
        genericArraycopySnippet;

    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo delayedGenericArraycopySnippet;
        private final SnippetTemplate.SnippetInfo delayedExactArraycopyWithExpandedLoopSnippet;
        private final SnippetTemplate.SnippetInfo arraycopyExactStubCallSnippet;
        private final SnippetTemplate.SnippetInfo delayedCheckcastArraycopySnippet;
        private final SnippetTemplate.SnippetInfo arraycopyNativeExceptionSnippet;
        private final SnippetTemplate.SnippetInfo checkcastArraycopySnippet;
        private final SnippetTemplate.SnippetInfo genericArraycopySnippet;
        private final SnippetTemplate.SnippetInfo exactArraycopyWithExpandedLoopSnippet;
        private final boolean useOriginalArraycopy;
        private ResolvedJavaMethod originalArraycopy;
        private final Counters counters;
        private final Supplier<PhaseSuite<CoreProviders>> midTierPreLoweringPhaseFactory;

        public Templates(ArrayCopySnippets receiver, SnippetCounter.Group.Factory factory, OptionValues options, Providers providers) {
            super(options, providers);
            this.counters = new Counters(factory);
            this.useOriginalArraycopy = receiver.useOriginalArraycopy();
            this.delayedGenericArraycopySnippet = this.snippet(providers, receiver, "delayedGenericArraycopySnippet");
            this.delayedExactArraycopyWithExpandedLoopSnippet = this.snippet(providers, receiver, "delayedExactArraycopyWithExpandedLoopSnippet");
            this.arraycopyExactStubCallSnippet = this.snippet(providers, receiver, "arraycopyExactStubCallSnippet");
            this.delayedCheckcastArraycopySnippet = this.snippet(providers, receiver, "delayedCheckcastArraycopySnippet");
            this.arraycopyNativeExceptionSnippet = this.snippet(providers, null, "arraycopyNativeExceptionSnippet");
            this.checkcastArraycopySnippet = this.snippet(providers, receiver, "checkcastArraycopySnippet");
            this.genericArraycopySnippet = this.snippet(providers, receiver, "genericArraycopySnippet");
            this.exactArraycopyWithExpandedLoopSnippet = this.snippet(providers, receiver, "exactArraycopyWithExpandedLoopSnippet");
            this.midTierPreLoweringPhaseFactory = receiver.midTierPreLoweringPhaseFactory();
        }

        private SnippetTemplate.SnippetInfo getSnippet(WorkSnippetID workSnippetID) {
            switch (workSnippetID.ordinal()) {
                case 0: {
                    return this.exactArraycopyWithExpandedLoopSnippet;
                }
                case 1: {
                    return this.checkcastArraycopySnippet;
                }
                case 2: {
                    return this.genericArraycopySnippet;
                }
            }
            throw GraalError.shouldNotReachHere(workSnippetID.toString());
        }

        protected SnippetTemplate.SnippetInfo snippet(Providers providers, ArrayCopySnippets receiver, String methodName) {
            SnippetTemplate.SnippetInfo info = this.snippet(providers, ArrayCopySnippets.class, methodName, this.originalArraycopy(providers.getMetaAccess()), (Object)receiver, LocationIdentity.any());
            return info;
        }

        public void lower(ArrayCopyNode arraycopy, LoweringTool tool) {
            this.lower(arraycopy, false, tool);
        }

        public void lower(ArrayCopyNode arraycopy, boolean mayExpandThisArraycopy, LoweringTool tool) {
            LocationIdentity locationIdentity;
            ArrayCopyTypeCheck arrayTypeCheck;
            SnippetTemplate.SnippetInfo snippetInfo;
            JavaKind elementKind = BasicArrayCopyNode.selectComponentKind(arraycopy);
            ResolvedJavaType srcType = StampTool.typeOrNull(arraycopy.getSource().stamp(NodeView.DEFAULT));
            ResolvedJavaType destType = StampTool.typeOrNull(arraycopy.getDestination().stamp(NodeView.DEFAULT));
            if (!Templates.canBeArray(srcType) || !Templates.canBeArray(destType)) {
                snippetInfo = this.arraycopyNativeExceptionSnippet;
                arrayTypeCheck = ArrayCopyTypeCheck.UNDEFINED_ARRAY_TYPE_CHECK;
            } else {
                ResolvedJavaType destComponentType;
                ResolvedJavaType srcComponentType = srcType == null ? null : srcType.getComponentType();
                ResolvedJavaType resolvedJavaType = destComponentType = destType == null ? null : destType.getComponentType();
                if (arraycopy.isExact()) {
                    snippetInfo = this.arraycopyExactStubCallSnippet;
                    arrayTypeCheck = ArrayCopyTypeCheck.NO_ARRAY_TYPE_CHECK;
                } else if (srcComponentType == null && destComponentType == null) {
                    snippetInfo = this.delayedGenericArraycopySnippet;
                    arrayTypeCheck = ArrayCopyTypeCheck.NO_ARRAY_TYPE_CHECK;
                } else if (srcComponentType != null && destComponentType != null) {
                    if (!srcComponentType.isPrimitive() && !destComponentType.isPrimitive()) {
                        snippetInfo = this.delayedCheckcastArraycopySnippet;
                        arrayTypeCheck = ArrayCopyTypeCheck.NO_ARRAY_TYPE_CHECK;
                    } else {
                        assert (!srcComponentType.equals((Object)destComponentType)) : "must be handled by arraycopy.isExact()";
                        snippetInfo = this.arraycopyNativeExceptionSnippet;
                        arrayTypeCheck = ArrayCopyTypeCheck.UNDEFINED_ARRAY_TYPE_CHECK;
                    }
                } else {
                    ResolvedJavaType nonNullComponentType;
                    ResolvedJavaType resolvedJavaType2 = nonNullComponentType = srcComponentType != null ? srcComponentType : destComponentType;
                    if (nonNullComponentType.isPrimitive()) {
                        snippetInfo = this.arraycopyExactStubCallSnippet;
                        arrayTypeCheck = ArrayCopyTypeCheck.HUB_BASED_ARRAY_TYPE_CHECK;
                        elementKind = nonNullComponentType.getJavaKind();
                    } else {
                        snippetInfo = this.delayedCheckcastArraycopySnippet;
                        arrayTypeCheck = ArrayCopyTypeCheck.LAYOUT_HELPER_BASED_ARRAY_TYPE_CHECK;
                    }
                }
            }
            if (mayExpandThisArraycopy && snippetInfo == this.arraycopyExactStubCallSnippet) {
                snippetInfo = this.delayedExactArraycopyWithExpandedLoopSnippet;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippetInfo, arraycopy.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("src", arraycopy.getSource());
            args.add("srcPos", arraycopy.getSourcePosition());
            args.add("dest", arraycopy.getDestination());
            args.add("destPos", arraycopy.getDestinationPosition());
            args.add("length", arraycopy.getLength());
            if (snippetInfo != this.arraycopyNativeExceptionSnippet) {
                assert (arrayTypeCheck != ArrayCopyTypeCheck.UNDEFINED_ARRAY_TYPE_CHECK) : "Must not be arrayTypeCheck " + Assertions.errorMessageContext("arrayCopy", arraycopy);
                args.add("arrayTypeCheck", (Object)arrayTypeCheck);
            }
            LocationIdentity locationIdentity2 = locationIdentity = arraycopy.killsAnyLocation() ? LocationIdentity.any() : NamedLocationIdentity.getArrayLocation(elementKind);
            if (snippetInfo == this.arraycopyExactStubCallSnippet || snippetInfo == this.delayedExactArraycopyWithExpandedLoopSnippet) {
                assert (elementKind != null);
                args.add("elementKind", elementKind);
                args.add("locationIdentity", locationIdentity);
                args.add("elementKindCounter", this.counters.arraycopyCallCounters.get(elementKind));
                args.add("elementKindCopiedCounter", this.counters.arraycopyCallCopiedCounters.get(elementKind));
            }
            args.add("counters", this.counters);
            if (snippetInfo == this.delayedCheckcastArraycopySnippet) {
                args.add("elementKind", JavaKind.Illegal);
            }
            if (snippetInfo == this.delayedGenericArraycopySnippet) {
                args.add("elementKind", JavaKind.Illegal);
            }
            this.instantiate(tool, args, arraycopy);
        }

        public void lower(ArrayCopyWithDelayedLoweringNode arraycopy, LoweringTool tool) {
            if (!arraycopy.reachedRequiredLoweringStage()) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.getSnippet(arraycopy.getSnippet()), arraycopy.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("src", arraycopy.getSource());
            args.add("srcPos", arraycopy.getSourcePosition());
            args.add("dest", arraycopy.getDestination());
            args.add("destPos", arraycopy.getDestinationPosition());
            args.add("length", arraycopy.getLength());
            JavaKind elementKind = arraycopy.getElementKind();
            args.add("elementKind", elementKind == null ? JavaKind.Illegal : elementKind);
            LocationIdentity locationIdentity = elementKind == null ? LocationIdentity.any() : NamedLocationIdentity.getArrayLocation(arraycopy.getElementKind());
            args.add("arrayLocation", locationIdentity);
            args.add("counters", this.counters);
            this.instantiate(tool, args, arraycopy);
        }

        private static boolean canBeArray(ResolvedJavaType type) {
            return type == null || type.isJavaLangObject() || type.isArray();
        }

        private void instantiate(LoweringTool tool, SnippetTemplate.Arguments args, BasicArrayCopyNode arraycopy) {
            StructuredGraph graph = arraycopy.graph();
            SnippetTemplate template = this.template(tool, arraycopy, args);
            UnmodifiableEconomicMap<Node, Node> duplicates = template.instantiate(tool.getMetaAccess(), arraycopy, SnippetTemplate.DEFAULT_REPLACER, args, false);
            for (Node originalNode : duplicates.getKeys()) {
                if (originalNode instanceof InvokeNode) {
                    InvokeNode invoke = (InvokeNode)duplicates.get((Object)originalNode);
                    assert (invoke.asNode().graph() == graph) : "Graphs must match " + Assertions.errorMessageContext("invoke", invoke, "invoke.graph", invoke.asNode().graph(), "graph", graph);
                    CallTargetNode call = invoke.callTarget();
                    if (!call.targetMethod().equals((Object)this.originalArraycopy)) {
                        throw new GraalError("unexpected invoke %s in snippet", call.targetMethod());
                    }
                    assert (!BytecodeFrame.isPlaceholderBci((int)arraycopy.bci())) : arraycopy;
                    assert (!arraycopy.graph().getGuardsStage().areFrameStatesAtSideEffects() || Templates.assertEquals(arraycopy.bci(), invoke.bci()));
                    assert (Templates.assertEquals(arraycopy.stateDuring(), invoke.stateDuring()));
                    assert (arraycopy.stateDuring() != null || arraycopy.stateAfter() != null) : arraycopy;
                    assert (Templates.assertEquals(arraycopy.stateAfter(), invoke.stateAfter()));
                    continue;
                }
                if (!(originalNode instanceof InvokeWithExceptionNode)) continue;
                throw new GraalError("unexpected invoke with exception %s in snippet", originalNode);
            }
            GraphUtil.killCFG(arraycopy);
        }

        private static boolean assertEquals(int expected, int actual) {
            assert (actual == expected) : "Expected " + expected + ", got " + actual;
            return true;
        }

        private static boolean assertEquals(FrameState expected, FrameState actual) {
            assert (expected == null && actual == null || actual.dataFlowEquals(expected)) : "Expected " + String.valueOf(expected) + ", got " + String.valueOf(actual);
            return true;
        }

        private ResolvedJavaMethod originalArraycopy(MetaAccessProvider metaAccess) throws GraalError {
            if (!this.useOriginalArraycopy) {
                return null;
            }
            if (this.originalArraycopy == null) {
                try {
                    this.originalArraycopy = Templates.findMethod(metaAccess, System.class, "arraycopy");
                }
                catch (SecurityException e) {
                    throw new GraalError(e);
                }
            }
            return this.originalArraycopy;
        }

        @Override
        protected PhaseSuite<CoreProviders> createMidTierPreLoweringPhases() {
            return this.midTierPreLoweringPhaseFactory.get();
        }
    }
}

