/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.aarch64;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.SignedDivNode;
import jdk.graal.compiler.nodes.calc.SignedRemNode;
import jdk.graal.compiler.nodes.calc.UnsignedDivNode;
import jdk.graal.compiler.nodes.calc.UnsignedRemNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public class AArch64IntegerArithmeticSnippets
extends SnippetTemplate.AbstractTemplates
implements Snippets {
    private final SnippetTemplate.SnippetInfo idiv;
    private final SnippetTemplate.SnippetInfo ldiv;
    private final SnippetTemplate.SnippetInfo irem;
    private final SnippetTemplate.SnippetInfo lrem;
    private final SnippetTemplate.SnippetInfo uidiv;
    private final SnippetTemplate.SnippetInfo uldiv;
    private final SnippetTemplate.SnippetInfo uirem;
    private final SnippetTemplate.SnippetInfo ulrem;

    public AArch64IntegerArithmeticSnippets(OptionValues options, Providers providers) {
        super(options, providers);
        this.idiv = this.snippet(providers, AArch64IntegerArithmeticSnippets.class, "idivSnippet", new LocationIdentity[0]);
        this.ldiv = this.snippet(providers, AArch64IntegerArithmeticSnippets.class, "ldivSnippet", new LocationIdentity[0]);
        this.irem = this.snippet(providers, AArch64IntegerArithmeticSnippets.class, "iremSnippet", new LocationIdentity[0]);
        this.lrem = this.snippet(providers, AArch64IntegerArithmeticSnippets.class, "lremSnippet", new LocationIdentity[0]);
        this.uidiv = this.snippet(providers, AArch64IntegerArithmeticSnippets.class, "uidivSnippet", new LocationIdentity[0]);
        this.uldiv = this.snippet(providers, AArch64IntegerArithmeticSnippets.class, "uldivSnippet", new LocationIdentity[0]);
        this.uirem = this.snippet(providers, AArch64IntegerArithmeticSnippets.class, "uiremSnippet", new LocationIdentity[0]);
        this.ulrem = this.snippet(providers, AArch64IntegerArithmeticSnippets.class, "ulremSnippet", new LocationIdentity[0]);
    }

    public void lower(IntegerDivRemNode node, LoweringTool tool) {
        SnippetTemplate.SnippetInfo snippet;
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return;
        }
        JavaKind kind = node.stamp(NodeView.DEFAULT).getStackKind();
        assert (kind == JavaKind.Int || kind == JavaKind.Long) : Assertions.errorMessage(node);
        if (node instanceof SafeNode) {
            return;
        }
        if (node instanceof SignedDivNode) {
            snippet = kind == JavaKind.Int ? this.idiv : this.ldiv;
        } else if (node instanceof SignedRemNode) {
            snippet = kind == JavaKind.Int ? this.irem : this.lrem;
        } else if (node instanceof UnsignedDivNode) {
            snippet = kind == JavaKind.Int ? this.uidiv : this.uldiv;
        } else if (node instanceof UnsignedRemNode) {
            snippet = kind == JavaKind.Int ? this.uirem : this.ulrem;
        } else {
            throw GraalError.shouldNotReachHereUnexpectedValue(node);
        }
        StructuredGraph graph = node.graph();
        SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
        args.add("x", node.getX());
        args.add("y", node.getY());
        IntegerStamp yStamp = (IntegerStamp)node.getY().stamp(NodeView.DEFAULT);
        boolean needsZeroCheck = node.canDeoptimize() && node.getZeroGuard() == null && yStamp.contains(0L);
        args.add("needsZeroCheck", needsZeroCheck);
        this.template(tool, node, args).instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
    }

    @Snippet
    public static int idivSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
            return AArch64IntegerArithmeticSnippets.safeDiv(x, y);
        }
        return AArch64IntegerArithmeticSnippets.safeDiv(x, PiNode.piCastNonZero(y, SnippetAnchorNode.anchor()));
    }

    @Snippet
    public static long ldivSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
            return AArch64IntegerArithmeticSnippets.safeDiv(x, y);
        }
        return AArch64IntegerArithmeticSnippets.safeDiv(x, PiNode.piCastNonZero(y, SnippetAnchorNode.anchor()));
    }

    @Snippet
    public static int iremSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
            return AArch64IntegerArithmeticSnippets.safeRem(x, y);
        }
        return AArch64IntegerArithmeticSnippets.safeRem(x, PiNode.piCastNonZero(y, SnippetAnchorNode.anchor()));
    }

    @Snippet
    public static long lremSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
            return AArch64IntegerArithmeticSnippets.safeRem(x, y);
        }
        return AArch64IntegerArithmeticSnippets.safeRem(x, PiNode.piCastNonZero(y, SnippetAnchorNode.anchor()));
    }

    @Snippet
    public static int uidivSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeUDiv(x, y);
    }

    @Snippet
    public static long uldivSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeUDiv(x, y);
    }

    @Snippet
    public static int uiremSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeURem(x, y);
    }

    @Snippet
    public static long ulremSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeURem(x, y);
    }

    private static void checkForZero(int y) {
        if (BranchProbabilityNode.probability(0.0, y == 0)) {
            DeoptimizeNode.deopt(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.ArithmeticException);
        }
    }

    private static void checkForZero(long y) {
        if (BranchProbabilityNode.probability(0.0, y == 0L)) {
            DeoptimizeNode.deopt(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.ArithmeticException);
        }
    }

    @Node.NodeIntrinsic(value=SafeSignedDivNode.class)
    private static native int safeDiv(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeSignedDivNode.class)
    private static native long safeDiv(long var0, long var2);

    @Node.NodeIntrinsic(value=SafeSignedRemNode.class)
    private static native int safeRem(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeSignedRemNode.class)
    private static native long safeRem(long var0, long var2);

    @Node.NodeIntrinsic(value=SafeUnsignedDivNode.class)
    private static native int safeUDiv(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeUnsignedDivNode.class)
    private static native long safeUDiv(long var0, long var2);

    @Node.NodeIntrinsic(value=SafeUnsignedRemNode.class)
    private static native int safeURem(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeUnsignedRemNode.class)
    private static native long safeURem(long var0, long var2);

    private static interface SafeNode {
    }

    @NodeInfo
    static class SafeUnsignedRemNode
    extends UnsignedRemNode
    implements SafeNode {
        public static final NodeClass<SafeUnsignedRemNode> TYPE = NodeClass.create(SafeUnsignedRemNode.class);

        protected SafeUnsignedRemNode(ValueNode x, ValueNode y) {
            super(TYPE, x, y, null);
        }

        @Override
        public boolean canDeoptimize() {
            return false;
        }
    }

    @NodeInfo
    static class SafeUnsignedDivNode
    extends UnsignedDivNode
    implements SafeNode {
        public static final NodeClass<SafeUnsignedDivNode> TYPE = NodeClass.create(SafeUnsignedDivNode.class);

        protected SafeUnsignedDivNode(ValueNode x, ValueNode y) {
            super(TYPE, x, y, null);
        }

        @Override
        public boolean canDeoptimize() {
            return false;
        }
    }

    @NodeInfo
    static class SafeSignedRemNode
    extends SignedRemNode
    implements SafeNode {
        public static final NodeClass<SafeSignedRemNode> TYPE = NodeClass.create(SafeSignedRemNode.class);

        protected SafeSignedRemNode(ValueNode x, ValueNode y) {
            super(TYPE, x, y, null);
        }

        @Override
        protected SignedRemNode createWithInputs(ValueNode forX, ValueNode forY, GuardingNode forZeroCheck) {
            assert (forZeroCheck == null);
            SafeSignedRemNode rem = new SafeSignedRemNode(forX, forY);
            return rem;
        }

        @Override
        public boolean canDeoptimize() {
            return false;
        }

        @Override
        public boolean canFloat() {
            return false;
        }
    }

    @NodeInfo
    static class SafeSignedDivNode
    extends SignedDivNode
    implements SafeNode {
        public static final NodeClass<SafeSignedDivNode> TYPE = NodeClass.create(SafeSignedDivNode.class);

        protected SafeSignedDivNode(ValueNode x, ValueNode y) {
            super(TYPE, x, y, null);
        }

        @Override
        protected SignedDivNode createWithInputs(ValueNode forX, ValueNode forY, GuardingNode forZeroCheck, FrameState forStateBefore) {
            assert (forZeroCheck == null);
            SafeSignedDivNode div = new SafeSignedDivNode(forX, forY);
            return div;
        }

        @Override
        public boolean canDeoptimize() {
            return false;
        }

        @Override
        public boolean canFloat() {
            return false;
        }
    }
}

