/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.word.LocationIdentity;

public abstract class TestSnippets {

    public static class TransplantTestSnippets
    implements Snippets {
        static int S;

        @Snippet(allowMissingProbabilities=true)
        public static int producer() {
            if (S == 88) {
                GraalDirectives.sideEffect(1);
            } else {
                GraalDirectives.sideEffect(123);
            }
            GraalDirectives.controlFlowAnchor();
            return 42;
        }

        @Snippet(allowMissingProbabilities=true)
        public static int producerWithArgs(int a, int b) {
            int ret = 0;
            if (S == 88) {
                GraalDirectives.sideEffect(1);
                ret += S;
            } else {
                GraalDirectives.sideEffect(123);
            }
            GraalDirectives.controlFlowAnchor();
            return ret + 42 + a + b;
        }

        @Snippet(allowMissingProbabilities=true)
        public static int producerWithDeopt(int a, int b) {
            if (a == 99) {
                GraalDirectives.deoptimizeAndInvalidate();
                return 144 + a + b;
            }
            return 123 + b;
        }

        public static class Templates
        extends SnippetTemplate.AbstractTemplates {
            public final SnippetTemplate.SnippetInfo producer;
            public final SnippetTemplate.SnippetInfo producerWithArgs;
            public final SnippetTemplate.SnippetInfo producerWithDeopt;

            public Templates(OptionValues options, Providers providers) {
                super(options, providers);
                assert (!ImageInfo.inImageRuntimeCode()) : "This code must only be used in jargraal unittests";
                this.producer = this.snippet(providers, TransplantTestSnippets.class, "producer", Snippet.SnippetType.TRANSPLANTED_SNIPPET, new LocationIdentity[0]);
                this.producerWithArgs = this.snippet(providers, TransplantTestSnippets.class, "producerWithArgs", Snippet.SnippetType.TRANSPLANTED_SNIPPET, new LocationIdentity[0]);
                this.producerWithDeopt = this.snippet(providers, TransplantTestSnippets.class, "producerWithDeopt", Snippet.SnippetType.TRANSPLANTED_SNIPPET, new LocationIdentity[0]);
            }
        }
    }
}

