/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.StringHelperIntrinsics;
import jdk.graal.compiler.replacements.nodes.ArrayIndexOfNode;
import jdk.graal.compiler.replacements.nodes.ArrayRegionEqualsNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.word.LocationIdentity;

public class StringLatin1Snippets
implements Snippets {
    public static final MetaAccessProvider INJECTED = null;

    private static long byteArrayOffset(long offset) {
        return (long)ReplacementsUtil.byteArrayBaseOffset(INJECTED) + offset * ReplacementsUtil.byteArrayIndexScale(INJECTED);
    }

    @Snippet
    public static int indexOf(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringLatin1.indexOf invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringLatin1.indexOf invalid args: targetCount <= 0");
        if (GraalDirectives.injectBranchProbability(0.25, sourceCount - fromIndex < targetCount)) {
            return -1;
        }
        if (GraalDirectives.injectBranchProbability(0.25, targetCount == 1)) {
            return ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, Stride.S1, LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)source, StringLatin1Snippets.byteArrayOffset(0L), sourceCount, fromIndex, Byte.toUnsignedInt(StringHelperIntrinsics.getByte(target, 0)));
        }
        int offset = fromIndex;
        int haystackLength = sourceCount - (targetCount - 2);
        if (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            byte b1 = StringHelperIntrinsics.getByte(target, 0);
            byte b2 = StringHelperIntrinsics.getByte(target, 1);
            do {
                int indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, (indexOfResult = ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, Stride.S1, LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, (Object)source, StringLatin1Snippets.byteArrayOffset(0L), haystackLength, offset, Byte.toUnsignedInt(b1), Byte.toUnsignedInt(b2))) < 0)) {
                    return -1;
                }
                offset = indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                    return offset;
                }
                if (!GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals((Object)source, StringLatin1Snippets.byteArrayOffset(offset), (Object)target, StringLatin1Snippets.byteArrayOffset(0L), targetCount, JavaKind.Byte, Stride.S1, Stride.S1))) continue;
                return offset;
            } while (GraalDirectives.injectBranchProbability(0.75, ++offset < haystackLength));
        }
        return -1;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        public final SnippetTemplate.SnippetInfo indexOf;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.indexOf = this.snippet(providers, StringLatin1Snippets.class, "indexOf", new LocationIdentity[0]);
        }
    }
}

