/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.api.replacements.SnippetTemplateCache;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.RetryableBailoutException;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.graph.Position;
import jdk.graal.compiler.graph.iterators.NodePredicates;
import jdk.graal.compiler.loop.phases.LoopTransformations;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeoptBciSupplier;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.InliningLog;
import jdk.graal.compiler.nodes.Invokable;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MemoryMapControlSinkNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueNodeInterface;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.debug.ControlFlowAnchorNode;
import jdk.graal.compiler.nodes.extended.AbstractBoxingNode;
import jdk.graal.compiler.nodes.extended.CaptureStateBeginNode;
import jdk.graal.compiler.nodes.extended.GuardedNode;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryAnchorNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MemoryMap;
import jdk.graal.compiler.nodes.memory.MemoryMapNode;
import jdk.graal.compiler.nodes.memory.MemoryPhiNode;
import jdk.graal.compiler.nodes.memory.MultiMemoryKill;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.ArrayLengthProvider;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.MemoryEdgeProxy;
import jdk.graal.compiler.nodes.spi.SnippetParameterInfo;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.common.FloatingReadPhase;
import jdk.graal.compiler.phases.common.GuardLoweringPhase;
import jdk.graal.compiler.phases.common.HighTierLoweringPhase;
import jdk.graal.compiler.phases.common.IterativeConditionalEliminationPhase;
import jdk.graal.compiler.phases.common.LowTierLoweringPhase;
import jdk.graal.compiler.phases.common.MidTierLoweringPhase;
import jdk.graal.compiler.phases.common.RemoveValueProxyPhase;
import jdk.graal.compiler.phases.common.SnippetFrameStateAssignment;
import jdk.graal.compiler.phases.common.WriteBarrierAdditionPhase;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.graph.ReentrantNodeIterator;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.PlaceholderLogicNode;
import jdk.graal.compiler.replacements.SnippetCounterNode;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.CStringConstant;
import jdk.graal.compiler.replacements.nodes.ExplodeLoopNode;
import jdk.graal.compiler.replacements.nodes.FallbackInvokeWithExceptionNode;
import jdk.graal.compiler.replacements.nodes.LoadSnippetVarargParameterNode;
import jdk.graal.compiler.util.CollectionsUtil;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapePhase;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;

public class SnippetTemplate {
    private static final TimerKey totalInstantiationTimer = DebugContext.timer("SnippetInstantiationTime");
    private static final CounterKey totalInstantiationCounter = DebugContext.counter("SnippetInstantiationCount");
    private boolean mayRemoveLocation = false;
    private static final TimerKey SnippetTemplateCreationTime = DebugContext.timer("SnippetTemplateCreationTime");
    private static final CounterKey SnippetTemplates = DebugContext.counter("SnippetTemplateCount");
    private static final Object UNUSED_PARAMETER = "UNUSED_PARAMETER";
    private static final Object CONSTANT_PARAMETER = "CONSTANT_PARAMETER";
    private final SnippetReflectionProvider snippetReflection;
    private final StructuredGraph snippet;
    private final SnippetInfo info;
    private final Object[] parameters;
    private final ReturnNode returnNode;
    private final PlaceholderLogicNode artificialReturnCondition;
    private final UnwindNode unwindPath;
    private final FallbackInvokeWithExceptionNode fallbackInvoke;
    private final MemoryAnchorNode memoryAnchor;
    private final ArrayList<StateSplit> sideEffectNodes;
    private final ArrayList<DeoptimizingNode> deoptNodes;
    private SnippetFrameStateAssignment.SnippetFrameStateAssignmentClosure frameStateAssignment;
    private final ArrayList<ValueNode> placeholderStampedNodes;
    private final ArrayList<Node> nodes;
    public static final UsageReplacer DEFAULT_REPLACER = new UsageReplacer(){

        @Override
        public void replace(ValueNode oldNode, ValueNode newNode) {
            if (newNode == null) {
                assert (oldNode.hasNoUsages());
            } else {
                oldNode.replaceAtUsages(newNode);
            }
        }
    };

    protected SnippetTemplate(OptionValues options, DebugContext debug, CoreProviders providers, SnippetReflectionProvider snippetReflection, Arguments args, boolean trackNodeSourcePosition, ValueNode replacee, PhaseSuite<CoreProviders> midTierPreLoweringPhases, PhaseSuite<CoreProviders> midTierPostLoweringPhases) {
        this.snippetReflection = snippetReflection;
        this.info = args.info;
        Object[] constantArgs = SnippetTemplate.getConstantArgs(args);
        BitSet nonNullParameters = SnippetTemplate.getNonNullParameters(args);
        StructuredGraph snippetGraph = providers.getReplacements().getSnippet(args.info.method, args.info.original, constantArgs, nonNullParameters, trackNodeSourcePosition, replacee.getNodeSourcePosition(), options);
        assert (snippetGraph.getAssumptions() == null) : snippetGraph;
        ResolvedJavaMethod method = snippetGraph.method();
        Signature signature = method.getSignature();
        StructuredGraph snippetCopy = new StructuredGraph.Builder(options, debug).name(snippetGraph.name).method(snippetGraph.method()).trackNodeSourcePosition(snippetGraph.trackNodeSourcePosition()).setIsSubstitution(true).build();
        snippetCopy.getGraphState().setGuardsStage(snippetGraph.getGuardsStage());
        snippetCopy.getGraphState().getStageFlags().addAll(snippetGraph.getGraphState().getStageFlags());
        assert (!GraalOptions.TrackNodeSourcePosition.getValue(options).booleanValue() || snippetCopy.trackNodeSourcePosition());
        try (DebugContext.Scope scope = debug.scope((Object)"SpecializeSnippet", snippetCopy);){
            boolean needsMergeStateMap;
            Node memoryMap;
            if (!snippetGraph.isUnsafeAccessTrackingEnabled()) {
                snippetCopy.disableUnsafeAccessTracking();
            }
            assert (snippetCopy.isSubstitution());
            assert (!DebugOptions.DumpOnError.getValue(options).booleanValue() || debug.contextLookupTopdown(StructuredGraph.class) == snippetCopy) : "DumpOnError should cause the snippet graph to be available for dumping";
            EconomicMap nodeReplacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            nodeReplacements.put((Object)snippetGraph.start(), (Object)snippetCopy.start());
            MetaAccessProvider metaAccess = providers.getMetaAccess();
            assert (SnippetTemplate.checkTemplate(metaAccess, args, method));
            int parameterCount = args.info.getParameterCount();
            VarargsPlaceholderNode[] placeholders = new VarargsPlaceholderNode[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                ParameterNode parameter = snippetGraph.getParameter(i);
                if (parameter == null) continue;
                if (args.info.isConstantParameter(i)) {
                    ConstantNode constantNode;
                    Object arg = args.values[i];
                    JavaKind kind = signature.getParameterKind(i);
                    if (arg instanceof Constant) {
                        Stamp stamp = args.constStamps[i];
                        if (stamp == null) {
                            assert (arg instanceof JavaConstant) : "could not determine type of constant " + String.valueOf(arg);
                            constantNode = ConstantNode.forConstant((JavaConstant)arg, metaAccess, snippetCopy);
                        } else {
                            constantNode = ConstantNode.forConstant(stamp, (Constant)arg, metaAccess, snippetCopy);
                        }
                    } else {
                        constantNode = ConstantNode.forConstant(this.snippetReflection.forBoxed(kind, arg), metaAccess, snippetCopy);
                    }
                    nodeReplacements.put((Object)parameter, (Object)constantNode);
                    continue;
                }
                if (args.info.isVarargsParameter(i)) {
                    Varargs varargs = (Varargs)args.values[i];
                    VarargsPlaceholderNode placeholder = snippetCopy.unique(new VarargsPlaceholderNode(varargs, providers.getMetaAccess()));
                    nodeReplacements.put((Object)parameter, (Object)placeholder);
                    placeholders[i] = placeholder;
                    continue;
                }
                if (!args.info.isNonNullParameter(i)) continue;
                GraalError.guarantee(StampTool.isPointerNonNull(parameter), "Expected %s to have a non-null stamp, but was %s", (Object)parameter, (Object)parameter.stamp(NodeView.DEFAULT));
            }
            try (InliningLog.UpdateScope updateScope = InliningLog.openDefaultUpdateScope(snippetCopy.getInliningLog());){
                EconomicMap<Node, Node> duplicates = snippetCopy.addDuplicates(snippetGraph.getNodes(), (Graph)snippetGraph, snippetGraph.getNodeCount(), (UnmodifiableEconomicMap<Node, Node>)nodeReplacements);
                if (updateScope != null) {
                    snippetCopy.getInliningLog().replaceLog((UnmodifiableEconomicMap<Node, Node>)duplicates, snippetGraph.getInliningLog());
                }
            }
            debug.dump(2, snippetCopy, "Before specialization");
            this.parameters = new Object[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                if (args.info.isConstantParameter(i)) {
                    this.parameters[i] = CONSTANT_PARAMETER;
                    continue;
                }
                if (args.info.isVarargsParameter(i)) {
                    assert (snippetCopy.getParameter(i) == null);
                    Varargs varargs = (Varargs)args.values[i];
                    int length = varargs.length;
                    ParameterNode[] params = new ParameterNode[length];
                    Stamp stamp = varargs.stamp;
                    for (int j = 0; j < length; ++j) {
                        ParameterNode parameterNode;
                        assert (parameterCount < 10000) : Assertions.errorMessage(parameterCount, params);
                        int idx = (i + 1) * 10000 + j;
                        assert (idx >= parameterCount) : "collision in parameter numbering";
                        params[j] = parameterNode = snippetCopy.addOrUnique(new ParameterNode(idx, StampPair.createSingle(stamp)));
                    }
                    this.parameters[i] = params;
                    VarargsPlaceholderNode placeholder = placeholders[i];
                    if (placeholder == null) continue;
                    for (Node node : placeholder.usages().snapshot()) {
                        if (node instanceof LoadIndexedNode) {
                            LoadIndexedNode loadIndexed = (LoadIndexedNode)node;
                            debug.dump(2, (Object)snippetCopy, "Before replacing %s", loadIndexed);
                            LoadSnippetVarargParameterNode loadSnippetParameter = snippetCopy.add(new LoadSnippetVarargParameterNode(params, loadIndexed.index(), loadIndexed.stamp(NodeView.DEFAULT)));
                            snippetCopy.replaceFixedWithFixed(loadIndexed, loadSnippetParameter);
                            debug.dump(2, (Object)snippetCopy, "After replacing %s", loadIndexed);
                            continue;
                        }
                        if (!(node instanceof StoreIndexedNode)) continue;
                        throw new GraalError("Can't store into VarargsParameter array");
                    }
                    continue;
                }
                ParameterNode local = snippetCopy.getParameter(i);
                this.parameters[i] = local == null ? UNUSED_PARAMETER : local;
            }
            SnippetTemplate.explodeLoops(snippetCopy, providers);
            List<UnwindNode> unwindNodes = snippetCopy.getNodes(UnwindNode.TYPE).snapshot();
            if (unwindNodes.size() == 0) {
                this.unwindPath = null;
            } else {
                if (unwindNodes.size() > 1) {
                    throw GraalError.shouldNotReachHere("Graph has more than one UnwindNode");
                }
                this.unwindPath = unwindNodes.get(0);
            }
            List<FallbackInvokeWithExceptionNode> fallbackInvokes = snippetCopy.getNodes().filter(FallbackInvokeWithExceptionNode.class).snapshot();
            if (fallbackInvokes.size() == 0) {
                this.fallbackInvoke = null;
            } else {
                if (fallbackInvokes.size() > 1) {
                    throw GraalError.shouldNotReachHere("Graph has more than one " + FallbackInvokeWithExceptionNode.class.getSimpleName());
                }
                this.fallbackInvoke = fallbackInvokes.get(0);
            }
            CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
            GraphState.GuardsStage guardsStage = args.cacheKey.guardsStage;
            if (this.info.type == Snippet.SnippetType.INLINED_SNIPPET) {
                boolean needsPEA = false;
                boolean needsCE = false;
                LoweringTool.LoweringStage loweringStage = args.cacheKey.loweringStage;
                for (Node n : snippetCopy.getNodes()) {
                    if (!needsPEA && (n instanceof AbstractNewObjectNode || n instanceof AbstractBoxingNode)) {
                        needsPEA = true;
                        continue;
                    }
                    if (needsCE || !(n instanceof LogicNode)) continue;
                    needsCE = true;
                }
                if (needsPEA) {
                    new PartialEscapePhase(true, true, canonicalizer, null, options, SchedulePhase.SchedulingStrategy.LATEST).apply(snippetCopy, providers);
                }
                if (needsCE) {
                    new IterativeConditionalEliminationPhase(canonicalizer, false).apply(snippetCopy, providers);
                }
                try (DebugContext.Scope scope2 = debug.scope((Object)"LoweringSnippetTemplate_HIGH_TIER", snippetCopy);){
                    new HighTierLoweringPhase(canonicalizer).apply(snippetCopy, providers);
                }
                catch (Throwable throwable) {
                    throw debug.handle(throwable);
                }
                if (loweringStage != LoweringTool.StandardLoweringStage.HIGH_TIER) {
                    assert (!guardsStage.allowsFloatingGuards()) : guardsStage;
                    new FloatingReadPhase(true, canonicalizer).apply(snippetCopy, providers);
                    if (!snippetCopy.getGraphState().isExplicitExceptionsNoDeopt()) {
                        new GuardLoweringPhase().apply(snippetCopy, providers);
                    }
                    assert (snippetCopy.getGraphState().isAfterStage(GraphState.StageFlag.GUARD_LOWERING));
                    new RemoveValueProxyPhase(canonicalizer).apply(snippetCopy, providers);
                    if (midTierPreLoweringPhases != null) {
                        midTierPreLoweringPhases.apply(snippetCopy, providers);
                    }
                    try (DebugContext.Scope scope3 = debug.scope((Object)"LoweringSnippetTemplate_MID_TIER", snippetCopy);){
                        new MidTierLoweringPhase(canonicalizer).apply(snippetCopy, providers);
                        snippetCopy.getGraphState().setAfterFSA();
                        snippetCopy.getGraphState().forceDisableFrameStateVerification();
                    }
                    catch (Throwable throwable) {
                        throw debug.handle(throwable);
                    }
                    if (loweringStage != LoweringTool.StandardLoweringStage.MID_TIER) {
                        if (midTierPostLoweringPhases != null) {
                            midTierPostLoweringPhases.apply(snippetCopy, providers);
                        }
                        new WriteBarrierAdditionPhase().apply(snippetCopy, providers);
                        try (DebugContext.Scope scope4 = debug.scope((Object)"LoweringSnippetTemplate_LOW_TIER", snippetCopy);){
                            new LowTierLoweringPhase(canonicalizer).apply(snippetCopy, providers);
                        }
                        catch (Throwable throwable) {
                            throw debug.handle(throwable);
                        }
                        new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(snippetCopy);
                    }
                }
            } else {
                GraalError.guarantee(snippetCopy.getNodes(ReturnNode.TYPE).count() == 1, "Snippet %s must only have a single return but has %s", (Object)snippetCopy, snippetCopy.getNodes(ReturnNode.TYPE).snapshot());
                snippetCopy.addBeforeFixed(snippetCopy.getNodes(ReturnNode.TYPE).first(), snippetCopy.add(new ControlFlowAnchorNode()));
            }
            assert (SnippetTemplate.checkAllVarargPlaceholdersAreDeleted(parameterCount, placeholders));
            ArrayList<StateSplit> curSideEffectNodes = new ArrayList<StateSplit>();
            ArrayList<DeoptimizingNode> curDeoptNodes = new ArrayList<DeoptimizingNode>();
            ArrayList<ValueNode> curPlaceholderStampedNodes = new ArrayList<ValueNode>();
            for (Node node : snippetCopy.getNodes()) {
                DeoptimizingNode deoptNode;
                ValueNode valueNode;
                if (node instanceof ValueNode && (valueNode = (ValueNode)node).stamp(NodeView.DEFAULT) == PiNode.PlaceholderStamp.singleton()) {
                    curPlaceholderStampedNodes.add(valueNode);
                }
                if (node instanceof StateSplit) {
                    FrameState frameState;
                    StateSplit stateSplit = (StateSplit)((Object)node);
                    boolean hasSideEffect = stateSplit.hasSideEffect();
                    if (hasSideEffect && stateSplit instanceof MemoryAccess && MemoryKill.isSingleMemoryKill(stateSplit.asNode())) {
                        boolean bl = hasSideEffect = !this.info.isPrivateLocation(((SingleMemoryKill)((Object)stateSplit)).getKilledLocationIdentity());
                    }
                    if (hasSideEffect) {
                        curSideEffectNodes.add((StateSplit)((Object)node));
                    }
                    if (this.info.type == Snippet.SnippetType.INLINED_SNIPPET && (frameState = stateSplit.stateAfter()) != null) {
                        stateSplit.setStateAfter(null);
                    }
                }
                if (!(node instanceof DeoptimizingNode) || !(deoptNode = (DeoptimizingNode)((Object)node)).canDeoptimize()) continue;
                curDeoptNodes.add(deoptNode);
            }
            this.snippet = snippetCopy;
            StartNode startNode = this.snippet.start();
            MemoryAnchorNode anchor = snippetCopy.add(new MemoryAnchorNode(this.info.privateLocations));
            snippetCopy.start().replaceAtUsages((Node)anchor, InputType.Memory);
            debug.dump(5, (Object)snippetCopy, "After adding memory anchor %s", anchor);
            if (anchor.hasNoUsages()) {
                anchor.safeDelete();
                this.memoryAnchor = null;
            } else {
                boolean needsAnchor;
                boolean needsMemoryMaps = false;
                for (MemoryMapControlSinkNode sinkNode : this.snippet.getNodes(MemoryMapControlSinkNode.TYPE)) {
                    MemoryMapNode memoryMap2 = sinkNode.getMemoryMap();
                    if (memoryMap2.getLocations().size() <= 1 && memoryMap2.getLastLocationAccess(LocationIdentity.any()) == anchor) continue;
                    needsMemoryMaps = true;
                    break;
                }
                if (needsMemoryMaps) {
                    needsAnchor = true;
                } else {
                    needsAnchor = anchor.usages().filter(NodePredicates.isNotA(MemoryMapNode.class)).isNotEmpty();
                    memoryMap = null;
                    for (ReturnNode returnNode : this.snippet.getNodes(ReturnNode.TYPE)) {
                        if (memoryMap == null) {
                            memoryMap = returnNode.getMemoryMap();
                        } else assert (memoryMap == returnNode.getMemoryMap()) : Assertions.errorMessage(memoryMap, returnNode);
                        returnNode.setMemoryMap(null);
                    }
                    if (memoryMap != null) {
                        memoryMap.safeDelete();
                    }
                    Node unwindMemoryMap = null;
                    for (UnwindNode unwindNode : this.snippet.getNodes(UnwindNode.TYPE)) {
                        if (unwindMemoryMap == null) {
                            unwindMemoryMap = unwindNode.getMemoryMap();
                        } else assert (unwindMemoryMap == unwindNode.getMemoryMap()) : Assertions.errorMessage(unwindMemoryMap, unwindNode, unwindNode.getMemoryMap());
                        unwindNode.setMemoryMap(null);
                    }
                    if (unwindMemoryMap != null) {
                        unwindMemoryMap.safeDelete();
                    }
                }
                if (needsAnchor) {
                    snippetCopy.addAfterFixed(snippetCopy.start(), anchor);
                    this.memoryAnchor = anchor;
                } else {
                    anchor.safeDelete();
                    this.memoryAnchor = null;
                }
            }
            debug.dump(2, this.snippet, "SnippetTemplate after fixing memory anchoring");
            List<ReturnNode> returnNodes = this.snippet.getNodes(ReturnNode.TYPE).snapshot();
            if (returnNodes.isEmpty()) {
                this.returnNode = this.snippet.add(new ReturnNode(SnippetTemplate.getDefaultReturnValue(this.snippet, replacee)));
                FloatingReadPhase.MemoryMapImpl mmap = new FloatingReadPhase.MemoryMapImpl();
                memoryMap = this.snippet.unique(new MemoryMapNode(mmap.getMap()));
                this.returnNode.setMemoryMap((MemoryMapNode)memoryMap);
                this.artificialReturnCondition = this.snippet.unique(new PlaceholderLogicNode());
                StartNode insertAfter = this.snippet.start();
                FixedNode fixedNode = insertAfter.next();
                insertAfter.setNext(null);
                IfNode branch = this.snippet.add(new IfNode((LogicNode)this.artificialReturnCondition, fixedNode, this.returnNode, ProfileData.BranchProbabilityData.unknown()));
                insertAfter.setNext(branch);
            } else if (returnNodes.size() == 1) {
                this.artificialReturnCondition = null;
                this.returnNode = returnNodes.get(0);
            } else {
                this.artificialReturnCondition = null;
                AbstractMergeNode merge = this.snippet.add(new MergeNode());
                ArrayList<MemoryMapNode> memMaps = new ArrayList<MemoryMapNode>();
                for (ReturnNode returnNode : returnNodes) {
                    MemoryMapNode memoryMapNode = returnNode.getMemoryMap();
                    if (memoryMapNode == null) continue;
                    memMaps.add(memoryMapNode);
                }
                ValueNode returnValue = InliningUtil.mergeReturns(merge, returnNodes);
                this.returnNode = this.snippet.add(new ReturnNode(returnValue));
                if (!memMaps.isEmpty()) {
                    FloatingReadPhase.MemoryMapImpl memoryMapImpl = FloatingReadPhase.mergeMemoryMaps(merge, memMaps);
                    MemoryMapNode memoryMap3 = this.snippet.unique(new MemoryMapNode(memoryMapImpl.getMap()));
                    this.returnNode.setMemoryMap(memoryMap3);
                    for (MemoryMapNode mm : memMaps) {
                        if (mm == memoryMap3 || !mm.isAlive()) continue;
                        assert (mm.hasNoUsages());
                        GraphUtil.killWithUnusedFloatingInputs(mm);
                    }
                }
                merge.setNext(this.returnNode);
            }
            debug.dump(2, this.snippet, "After fixing returns");
            canonicalizer.apply(this.snippet, providers);
            boolean bl = needsMergeStateMap = !guardsStage.areFrameStatesAtDeopts();
            if (needsMergeStateMap) {
                this.frameStateAssignment = new SnippetFrameStateAssignment.SnippetFrameStateAssignmentClosure(snippetCopy);
                ReentrantNodeIterator.apply(this.frameStateAssignment, snippetCopy.start(), SnippetFrameStateAssignment.NodeStateAssignment.BEFORE_BCI);
                GraalError.guarantee(this.frameStateAssignment.verify(), "snippet frame state verification failed: %s", (Object)this.info);
            } else {
                this.frameStateAssignment = null;
            }
            assert (SnippetTemplate.verifyIntrinsicsProcessed(snippetCopy));
            curDeoptNodes.removeIf(x -> x.asNode().isDeleted());
            curSideEffectNodes.removeIf(x -> x.asNode().isDeleted());
            curSideEffectNodes.removeIf(ExceptionObjectNode.class::isInstance);
            this.sideEffectNodes = curSideEffectNodes;
            this.deoptNodes = curDeoptNodes;
            this.placeholderStampedNodes = curPlaceholderStampedNodes;
            this.nodes = new ArrayList(this.snippet.getNodeCount());
            for (Node node : this.snippet.getNodes()) {
                if (node == startNode || node == startNode.stateAfter()) continue;
                this.nodes.add(node);
            }
            if (!curSideEffectNodes.isEmpty()) {
                this.checkSideEffects(replacee);
            }
            debug.dump(2, this.snippet, "SnippetTemplate final state");
            assert (this.snippet.verify());
            this.snippet.freeze();
        }
        catch (Throwable ex) {
            throw debug.handle(ex);
        }
    }

    private static ValueNode getDefaultReturnValue(StructuredGraph snippet, Node replacee) {
        JavaKind javaKind;
        if (replacee instanceof ValueNode && (javaKind = ((ValueNode)replacee).stamp(NodeView.DEFAULT).getStackKind()) != JavaKind.Void) {
            return ConstantNode.defaultForKind(javaKind, snippet);
        }
        return null;
    }

    private static boolean verifyIntrinsicsProcessed(StructuredGraph snippetCopy) {
        if (ImageInfo.inImageRuntimeCode()) {
            return true;
        }
        for (MethodCallTargetNode target : snippetCopy.getNodes(MethodCallTargetNode.TYPE)) {
            ResolvedJavaMethod targetMethod = target.targetMethod();
            if (targetMethod != null) assert (targetMethod.getAnnotation(Fold.class) == null && targetMethod.getAnnotation(Node.NodeIntrinsic.class) == null) : "plugin should have been processed";
        }
        return true;
    }

    public static void explodeLoops(StructuredGraph snippetCopy, CoreProviders providers) {
        boolean exploded = false;
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        do {
            exploded = false;
            ExplodeLoopNode explodeLoop = snippetCopy.getNodes().filter(ExplodeLoopNode.class).first();
            if (explodeLoop == null) continue;
            LoopBeginNode loopBegin = explodeLoop.findLoopBegin();
            if (loopBegin != null) {
                Loop loop = providers.getLoopsDataProvider().getLoopsData(snippetCopy).loop(loopBegin);
                Graph.Mark mark = snippetCopy.getMark();
                try {
                    LoopTransformations.fullUnroll(loop, providers, canonicalizer);
                }
                catch (RetryableBailoutException e) {
                    throw new GraalError((Throwable)((Object)e), snippetCopy.toString(), new Object[0]);
                }
                canonicalizer.applyIncremental(snippetCopy, providers, mark);
                loop.deleteUnusedNodes();
            }
            GraphUtil.removeFixedWithUnusedInputs(explodeLoop);
            exploded = true;
        } while (exploded);
    }

    protected static Object[] getConstantArgs(Arguments args) {
        Object[] constantArgs = (Object[])args.values.clone();
        for (int i = 0; i < args.info.getParameterCount(); ++i) {
            if (!args.info.isConstantParameter(i)) {
                constantArgs[i] = null;
                continue;
            }
            assert (constantArgs[i] != null) : "Can't pass raw null through as argument";
        }
        return constantArgs;
    }

    private static BitSet getNonNullParameters(Arguments args) {
        BitSet nonNullParameters = new BitSet(args.info.getParameterCount());
        for (int i = 0; i < args.info.getParameterCount(); ++i) {
            if (!args.info.isNonNullParameter(i)) continue;
            nonNullParameters.set(i);
        }
        return nonNullParameters;
    }

    private static boolean checkAllVarargPlaceholdersAreDeleted(int parameterCount, VarargsPlaceholderNode[] placeholders) {
        for (int i = 0; i < parameterCount; ++i) {
            if (placeholders[i] != null) assert (placeholders[i].isDeleted()) : placeholders[i];
        }
        return true;
    }

    private static boolean checkConstantArgument(MetaAccessProvider metaAccess, ResolvedJavaMethod method, Signature signature, int paramIndex, String name, Object arg, JavaKind kind) {
        ResolvedJavaType type = signature.getParameterType(paramIndex, method.getDeclaringClass()).resolve(method.getDeclaringClass());
        if (metaAccess.lookupJavaType(WordBase.class).isAssignableFrom(type)) {
            assert (arg instanceof Constant || arg instanceof ConstantNode) : String.valueOf(method) + ": word constant parameters must be passed boxed in a Constant value: " + String.valueOf(arg);
            return true;
        }
        if (kind != JavaKind.Object) assert (arg != null && kind.toBoxedJavaClass() == arg.getClass()) : String.valueOf(method) + ": wrong value kind for " + name + ": expected " + String.valueOf(kind) + ", got " + (arg == null ? "null" : arg.getClass().getSimpleName());
        return true;
    }

    private static boolean checkVarargs(MetaAccessProvider metaAccess, ResolvedJavaMethod method, Signature signature, int i, String name, Varargs varargs) {
        ResolvedJavaType type = (ResolvedJavaType)signature.getParameterType(i, method.getDeclaringClass());
        assert (type.isArray()) : "varargs parameter must be an array type";
        assert (type.getComponentType().isAssignableFrom(metaAccess.lookupJavaType(varargs.componentType))) : "componentType for " + name + " not matching " + type.toJavaName() + " instance: " + String.valueOf(varargs.componentType);
        return true;
    }

    private static boolean checkNonNull(ResolvedJavaMethod method, String parameterName, Object arg) {
        if (arg instanceof ValueNode) {
            assert (StampTool.isPointerNonNull((ValueNode)arg)) : String.valueOf(method) + ": non-null Node for argument " + parameterName + " must have non-null stamp: " + String.valueOf(arg);
        } else if (arg instanceof Constant) {
            assert (JavaConstant.isNull((Constant)((Constant)arg))) : String.valueOf(method) + ": non-null Constant for argument " + parameterName + " must not represent null";
        } else assert (arg != null) : String.valueOf(method) + ": non-null object for argument " + parameterName + " must not be null";
        return true;
    }

    public StructuredGraph getSnippet() {
        return this.snippet;
    }

    private EconomicMap<Node, Node> bind(StructuredGraph replaceeGraph, MetaAccessProvider metaAccess, Arguments args) {
        EconomicMap replacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        assert (args.info.getParameterCount() == this.parameters.length) : "number of args (" + args.info.getParameterCount() + ") != number of parameters (" + this.parameters.length + ")";
        for (int i = 0; i < this.parameters.length; ++i) {
            Object parameter = this.parameters[i];
            assert (parameter != null) : String.valueOf(this) + " has no parameter named " + args.info.getParameterName(i);
            Object argument = args.values[i];
            if (parameter instanceof ParameterNode) {
                if (argument instanceof ValueNode) {
                    replacements.put((Object)((ParameterNode)parameter), (Object)((ValueNode)argument));
                    continue;
                }
                JavaKind kind = ((ParameterNode)parameter).getStackKind();
                assert (argument != null || kind == JavaKind.Object) : String.valueOf(this) + " cannot accept null for non-object parameter named " + args.info.getParameterName(i);
                JavaConstant constant = this.forBoxed(argument, kind);
                replacements.put((Object)((ParameterNode)parameter), (Object)ConstantNode.forConstant(constant, metaAccess, replaceeGraph));
                continue;
            }
            if (parameter instanceof ParameterNode[]) {
                ParameterNode[] params = (ParameterNode[])parameter;
                Varargs varargs = (Varargs)argument;
                int length = params.length;
                List list = null;
                Object array = null;
                if (varargs.value instanceof List) {
                    list = (List)varargs.value;
                    assert (list.size() == length) : length + " != " + list.size();
                } else {
                    array = varargs.value;
                    assert (array != null);
                    assert (array.getClass().isArray());
                    assert (Array.getLength(array) == length) : length + " != " + Array.getLength(array);
                }
                for (int j = 0; j < length; ++j) {
                    Object value;
                    ParameterNode param = params[j];
                    assert (param != null);
                    Object object = value = list != null ? list.get(j) : Array.get(array, j);
                    if (value instanceof ValueNode) {
                        replacements.put((Object)param, (Object)((ValueNode)value));
                        continue;
                    }
                    JavaConstant constant = this.forBoxed(value, param.getStackKind());
                    ConstantNode element = ConstantNode.forConstant(constant, metaAccess, replaceeGraph);
                    replacements.put((Object)param, (Object)element);
                }
                continue;
            }
            assert (parameter.equals(CONSTANT_PARAMETER) || parameter.equals(UNUSED_PARAMETER)) : "unexpected entry for parameter: " + args.info.getParameterName(i) + " -> " + String.valueOf(parameter);
        }
        return replacements;
    }

    protected JavaConstant forBoxed(Object argument, JavaKind localKind) {
        assert (localKind == localKind.getStackKind()) : Assertions.errorMessage(argument, localKind);
        if (localKind == JavaKind.Int) {
            return JavaConstant.forBoxedPrimitive((Object)argument);
        }
        return this.snippetReflection.forBoxed(localKind, argument);
    }

    private boolean assertSnippetKills(ValueNode replacee) {
        if (replacee.graph().isBeforeStage(GraphState.StageFlag.FLOATING_READS)) {
            return true;
        }
        if (this.returnNode == null) {
            return true;
        }
        MemoryMapNode memoryMap = this.returnNode.getMemoryMap();
        if (memoryMap == null || memoryMap.isEmpty()) {
            return true;
        }
        EconomicSet kills = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        kills.addAll(memoryMap.getLocations());
        if (MemoryKill.isMemoryKill(replacee)) {
            assert (!MemoryKill.isMultiMemoryKill(replacee)) : String.valueOf(replacee) + " multi not supported (yet)";
            LocationIdentity locationIdentity = MemoryKill.asSingleMemoryKill(replacee).getKilledLocationIdentity();
            if (locationIdentity.isAny()) {
                return true;
            }
            assert (kills.contains((Object)locationIdentity)) : String.valueOf(replacee) + " kills " + String.valueOf(locationIdentity) + ", but snippet doesn't contain a kill to this location";
            kills.remove((Object)locationIdentity);
        }
        if (memoryMap.getLastLocationAccess(LocationIdentity.any()) instanceof MemoryAnchorNode) {
            kills.remove((Object)LocationIdentity.any());
        }
        assert (replacee instanceof WithExceptionNode && this.snippetKillAnyIsExceptionHandler(replacee) || !kills.contains((Object)LocationIdentity.any())) : "snippet graph contains a kill to ANY_LOCATION, but replacee (" + String.valueOf(replacee) + ") doesn't kill ANY_LOCATION.  kills: " + String.valueOf(kills);
        for (LocationIdentity p : this.info.privateLocations) {
            kills.remove((Object)p);
        }
        assert (kills.isEmpty()) : "snippet graph kills non-private locations " + String.valueOf(kills) + " that replacee (" + String.valueOf(replacee) + ") doesn't kill";
        return true;
    }

    private boolean snippetKillAnyIsExceptionHandler(Node replacee) {
        if (replacee instanceof WithExceptionNode && this.snippet.getNodes(ExceptionObjectNode.LoweredExceptionObjectBegin.TYPE).count() == 1) {
            for (Node n : this.snippet.getNodes()) {
                if (n == this.snippet.start() || !MemoryKill.isMemoryKill(n) || !MemoryKill.isSingleMemoryKill(n) || !MemoryKill.asSingleMemoryKill(n).getKilledLocationIdentity().equals(LocationIdentity.ANY_LOCATION) || n instanceof MemoryAnchorNode) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void rewireMemoryGraph(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates) {
        SnippetTemplate.verifyWithExceptionNode(replacee);
        if (replacee.graph().isAfterStage(GraphState.StageFlag.FLOATING_READS)) {
            MemoryMapNode memoryMap;
            if (this.returnNode != null) {
                this.replaceMemoryUsages(replacee, new MemoryOutputMap(replacee, this.returnNode.getMemoryMap(), duplicates));
                ReturnNode ret = (ReturnNode)duplicates.get((Object)this.returnNode);
                if (ret != null && (memoryMap = ret.getMemoryMap()) != null) {
                    ret.setMemoryMap(null);
                    memoryMap.safeDelete();
                }
            }
            if (this.unwindPath != null) {
                this.replaceMemoryUsages(((WithExceptionNode)replacee).exceptionEdge(), new MemoryOutputMap(replacee, this.unwindPath.getMemoryMap(), duplicates));
                UnwindNode unwind = (UnwindNode)duplicates.get((Object)this.unwindPath);
                if (unwind != null && (memoryMap = unwind.getMemoryMap()) != null) {
                    unwind.setMemoryMap(null);
                    memoryMap.safeDelete();
                }
            }
            if (this.memoryAnchor != null) {
                MemoryAnchorNode memoryDuplicate = (MemoryAnchorNode)duplicates.get((Object)this.memoryAnchor);
                this.replaceMemoryUsages(memoryDuplicate, new MemoryInputMap(replacee));
                if (memoryDuplicate.hasNoUsages()) {
                    if (memoryDuplicate.next() != null) {
                        memoryDuplicate.graph().removeFixed(memoryDuplicate);
                    } else {
                        memoryDuplicate.safeDelete();
                    }
                }
            }
        }
    }

    private static void verifyWithExceptionNode(ValueNode node) {
        if (node instanceof WithExceptionNode && MemoryKill.isMemoryKill(node)) {
            WithExceptionNode withExceptionNode = (WithExceptionNode)node;
            AbstractBeginNode exceptionEdge = withExceptionNode.exceptionEdge();
            if (exceptionEdge instanceof UnreachableBeginNode) {
                return;
            }
            GraalError.guarantee(MemoryKill.isMemoryKill(exceptionEdge), "The exception edge of %s is not a memory kill %s", (Object)node, (Object)exceptionEdge);
            if (MemoryKill.isSingleMemoryKill(exceptionEdge)) {
                SingleMemoryKill exceptionEdgeKill = (SingleMemoryKill)((Object)exceptionEdge);
                if (exceptionEdgeKill.getKilledLocationIdentity().isAny()) {
                    return;
                }
                GraalError.guarantee(MemoryKill.isSingleMemoryKill(withExceptionNode), "Not a single memory kill: %s", (Object)withExceptionNode);
                SingleMemoryKill withExceptionKill = (SingleMemoryKill)((Object)withExceptionNode);
                GraalError.guarantee(withExceptionKill.getKilledLocationIdentity().equals(exceptionEdgeKill.getKilledLocationIdentity()), "Kill locations do not match: %s (%s) vs %s (%s)", (Object)withExceptionKill, (Object)withExceptionKill.getKilledLocationIdentity(), (Object)exceptionEdgeKill, (Object)exceptionEdgeKill.getKilledLocationIdentity());
            } else if (MemoryKill.isMultiMemoryKill(exceptionEdge)) {
                MultiMemoryKill exceptionEdgeKill = (MultiMemoryKill)((Object)exceptionEdge);
                GraalError.guarantee(MemoryKill.isMultiMemoryKill(exceptionEdge), "Not a single memory kill: %s", (Object)withExceptionNode);
                MultiMemoryKill withExceptionKill = (MultiMemoryKill)((Object)withExceptionNode);
                GraalError.guarantee(Arrays.equals(withExceptionKill.getKilledLocationIdentities(), exceptionEdgeKill.getKilledLocationIdentities()), "Kill locations do not match: %s (%s) vs %s (%s)", (Object)withExceptionKill, (Object)withExceptionKill.getKilledLocationIdentities(), (Object)exceptionEdgeKill, (Object)exceptionEdgeKill.getKilledLocationIdentities());
            } else {
                GraalError.shouldNotReachHere("Unexpected exception edge: " + String.valueOf(exceptionEdge));
            }
        }
    }

    private static LocationIdentity getLocationIdentity(Node node) {
        if (node instanceof MemoryAccess) {
            return ((MemoryAccess)((Object)node)).getLocationIdentity();
        }
        if (node instanceof MemoryEdgeProxy) {
            return ((MemoryEdgeProxy)((Object)node)).getLocationIdentity();
        }
        if (node instanceof MemoryPhiNode) {
            return ((MemoryPhiNode)node).getLocationIdentity();
        }
        return null;
    }

    private void replaceMemoryUsages(ValueNode node, MemoryMap map) {
        for (Node usage : node.usages().snapshot()) {
            LocationIdentity location;
            if (usage instanceof MemoryMapNode || (location = SnippetTemplate.getLocationIdentity(usage)) == null) continue;
            for (Position pos : usage.inputPositions()) {
                if (pos.getInputType() != InputType.Memory || pos.get(usage) != node) continue;
                MemoryKill replacement = map.getLastLocationAccess(location);
                if (replacement == null) {
                    assert (this.mayRemoveLocation || LocationIdentity.any().equals(location) || CollectionsUtil.anyMatch(this.info.privateLocations, Predicate.isEqual(location))) : "Snippet " + this.info.method.format("%h.%n") + " contains access to the non-private location " + String.valueOf(location) + ", but replacee doesn't access this location." + String.valueOf(map.getLocations());
                    continue;
                }
                pos.set(usage, replacement.asNode());
            }
        }
    }

    public Node getReturnValue(UnmodifiableEconomicMap<Node, Node> duplicates) {
        if (this.returnNode.result() != null) {
            return (Node)duplicates.get((Object)this.returnNode.result());
        }
        return null;
    }

    public UnmodifiableEconomicMap<Node, Node> instantiate(MetaAccessProvider metaAccess, FixedNode replacee, UsageReplacer replacer, Arguments args) {
        return this.instantiate(metaAccess, replacee, replacer, args, true);
    }

    /*
     * Exception decompiling
     */
    public UnmodifiableEconomicMap<Node, Node> instantiate(MetaAccessProvider metaAccess, FixedNode replacee, UsageReplacer replacer, Arguments args, boolean killReplacee) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static FixedNode walkBackToExceptionEdgeStart(FixedNode start) {
        StructuredGraph g = start.graph();
        StartNode graphStart = g.start();
        FixedNode cur = start;
        FixedNode prev = null;
        while (cur != null && cur != graphStart) {
            WithExceptionNode we;
            if (cur instanceof WithExceptionNode && prev == (we = (WithExceptionNode)cur).exceptionEdge()) {
                return we.exceptionEdge();
            }
            prev = cur;
            if (cur instanceof MergeNode) {
                MergeNode m = (MergeNode)cur;
                cur = m.forwardEndAt(0);
                continue;
            }
            cur = (FixedNode)cur.predecessor();
        }
        return null;
    }

    private void checkSideEffects(ValueNode replacee) {
        if (replacee.graph().getGuardsStage().areFrameStatesAtSideEffects()) {
            boolean replacementHasSideEffect;
            boolean replaceeHasSideEffect = replacee instanceof StateSplit && ((StateSplit)((Object)replacee)).hasSideEffect();
            boolean bl = replacementHasSideEffect = !this.sideEffectNodes.isEmpty();
            if (replacementHasSideEffect) {
                GraalError.guarantee(replaceeHasSideEffect, "Lowering node %s without side effect to snippet %s with side effects=%s", (Object)replacee, (Object)this.info, this.sideEffectNodes);
            }
        }
    }

    private static void markExceptionsUnreachable(ValueNode snippetExceptionValue, EconomicMap<Node, Node> duplicates) {
        assert (snippetExceptionValue.graph().isSubstitution()) : "search should be done in the snippet graph";
        if (snippetExceptionValue instanceof ValuePhiNode) {
            for (ValueNode phiInput : ((PhiNode)snippetExceptionValue).values().snapshot()) {
                SnippetTemplate.markExceptionsUnreachable(phiInput, duplicates);
            }
        } else {
            Node snippetUnwindPred = snippetExceptionValue.predecessor();
            while (snippetUnwindPred instanceof AbstractBeginNode || snippetUnwindPred instanceof MemoryAnchorNode) {
                snippetUnwindPred = snippetUnwindPred.predecessor();
            }
            GraalError.guarantee(snippetUnwindPred instanceof WithExceptionNode, "Unexpected exception producer: %s", (Object)snippetUnwindPred);
            WithExceptionNode snippetWithException = (WithExceptionNode)duplicates.get((Object)snippetUnwindPred);
            snippetWithException.replaceWithNonThrowing();
        }
    }

    public static void replaceExceptionObjectNode(AbstractBeginNode originalExceptionEdge, FixedWithNextNode replacementUnwindPath) {
        replacementUnwindPath.setNext(originalExceptionEdge);
    }

    private EconomicMap<Node, Node> inlineSnippet(Node replacee, DebugContext debug, StructuredGraph replaceeGraph, EconomicMap<Node, Node> replacements) {
        Graph.Mark mark = replaceeGraph.getMark();
        InliningLog log = replaceeGraph.getInliningLog();
        try (InliningLog.UpdateScope scope = log == null ? null : log.openUpdateScope((oldNode, newNode) -> {
            if (oldNode == null) {
                log.trackNewCallsite((Invokable)newNode);
            }
        });){
            EconomicMap<Node, Node> duplicates = replaceeGraph.addDuplicates((Iterable<? extends Node>)this.nodes, (Graph)this.snippet, this.snippet.getNodeCount(), (UnmodifiableEconomicMap<Node, Node>)replacements);
            if (scope != null) {
                log.addLog((UnmodifiableEconomicMap<Node, Node>)duplicates, this.snippet.getInliningLog());
            }
            if (replaceeGraph.trackNodeSourcePosition()) {
                NodeSourcePosition position = replacee.getNodeSourcePosition();
                InliningUtil.updateSourcePosition(replaceeGraph, duplicates, mark, position, true);
            }
            debug.dump(4, (Object)replaceeGraph, "After inlining snippet %s", this.snippet.method());
            EconomicMap<Node, Node> economicMap = duplicates;
            return economicMap;
        }
    }

    private void propagateStamp(Node node) {
        PhiNode phi;
        if (node instanceof PhiNode && (phi = (PhiNode)node).inferStamp()) {
            for (Node usage : node.usages()) {
                this.propagateStamp(usage);
            }
        }
    }

    private void updateStamps(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates) {
        for (ValueNode node : this.placeholderStampedNodes) {
            ValueNode dup = (ValueNode)duplicates.get((Object)node);
            Stamp replaceeStamp = replacee.stamp(NodeView.DEFAULT);
            if (node instanceof PiNode.Placeholder) {
                PiNode.Placeholder placeholderDup = (PiNode.Placeholder)dup;
                placeholderDup.makeReplacement(replaceeStamp);
                continue;
            }
            dup.setStamp(replaceeStamp);
        }
        for (ParameterNode paramNode : this.snippet.getNodes(ParameterNode.TYPE)) {
            for (Node usage : paramNode.usages()) {
                Node usageDup = (Node)duplicates.get((Object)usage);
                this.propagateStamp(usageDup);
            }
        }
    }

    public StructuredGraph copySpecializedGraph(DebugContext debugForCopy) {
        return (StructuredGraph)this.snippet.copy(debugForCopy);
    }

    /*
     * Exception decompiling
     */
    public ValueNode instantiate(MetaAccessProvider metaAccess, FloatingNode replacee, UsageReplacer replacer, LoweringTool tool, Arguments args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void instantiate(MetaAccessProvider metaAccess, FloatingNode replacee, UsageReplacer replacer, Arguments args) {
        DebugContext debug = replacee.getDebug();
        try (DebugCloseable a = args.info.instantiationTimer.start(debug);
             DebugCloseable b = totalInstantiationTimer.start(debug);
             DebugContext.Scope s = debug.withContext(this.snippet);){
            assert (this.assertSnippetKills(replacee));
            args.info.instantiationCounter.increment(debug);
            totalInstantiationCounter.increment(debug);
            StartNode entryPointNode = this.snippet.start();
            assert (entryPointNode.next() == (this.memoryAnchor == null ? this.returnNode : this.memoryAnchor)) : entryPointNode.next();
            StructuredGraph replaceeGraph = replacee.graph();
            EconomicMap<Node, Node> replacements = this.bind(replaceeGraph, metaAccess, args);
            MemoryAnchorNode anchorDuplicate = null;
            if (this.memoryAnchor != null) {
                anchorDuplicate = replaceeGraph.add(new MemoryAnchorNode(this.info.privateLocations));
                replacements.put((Object)this.memoryAnchor, (Object)anchorDuplicate);
            }
            EconomicMap<Node, Node> duplicates = this.inlineSnippet(replacee, debug, replaceeGraph, replacements);
            assert (!(replacee instanceof StateSplit)) : Assertions.errorMessageContext("replacee", replacee);
            this.updateStamps(replacee, (UnmodifiableEconomicMap<Node, Node>)duplicates);
            this.rewireMemoryGraph(replacee, (UnmodifiableEconomicMap<Node, Node>)duplicates);
            assert (anchorDuplicate == null || anchorDuplicate.isDeleted());
            ValueNode returnValue = (ValueNode)duplicates.get((Object)this.returnNode.result());
            replacer.replace(replacee, returnValue);
            Node returnNodeDuplicate = (Node)duplicates.get((Object)this.returnNode);
            if (returnNodeDuplicate.isAlive()) {
                returnNodeDuplicate.safeDelete();
            }
            debug.dump(4, replaceeGraph, "After lowering %s with %s", replacee, this);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    protected void rewireFrameStates(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates, FixedNode replaceeGraphCFGPredecessor) {
        if (replacee.graph().getGuardsStage().areFrameStatesAtSideEffects() && this.requiresFrameStateProcessingBeforeFSA(replacee)) {
            this.rewireFrameStatesBeforeFSA(replacee, duplicates, replaceeGraphCFGPredecessor);
        } else if (replacee.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            if (replacee instanceof DeoptimizingNode && ((DeoptimizingNode)((Object)replacee)).canDeoptimize()) {
                this.rewireFrameStatesAfterFSA(replacee, duplicates);
            } else {
                for (DeoptimizingNode deoptNode : this.deoptNodes) {
                    DeoptimizingNode deoptDup = (DeoptimizingNode)duplicates.get((Object)deoptNode.asNode());
                    GraalError.guarantee(!deoptDup.canDeoptimize(), "No FrameState is being transferred to DeoptimizingNode %s. ", (Object)deoptDup);
                }
            }
        }
    }

    private boolean requiresFrameStateProcessingBeforeFSA(ValueNode replacee) {
        return replacee instanceof StateSplit || this.frameStateAssignment != null;
    }

    private void rewireFrameStatesBeforeFSA(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates, FixedNode replaceeGraphCFGPredecessor) {
        if (this.frameStateAssignment != null) {
            this.assignNecessaryFrameStates(replacee, duplicates, replaceeGraphCFGPredecessor);
        }
    }

    private void assignNecessaryFrameStates(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates, FixedNode replaceeGraphCFGPredecessor) {
        ExceptionObjectNode exceptionObject;
        FrameState stateAfter = null;
        if (replacee instanceof StateSplit && ((StateSplit)((Object)replacee)).hasSideEffect()) {
            stateAfter = ((StateSplit)((Object)replacee)).stateAfter();
            GraalError.guarantee(stateAfter != null, "Statesplit with side-effect %s needs a framestate", (Object)replacee);
        } else {
            stateAfter = GraphUtil.findLastFrameState(replaceeGraphCFGPredecessor);
        }
        if (replacee instanceof WithExceptionNode) {
            WithExceptionNode withExceptionNode = (WithExceptionNode)replacee;
            if (withExceptionNode.exceptionEdge() instanceof ExceptionObjectNode) {
                exceptionObject = (ExceptionObjectNode)withExceptionNode.exceptionEdge();
            } else {
                GraalError.guarantee(withExceptionNode.exceptionEdge() instanceof UnreachableBeginNode, "Unexpected exception edge %s", (Object)withExceptionNode.exceptionEdge());
                exceptionObject = null;
            }
        } else {
            exceptionObject = null;
        }
        NodeMap<SnippetFrameStateAssignment.NodeStateAssignment> assignedStateMappings = this.frameStateAssignment.getStateMapping();
        FrameState stateAfterInvalidForDeoptimization = stateAfter.isValidForDeoptimization() ? null : stateAfter;
        MapCursor<Node, SnippetFrameStateAssignment.NodeStateAssignment> stateAssignments = assignedStateMappings.getEntries();
        while (stateAssignments.advance()) {
            Node nodeRequiringState = (Node)stateAssignments.getKey();
            if (nodeRequiringState instanceof DeoptBciSupplier && replacee instanceof DeoptBciSupplier) {
                ((DeoptBciSupplier)duplicates.get((Object)nodeRequiringState)).setBci(((DeoptBciSupplier)((Object)replacee)).bci());
            }
            SnippetFrameStateAssignment.NodeStateAssignment assignment = (SnippetFrameStateAssignment.NodeStateAssignment)((Object)stateAssignments.getValue());
            switch (assignment) {
                case AFTER_BCI: {
                    this.setReplaceeGraphStateAfter(nodeRequiringState, replacee, duplicates, stateAfter);
                    break;
                }
                case AFTER_BCI_INVALID_FOR_DEOPTIMIZATION: {
                    if (stateAfterInvalidForDeoptimization == null) {
                        stateAfterInvalidForDeoptimization = stateAfter.duplicate();
                        stateAfterInvalidForDeoptimization.invalidateForDeoptimization();
                    }
                    this.setReplaceeGraphStateAfter(nodeRequiringState, replacee, duplicates, stateAfterInvalidForDeoptimization);
                    break;
                }
                case AFTER_EXCEPTION_BCI: {
                    if (nodeRequiringState instanceof ExceptionObjectNode) {
                        ExceptionObjectNode newExceptionObject = (ExceptionObjectNode)duplicates.get((Object)nodeRequiringState);
                        SnippetTemplate.rewireExceptionFrameState(exceptionObject, newExceptionObject, newExceptionObject);
                        break;
                    }
                    if (nodeRequiringState instanceof MergeNode) {
                        MergeNode mergeNode = (MergeNode)duplicates.get((Object)nodeRequiringState);
                        SnippetTemplate.rewireExceptionFrameState(exceptionObject, SnippetTemplate.getExceptionValueFromMerge(mergeNode), mergeNode);
                        break;
                    }
                    GraalError.shouldNotReachHere("Unexpected exception state node: " + String.valueOf(nodeRequiringState));
                    break;
                }
                case BEFORE_BCI: {
                    FrameState stateBeforeSnippet = GraphUtil.findLastFrameState(replaceeGraphCFGPredecessor);
                    ((StateSplit)duplicates.get((Object)nodeRequiringState)).setStateAfter(stateBeforeSnippet.duplicate());
                    break;
                }
                case INVALID: {
                    throw GraalError.shouldNotReachHere("Invalid snippet replacing a node before frame state assignment with node " + String.valueOf(nodeRequiringState) + " for replacee " + String.valueOf(replacee));
                }
                default: {
                    throw GraalError.shouldNotReachHere("Unknown StateAssigment:" + String.valueOf((Object)assignment));
                }
            }
            replacee.graph().getDebug().dump(5, (Object)replacee.graph(), "After duplicating after state for node %s in snippet", duplicates.get((Object)nodeRequiringState));
        }
    }

    private static void captureLoopExitStates(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates) {
        StructuredGraph replaceeGraph = replacee.graph();
        if (replaceeGraph.getGuardsStage().areFrameStatesAtDeopts() && !replaceeGraph.getGuardsStage().allowsFloatingGuards()) {
            return;
        }
        for (Node duplicate : duplicates.getValues()) {
            LoopExitNode loopExit;
            if (!(duplicate instanceof LoopExitNode) || (loopExit = (LoopExitNode)duplicate).stateAfter() == null || loopExit.next() instanceof StateSplit && ((StateSplit)((Object)loopExit.next())).stateAfter() != null) continue;
            CaptureStateBeginNode captureState = replaceeGraph.add(new CaptureStateBeginNode());
            captureState.setStateAfter(loopExit.stateAfter());
            replaceeGraph.addAfterFixed(loopExit, captureState);
            replaceeGraph.getDebug().dump(5, replaceeGraph, "After capturing state %s at %s after %s", loopExit.stateAfter(), captureState, loopExit);
        }
    }

    private static ValuePhiNode getExceptionValueFromMerge(MergeNode mergeNode) {
        Iterator phis = mergeNode.valuePhis().iterator();
        GraalError.guarantee(phis.hasNext(), "No phi at merge %s", (Object)mergeNode);
        ValuePhiNode phi = (ValuePhiNode)phis.next();
        GraalError.guarantee(!phis.hasNext(), "More than one phi at merge %s", (Object)mergeNode);
        return phi;
    }

    private void setReplaceeGraphStateAfter(Node nodeRequiringState, Node replacee, UnmodifiableEconomicMap<Node, Node> duplicates, FrameState stateAfter) {
        FrameState newState = stateAfter.duplicate();
        if (stateAfter.values().contains(replacee)) {
            ValueNode valueInReplacement = (ValueNode)duplicates.get((Object)this.returnNode.result());
            if (!(nodeRequiringState instanceof AbstractMergeNode) && !(nodeRequiringState instanceof LoopExitNode) && valueInReplacement instanceof ValuePhiNode) {
                ValuePhiNode valuePhi = (ValuePhiNode)valueInReplacement;
                FixedNode next = (FixedNode)nodeRequiringState;
                while (next instanceof FixedWithNextNode) {
                    next = ((FixedWithNextNode)next).next();
                }
                if (next instanceof EndNode) {
                    EndNode duplicateEnd = (EndNode)duplicates.get((Object)next);
                    int endIndex = valuePhi.merge().forwardEndIndex(duplicateEnd);
                    if (endIndex != -1) {
                        valueInReplacement = valuePhi.valueAt(endIndex);
                    }
                }
            }
            SnippetTemplate.propagateValInState(newState, replacee, valueInReplacement);
        }
        ((StateSplit)duplicates.get((Object)nodeRequiringState)).setStateAfter(newState);
    }

    private static void propagateValInState(FrameState newState, final Node replacee, final Node replacement) {
        newState.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

            @Override
            public void apply(Node from, Position p) {
                if (p.get(from) == replacee) {
                    p.set(from, replacement);
                }
            }
        });
    }

    private static void rewireExceptionFrameState(final ExceptionObjectNode exceptionObject, final ValueNode newExceptionObject, StateSplit newStateSplit) {
        if (exceptionObject == null) {
            return;
        }
        FrameState exceptionState = exceptionObject.stateAfter();
        assert (exceptionState.values().contains(exceptionObject));
        assert (exceptionState.rethrowException());
        assert (exceptionState.stackSize() == 1) : Assertions.errorMessage(exceptionObject, newExceptionObject, newStateSplit, exceptionState);
        FrameState newExceptionState = exceptionState.duplicate();
        newExceptionState.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

            @Override
            public void apply(Node from, Position p) {
                if (p.get(from) == exceptionObject) {
                    p.set(from, newExceptionObject);
                }
            }
        });
        newStateSplit.setStateAfter(newExceptionState);
    }

    private void rewireFrameStatesAfterFSA(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates) {
        ExceptionObjectNode exceptionObject;
        DeoptimizingNode replaceeDeopt = (DeoptimizingNode)((Object)replacee);
        GraalError.guarantee(replaceeDeopt.canDeoptimize(), "Method expects the replacee to have deopt state");
        FrameState stateBefore = null;
        FrameState stateDuring = null;
        FrameState stateAfter = null;
        if (replaceeDeopt instanceof DeoptimizingNode.DeoptBefore) {
            stateBefore = ((DeoptimizingNode.DeoptBefore)replaceeDeopt).stateBefore();
        }
        if (replaceeDeopt instanceof DeoptimizingNode.DeoptDuring) {
            stateDuring = ((DeoptimizingNode.DeoptDuring)replaceeDeopt).stateDuring();
        }
        if (replaceeDeopt instanceof DeoptimizingNode.DeoptAfter) {
            stateAfter = ((DeoptimizingNode.DeoptAfter)replaceeDeopt).stateAfter();
        }
        if (stateAfter == null && stateDuring == null && stateBefore == null) {
            StructuredGraph graph = replacee.graph();
            boolean condition = graph.getGraphState().isFrameStateVerificationDisabled() || graph.isSubstitution();
            GraalError.guarantee(condition, "No state available to transfer");
            return;
        }
        if (replacee instanceof WithExceptionNode) {
            WithExceptionNode withExceptionNode = (WithExceptionNode)replacee;
            if (withExceptionNode.exceptionEdge() instanceof ExceptionObjectNode) {
                exceptionObject = (ExceptionObjectNode)withExceptionNode.exceptionEdge();
            } else {
                GraalError.guarantee(withExceptionNode.exceptionEdge() instanceof UnreachableBeginNode, "Unexpected exception edge %s", (Object)withExceptionNode.exceptionEdge());
                exceptionObject = null;
            }
        } else {
            exceptionObject = null;
        }
        for (DeoptimizingNode deoptNode : this.deoptNodes) {
            boolean guarantee;
            DeoptimizingNode deoptDup = (DeoptimizingNode)duplicates.get((Object)deoptNode.asNode());
            if (!deoptDup.canDeoptimize()) continue;
            if (deoptDup instanceof ExceptionObjectNode) {
                ExceptionObjectNode newExceptionObject = (ExceptionObjectNode)deoptDup;
                SnippetTemplate.rewireExceptionFrameState(exceptionObject, newExceptionObject, newExceptionObject);
                continue;
            }
            if (deoptDup instanceof DeoptimizingNode.DeoptBefore) {
                GraalError.guarantee(stateBefore != null, "Invalid stateBefore being transferred.");
                ((DeoptimizingNode.DeoptBefore)deoptDup).setStateBefore(stateBefore);
            }
            if (deoptDup instanceof DeoptimizingNode.DeoptDuring) {
                DeoptimizingNode.DeoptDuring deoptDupDuring = (DeoptimizingNode.DeoptDuring)deoptDup;
                if (stateDuring != null) {
                    deoptDupDuring.setStateDuring(stateDuring);
                } else if (stateAfter != null) {
                    deoptDupDuring.computeStateDuring(stateAfter);
                } else if (stateBefore != null) {
                    guarantee = ((DeoptimizingNode.DeoptBefore)replaceeDeopt).canUseAsStateDuring() || !deoptDupDuring.hasSideEffect();
                    GraalError.guarantee(guarantee, "Can't use stateBefore as stateDuring for state split %s", (Object)deoptDupDuring);
                    deoptDupDuring.setStateDuring(stateBefore);
                } else {
                    throw GraalError.shouldNotReachHere("No stateDuring assigned.");
                }
            }
            if (!(deoptDup instanceof DeoptimizingNode.DeoptAfter)) continue;
            DeoptimizingNode.DeoptAfter deoptDupAfter = (DeoptimizingNode.DeoptAfter)deoptDup;
            if (stateAfter != null) {
                deoptDupAfter.setStateAfter(stateAfter);
                continue;
            }
            guarantee = stateBefore != null && !deoptDupAfter.hasSideEffect();
            GraalError.guarantee(guarantee, "Can't use stateBefore as stateAfter for state split %s", (Object)deoptDupAfter);
            deoptDupAfter.setStateAfter(stateBefore);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.snippet.toString()).append('(');
        String sep = "";
        for (int i = 0; i < this.parameters.length; ++i) {
            String name = "[" + i + "]";
            Object value = this.parameters[i];
            buf.append(sep);
            sep = ", ";
            if (value == null) {
                buf.append("<null> ").append(name);
                continue;
            }
            if (value.equals(UNUSED_PARAMETER)) {
                buf.append("<unused> ").append(name);
                continue;
            }
            if (value.equals(CONSTANT_PARAMETER)) {
                buf.append("<constant> ").append(name);
                continue;
            }
            if (value instanceof ParameterNode) {
                ParameterNode param = (ParameterNode)value;
                buf.append(param.getStackKind().getJavaName()).append(' ').append(name);
                continue;
            }
            ParameterNode[] params = (ParameterNode[])value;
            String kind = params.length == 0 ? "?" : params[0].getStackKind().getJavaName();
            buf.append(kind).append('[').append(params.length).append("] ").append(name);
        }
        return buf.append(')').toString();
    }

    private static boolean checkTemplate(MetaAccessProvider metaAccess, Arguments args, ResolvedJavaMethod method) {
        int offset;
        Signature signature = method.getSignature();
        for (int i = offset = args.info.hasReceiver() ? 1 : 0; i < args.info.getParameterCount(); ++i) {
            if (args.info.isConstantParameter(i)) {
                JavaKind kind = signature.getParameterKind(i - offset);
                assert (ImageInfo.inImageRuntimeCode() || SnippetTemplate.checkConstantArgument(metaAccess, method, signature, i - offset, args.info.getParameterName(i), args.values[i], kind));
                continue;
            }
            if (args.info.isVarargsParameter(i)) {
                assert (args.values[i] instanceof Varargs) : Assertions.errorMessage(args.values[i], args, method);
                Varargs varargs = (Varargs)args.values[i];
                assert (ImageInfo.inImageRuntimeCode() || SnippetTemplate.checkVarargs(metaAccess, method, signature, i - offset, args.info.getParameterName(i), varargs));
                continue;
            }
            if (args.info.isNonNullParameter(i)) assert (SnippetTemplate.checkNonNull(method, args.info.getParameterName(i), args.values[i]));
        }
        return true;
    }

    public void setMayRemoveLocation(boolean mayRemoveLocation) {
        this.mayRemoveLocation = mayRemoveLocation;
    }

    private static /* synthetic */ boolean lambda$instantiate$0(AbstractBeginNode exceptionEdge, Node x) {
        return x instanceof GuardedNode && ((GuardedNode)((Object)x)).getGuard() == exceptionEdge;
    }

    public static final class Arguments
    implements Formattable {
        protected final SnippetInfo info;
        protected final CacheKey cacheKey;
        protected final Object[] values;
        protected final Stamp[] constStamps;
        protected boolean cacheable;
        protected int nextParamIdx;

        public Arguments(SnippetInfo info, GraphState.GuardsStage guardsStage, LoweringTool.LoweringStage loweringStage) {
            this.info = info;
            this.cacheKey = new CacheKey(info, guardsStage, loweringStage);
            this.values = new Object[info.getParameterCount()];
            this.constStamps = new Stamp[info.getParameterCount()];
            this.cacheable = true;
            if (info.hasReceiver()) {
                this.add("this", info.getReceiver());
            }
        }

        public Arguments add(String name, Object value) {
            assert (this.check(name, false));
            if (this.info.isConstantParameter(this.nextParamIdx)) {
                assert (value != null);
                this.cacheKey.setParam(this.nextParamIdx, value);
                if (value instanceof CStringConstant) {
                    this.constStamps[this.nextParamIdx] = StampFactory.pointer();
                }
            }
            this.values[this.nextParamIdx] = value;
            ++this.nextParamIdx;
            return this;
        }

        public Arguments addVarargs(String name, Class<?> componentType, Stamp argStamp, Object value) {
            assert (this.check(name, true));
            Varargs varargs = new Varargs(componentType, argStamp, value);
            this.values[this.nextParamIdx] = varargs;
            this.cacheKey.setParam(this.nextParamIdx, varargs.length);
            ++this.nextParamIdx;
            return this;
        }

        public void setCacheable(boolean cacheable) {
            this.cacheable = cacheable;
        }

        private boolean check(String name, boolean varargsParam) {
            assert (this.nextParamIdx < this.info.getParameterCount()) : "too many parameters: " + name + "  " + String.valueOf(this);
            assert (this.info.getParameterName(this.nextParamIdx) == null || this.info.getParameterName(this.nextParamIdx).equals(name)) : "wrong parameter name at " + this.nextParamIdx + " : " + name + "  " + String.valueOf(this);
            assert (varargsParam == this.info.isVarargsParameter(this.nextParamIdx)) : "Parameter " + (varargsParam ? "not " : "") + "annotated with @" + Snippet.VarargsParameter.class.getSimpleName() + ": " + name + "  " + String.valueOf(this);
            return true;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Parameters<").append(this.info.method.format("%h.%n")).append(" [");
            String sep = "";
            for (int i = 0; i < this.info.getParameterCount(); ++i) {
                result.append(sep);
                if (this.info.isConstantParameter(i)) {
                    result.append("const ");
                } else if (this.info.isVarargsParameter(i)) {
                    result.append("varargs ");
                }
                result.append(this.info.getParameterName(i)).append(" = ").append(this.values[i]);
                sep = ", ";
            }
            result.append(">");
            return result.toString();
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            if ((flags & 4) == 0) {
                formatter.format(DebugContext.applyFormattingFlagsAndWidth(this.toString(), flags, width), new Object[0]);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(this.info.method.getName()).append('(');
                String sep = "";
                for (int i = 0; i < this.info.getParameterCount(); ++i) {
                    if (!this.info.isConstantParameter(i)) continue;
                    sb.append(sep);
                    if (this.info.getParameterName(i) != null) {
                        sb.append(this.info.getParameterName(i));
                    } else {
                        sb.append(i);
                    }
                    sb.append('=').append(this.values[i]);
                    sep = ", ";
                }
                sb.append(")");
                String string = sb.toString();
                if (string.indexOf(37) != -1) {
                    string = string.replace("%", "%%");
                }
                formatter.format(DebugContext.applyFormattingFlagsAndWidth(string, flags & 0xFFFFFFFB, width), new Object[0]);
            }
        }
    }

    public static abstract class SnippetInfo {
        protected final ResolvedJavaMethod method;
        protected final ResolvedJavaMethod original;
        protected final LocationIdentity[] privateLocations;
        protected final Object receiver;
        private final TimerKey instantiationTimer;
        private final CounterKey instantiationCounter;
        private final CounterKey creationCounter;
        private final TimerKey creationTimer;
        protected final Snippet.SnippetType type;

        public Object getReceiver() {
            return this.receiver;
        }

        boolean hasReceiver() {
            assert (SnippetInfo.hasReceiver(this.method) == (this.receiver != null)) : "Snippet with the receiver must have it set as constant. Snippet: " + String.valueOf(this);
            return SnippetInfo.hasReceiver(this.method);
        }

        static boolean hasReceiver(ResolvedJavaMethod method) {
            return method.hasReceiver();
        }

        protected abstract SnippetParameterInfo info();

        protected SnippetInfo(ResolvedJavaMethod method, ResolvedJavaMethod original, LocationIdentity[] privateLocations, Object receiver, Snippet.SnippetType type) {
            this.method = method;
            this.original = original;
            this.privateLocations = privateLocations;
            this.instantiationCounter = DebugContext.counter("SnippetInstantiationCount[%s]", method.getName());
            this.instantiationTimer = DebugContext.timer("SnippetInstantiationTime[%s]", method.getName());
            this.creationCounter = DebugContext.counter("SnippetCreationCount[%s]", method.getName());
            this.creationTimer = DebugContext.timer("SnippetCreationTime[%s]", method.getName());
            this.receiver = receiver;
            this.type = type;
        }

        public boolean isPrivateLocation(LocationIdentity identity) {
            for (LocationIdentity i : this.privateLocations) {
                if (!i.equals(identity)) continue;
                return true;
            }
            return false;
        }

        public ResolvedJavaMethod getMethod() {
            return this.method;
        }

        public int getParameterCount() {
            return this.info().getParameterCount();
        }

        public boolean isConstantParameter(int paramIdx) {
            return this.info().isConstantParameter(paramIdx);
        }

        public boolean isVarargsParameter(int paramIdx) {
            return this.info().isVarargsParameter(paramIdx);
        }

        public boolean isNonNullParameter(int paramIdx) {
            return this.info().isNonNullParameter(paramIdx);
        }

        public String getParameterName(int paramIdx) {
            return this.info().getParameterName(paramIdx);
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.method.format("%h.%n");
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    static final class VarargsPlaceholderNode
    extends FloatingNode
    implements ArrayLengthProvider {
        public static final NodeClass<VarargsPlaceholderNode> TYPE = NodeClass.create(VarargsPlaceholderNode.class);
        protected final Varargs varargs;

        protected VarargsPlaceholderNode(Varargs varargs, MetaAccessProvider metaAccess) {
            super((NodeClass<? extends FloatingNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(metaAccess.lookupJavaType(varargs.componentType).getArrayClass())));
            this.varargs = varargs;
        }

        @Override
        public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
            return ConstantNode.forInt(this.varargs.length);
        }
    }

    static class Varargs {
        protected final Class<?> componentType;
        protected final Stamp stamp;
        protected final Object value;
        protected final int length;

        protected Varargs(Class<?> componentType, Stamp stamp, Object value) {
            this.componentType = componentType;
            this.stamp = stamp;
            this.value = value;
            this.length = value instanceof List ? ((List)value).size() : Array.getLength(value);
        }

        public String toString() {
            if (this.value instanceof boolean[]) {
                return Arrays.toString((boolean[])this.value);
            }
            if (this.value instanceof byte[]) {
                return Arrays.toString((byte[])this.value);
            }
            if (this.value instanceof char[]) {
                return Arrays.toString((char[])this.value);
            }
            if (this.value instanceof short[]) {
                return Arrays.toString((short[])this.value);
            }
            if (this.value instanceof int[]) {
                return Arrays.toString((int[])this.value);
            }
            if (this.value instanceof long[]) {
                return Arrays.toString((long[])this.value);
            }
            if (this.value instanceof float[]) {
                return Arrays.toString((float[])this.value);
            }
            if (this.value instanceof double[]) {
                return Arrays.toString((double[])this.value);
            }
            if (this.value instanceof Object[]) {
                return Arrays.toString((Object[])this.value);
            }
            return String.valueOf(this.value);
        }
    }

    static class CacheKey {
        private final ResolvedJavaMethod method;
        private final Object[] values;
        private final GraphState.GuardsStage guardsStage;
        private final LoweringTool.LoweringStage loweringStage;
        private int hash;
        private final Snippet.SnippetType type;

        protected CacheKey(SnippetInfo info, GraphState.GuardsStage guardsStage, LoweringTool.LoweringStage loweringStage) {
            this.method = info.method;
            this.guardsStage = guardsStage;
            this.loweringStage = loweringStage;
            this.values = new Object[info.getParameterCount()];
            this.hash = info.method.hashCode() + 31 * guardsStage.ordinal();
            this.type = info.type;
        }

        protected void setParam(int paramIdx, Object value) {
            this.values[paramIdx] = value;
            this.hash = this.hash * 31 ^ (value == null ? 0 : value.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (!this.method.equals((Object)other.method)) {
                return false;
            }
            if (this.guardsStage != other.guardsStage || this.loweringStage != other.loweringStage) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null || this.values[i].equals(other.values[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class MemoryOutputMap
    extends MemoryInputMap {
        private final UnmodifiableEconomicMap<Node, Node> duplicates;
        private MemoryMapNode memoryMap;

        MemoryOutputMap(ValueNode replacee, MemoryMapNode memoryMap, UnmodifiableEconomicMap<Node, Node> duplicates) {
            super(replacee);
            this.duplicates = duplicates;
            this.memoryMap = memoryMap;
        }

        @Override
        public MemoryKill getLastLocationAccess(LocationIdentity locationIdentity) {
            MemoryKill lastLocationAccess = this.memoryMap.getLastLocationAccess(locationIdentity);
            assert (lastLocationAccess != null) : locationIdentity;
            if (lastLocationAccess == SnippetTemplate.this.memoryAnchor) {
                return super.getLastLocationAccess(locationIdentity);
            }
            return (MemoryKill)this.duplicates.get((Object)ValueNodeInterface.asNode(lastLocationAccess));
        }

        @Override
        public Collection<LocationIdentity> getLocations() {
            return this.memoryMap.getLocations();
        }
    }

    private static class MemoryInputMap
    implements MemoryMap {
        private final LocationIdentity locationIdentity;
        private final MemoryKill lastLocationAccess;

        MemoryInputMap(ValueNode replacee) {
            if (replacee instanceof MemoryAccess) {
                MemoryAccess access = (MemoryAccess)((Object)replacee);
                this.locationIdentity = access.getLocationIdentity();
                this.lastLocationAccess = access.getLastLocationAccess();
            } else {
                this.locationIdentity = null;
                this.lastLocationAccess = null;
            }
        }

        @Override
        public MemoryKill getLastLocationAccess(LocationIdentity location) {
            if (this.locationIdentity != null && this.locationIdentity.equals(location)) {
                return this.lastLocationAccess;
            }
            return null;
        }

        public Collection<LocationIdentity> getLocations() {
            if (this.locationIdentity == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.locationIdentity);
        }
    }

    public static interface UsageReplacer {
        public void replace(ValueNode var1, ValueNode var2);
    }

    public static final class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int maxCacheSize;

        public LRUCache(int initialCapacity, int maxCacheSize) {
            super(initialCapacity, 0.75f, true);
            this.maxCacheSize = maxCacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxCacheSize;
        }
    }

    public static abstract class AbstractTemplates
    implements SnippetTemplateCache {
        protected final OptionValues options;
        protected final SnippetReflectionProvider snippetReflection;
        private final Map<CacheKey, SnippetTemplate> templates;
        private final boolean shouldTrackNodeSourcePosition;

        protected AbstractTemplates(OptionValues options, Providers providers) {
            this.options = options;
            this.snippetReflection = providers.getSnippetReflection();
            boolean bl = this.shouldTrackNodeSourcePosition = providers.getCodeCache() != null && providers.getCodeCache().shouldDebugNonSafepoints();
            if (Options.UseSnippetTemplateCache.getValue(options).booleanValue()) {
                int size = Options.MaxTemplatesPerSnippet.getValue(options);
                this.templates = Collections.synchronizedMap(new LRUCache(size, size));
            } else {
                this.templates = null;
            }
        }

        public static ResolvedJavaMethod findMethod(MetaAccessProvider metaAccess, Class<?> declaringClass, String methodName) {
            ResolvedJavaType type = metaAccess.lookupJavaType(declaringClass);
            type.link();
            ResolvedJavaMethod result = null;
            for (ResolvedJavaMethod m : type.getDeclaredMethods(false)) {
                if (!m.getName().equals(methodName)) continue;
                if (!Assertions.assertionsEnabled()) {
                    return m;
                }
                assert (result == null) : "multiple definitions found";
                result = m;
            }
            if (result == null) {
                throw new GraalError("Could not find method in " + String.valueOf(declaringClass) + " named " + methodName);
            }
            return result;
        }

        protected SnippetInfo snippet(Providers providers, Class<? extends Snippets> declaringClass, String methodName, LocationIdentity ... initialPrivateLocations) {
            return this.snippet(providers, declaringClass, methodName, null, (Object)null, initialPrivateLocations);
        }

        protected SnippetInfo snippet(Providers providers, Class<? extends Snippets> declaringClass, String methodName, Snippet.SnippetType type, LocationIdentity ... initialPrivateLocations) {
            return this.snippet(providers, declaringClass, methodName, null, null, type, initialPrivateLocations);
        }

        protected SnippetInfo snippet(Providers providers, Class<? extends Snippets> declaringClass, String methodName, ResolvedJavaMethod original, Object receiver, LocationIdentity ... initialPrivateLocations) {
            return this.snippet(providers, declaringClass, methodName, original, receiver, Snippet.SnippetType.INLINED_SNIPPET, initialPrivateLocations);
        }

        protected SnippetInfo snippet(Providers providers, Class<? extends Snippets> declaringClass, String methodName, ResolvedJavaMethod original, Object receiver, Snippet.SnippetType type, LocationIdentity ... initialPrivateLocations) {
            LocationIdentity[] privateLocations;
            assert (methodName != null);
            ResolvedJavaMethod javaMethod = AbstractTemplates.findMethod(providers.getMetaAccess(), declaringClass, methodName);
            if (javaMethod.isStatic()) {
                assert (receiver == null) : "static snippet " + String.valueOf(javaMethod) + " created with non-null receiver";
            } else assert (receiver != null) : "non-static snippet " + String.valueOf(javaMethod) + " created with null receiver";
            providers.getReplacements().registerSnippet(javaMethod, original, receiver, GraalOptions.TrackNodeSourcePosition.getValue(this.options), this.options);
            LocationIdentity[] locationIdentityArray = privateLocations = GraalOptions.SnippetCounters.getValue(this.options) != false ? SnippetCounterNode.addSnippetCounters(initialPrivateLocations) : initialPrivateLocations;
            if (ImageInfo.inImageRuntimeCode() || GraalOptions.EagerSnippets.getValue(this.options).booleanValue()) {
                SnippetParameterInfo snippetParameterInfo = providers.getReplacements().getSnippetParameterInfo(javaMethod);
                return new EagerSnippetInfo(javaMethod, original, privateLocations, receiver, snippetParameterInfo, type);
            }
            return new LazySnippetInfo(javaMethod, original, privateLocations, receiver, type);
        }

        public SnippetTemplate template(CoreProviders context, ValueNode replacee, Arguments args) {
            SnippetTemplate template;
            StructuredGraph graph = replacee.graph();
            DebugContext outer = graph.getDebug();
            SnippetTemplate snippetTemplate = template = Options.UseSnippetTemplateCache.getValue(this.options) != false && args.cacheable ? this.templates.get(args.cacheKey) : null;
            if (template == null || graph.trackNodeSourcePosition() && !template.snippet.trackNodeSourcePosition()) {
                try (DebugContext debug = context.getReplacements().openSnippetDebugContext("SnippetTemplate_", args.cacheKey.method, outer, this.options);){
                    try (DebugCloseable a = SnippetTemplateCreationTime.start(outer);
                         DebugCloseable a2 = args.info.creationTimer.start(outer);
                         DebugContext.Scope s = debug.scope((Object)"SnippetSpecialization", args.info.method);
                         CompilationAlarm alarm = CompilationAlarm.disable();){
                        SnippetTemplates.increment(outer);
                        args.info.creationCounter.increment(outer);
                        OptionValues snippetOptions = new OptionValues(this.options, GraalOptions.TraceInlining, GraalOptions.TraceInliningForStubsAndSnippets.getValue(this.options), DebugOptions.OptimizationLog, null);
                        template = new SnippetTemplate(snippetOptions, debug, context, this.snippetReflection, args, graph.trackNodeSourcePosition() || this.shouldTrackNodeSourcePosition, replacee, this.createMidTierPreLoweringPhases(), this.createMidTierPostLoweringPhases());
                        if (Options.UseSnippetTemplateCache.getValue(snippetOptions).booleanValue() && args.cacheable) {
                            this.templates.put(args.cacheKey, template);
                        }
                        if (outer.areMetricsEnabled()) {
                            DebugContext.counter("SnippetTemplateNodeCount[%#s]", args).add(outer, template.nodes.size());
                        }
                    }
                    catch (Throwable e) {
                        throw debug.handle(e);
                    }
                }
            }
            assert (SnippetTemplate.checkTemplate(context.getMetaAccess(), args, template.snippet.method()));
            return template;
        }

        protected PhaseSuite<CoreProviders> createMidTierPreLoweringPhases() {
            return null;
        }

        protected PhaseSuite<CoreProviders> createMidTierPostLoweringPhases() {
            return null;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> UseSnippetTemplateCache = new OptionKey<Boolean>(true);
        public static final OptionKey<Integer> MaxTemplatesPerSnippet = new OptionKey<Integer>(50);
    }

    public static class EagerSnippetInfo
    extends SnippetInfo {
        protected final SnippetParameterInfo snippetParameterInfo;

        protected EagerSnippetInfo(ResolvedJavaMethod method, ResolvedJavaMethod original, LocationIdentity[] privateLocations, Object receiver, SnippetParameterInfo snippetParameterInfo, Snippet.SnippetType type) {
            super(method, original, privateLocations, receiver, type);
            this.snippetParameterInfo = snippetParameterInfo;
        }

        @Override
        protected SnippetParameterInfo info() {
            return this.snippetParameterInfo;
        }

        public EagerSnippetInfo copyWith(ResolvedJavaMethod newMethod) {
            return new EagerSnippetInfo(newMethod, this.original, this.privateLocations, this.receiver, this.snippetParameterInfo, this.type);
        }
    }

    protected static class LazySnippetInfo
    extends SnippetInfo {
        protected final AtomicReference<SnippetParameterInfo> lazy = new AtomicReference<Object>(null);

        protected LazySnippetInfo(ResolvedJavaMethod method, ResolvedJavaMethod original, LocationIdentity[] privateLocations, Object receiver, Snippet.SnippetType type) {
            super(method, original, privateLocations, receiver, type);
        }

        @Override
        protected SnippetParameterInfo info() {
            if (this.lazy.get() == null) {
                this.lazy.compareAndSet(null, new SnippetParameterInfo(this.method));
            }
            return this.lazy.get();
        }
    }
}

