/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", size=NodeSize.SIZE_UNKNOWN, sizeRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate")
public class PartialIntrinsicCallTargetNode
extends CallTargetNode
implements IterableNodeType {
    public static final NodeClass<PartialIntrinsicCallTargetNode> TYPE = NodeClass.create(PartialIntrinsicCallTargetNode.class);
    private final String targetName;

    public PartialIntrinsicCallTargetNode(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod target, StampPair returnStamp, ValueNode ... arguments) {
        super(TYPE, arguments, null, invokeKind, returnStamp);
        this.targetName = PartialIntrinsicCallTargetNode.format(target);
    }

    @Override
    public String targetName() {
        return this.targetName;
    }

    public boolean checkName(ResolvedJavaMethod original) {
        assert (this.targetName.equals(PartialIntrinsicCallTargetNode.format(original))) : "expected " + this.targetName + " but got " + PartialIntrinsicCallTargetNode.format(original);
        return true;
    }

    private static String format(ResolvedJavaMethod method) {
        return method.format("%H.%n(%p)");
    }
}

