/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.StrideUtil;
import jdk.graal.compiler.nodes.ValueNode;

public final class NodeStrideUtil {
    public static Stride getConstantStrideA(ValueNode dynamicStrides, Stride strideA) {
        if (strideA != null) {
            return strideA;
        }
        return StrideUtil.getConstantStrideA(dynamicStrides.asJavaConstant().asInt());
    }

    public static Stride getConstantStrideB(ValueNode dynamicStrides, Stride strideB) {
        if (strideB != null) {
            return strideB;
        }
        return StrideUtil.getConstantStrideB(dynamicStrides.asJavaConstant().asInt());
    }

    public static int getDirectStubCallIndex(ValueNode dynamicStrides, Stride strideA, Stride strideB) {
        if (strideA != null && strideB != null) {
            return StrideUtil.getDirectStubCallIndex(strideA.log2, strideB.log2);
        }
        if (dynamicStrides != null && dynamicStrides.isJavaConstant()) {
            return dynamicStrides.asJavaConstant().asInt();
        }
        return -1;
    }
}

