/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import java.util.List;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConditionAnchorNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;

public abstract class InstanceOfSnippetsTemplates
extends SnippetTemplate.AbstractTemplates {
    public InstanceOfSnippetsTemplates(OptionValues options, Providers providers) {
        super(options, providers);
    }

    protected abstract SnippetTemplate.Arguments makeArguments(InstanceOfUsageReplacer var1, LoweringTool var2);

    public void lower(FloatingNode instanceOf, LoweringTool tool) {
        assert (instanceOf instanceof LogicNode) : instanceOf;
        List<Node> usages = instanceOf.usages().snapshot();
        Instantiation instantiation = new Instantiation();
        for (Node usage : usages) {
            StructuredGraph graph = (StructuredGraph)usage.graph();
            InstanceOfUsageReplacer replacer = this.createReplacer(instanceOf, instantiation, usage, graph);
            if (instantiation.isInitialized()) {
                replacer.replaceUsingInstantiation();
                continue;
            }
            SnippetTemplate.Arguments args = this.makeArguments(replacer, tool);
            this.template(tool, instanceOf, args).instantiate(tool.getMetaAccess(), instanceOf, (SnippetTemplate.UsageReplacer)replacer, tool, args);
        }
        assert (instanceOf.hasNoUsages());
        if (!instanceOf.isDeleted()) {
            GraphUtil.killWithUnusedFloatingInputs(instanceOf);
        }
    }

    protected InstanceOfUsageReplacer createReplacer(FloatingNode instanceOf, Instantiation instantiation, Node usage, StructuredGraph graph) {
        InstanceOfUsageReplacer replacer;
        if (!this.canMaterialize(usage)) {
            ValueNode trueValue = ConstantNode.forInt(1, graph);
            ValueNode falseValue = ConstantNode.forInt(0, graph);
            if (instantiation.isInitialized() && (trueValue != instantiation.trueValue || falseValue != instantiation.falseValue)) {
                trueValue = instantiation.trueValue;
                falseValue = instantiation.falseValue;
            }
            replacer = new NonMaterializationUsageReplacer(instantiation, trueValue, falseValue, instanceOf, usage);
        } else {
            assert (usage instanceof ConditionalNode) : "unexpected usage of " + String.valueOf(instanceOf) + ": " + String.valueOf(usage);
            ConditionalNode c = (ConditionalNode)usage;
            replacer = new MaterializationUsageReplacer(instantiation, c.trueValue(), c.falseValue(), instanceOf, c);
        }
        return replacer;
    }

    protected boolean canMaterialize(Node usage) {
        if (usage instanceof ConditionalNode) {
            ConditionalNode cn = (ConditionalNode)usage;
            return cn.trueValue().isConstant() && cn.falseValue().isConstant();
        }
        return !(usage instanceof IfNode) && !(usage instanceof FixedGuardNode) && !(usage instanceof ShortCircuitOrNode) && !(usage instanceof ConditionAnchorNode);
    }

    public static final class Instantiation {
        private ValueNode result;
        private LogicNode condition;
        private ValueNode trueValue;
        private ValueNode falseValue;

        boolean isInitialized() {
            return this.result != null;
        }

        void initialize(ValueNode r, ValueNode t, ValueNode f) {
            assert (!this.isInitialized());
            this.result = r;
            this.trueValue = t;
            this.falseValue = f;
        }

        LogicNode asCondition(ValueNode testValue) {
            assert (this.isInitialized());
            if (this.result.isConstant()) {
                assert (testValue.isConstant());
                return LogicConstantNode.forBoolean(this.result.asConstant().equals((Object)testValue.asConstant()), this.result.graph());
            }
            if (this.condition == null || !(this.condition instanceof CompareNode) || ((CompareNode)this.condition).getY() != testValue) {
                this.condition = CompareNode.createCompareNode(this.result.graph(), CanonicalCondition.EQ, this.result, testValue, null, NodeView.DEFAULT);
            }
            return this.condition;
        }

        ValueNode asMaterialization(StructuredGraph graph, ValueNode t, ValueNode f) {
            assert (this.isInitialized());
            if (t == this.trueValue && f == this.falseValue) {
                return this.result;
            }
            return graph.unique(new ConditionalNode(this.asCondition(this.trueValue), t, f));
        }
    }

    public static abstract class InstanceOfUsageReplacer
    implements SnippetTemplate.UsageReplacer {
        public final Instantiation instantiation;
        public final FloatingNode instanceOf;
        public final ValueNode trueValue;
        public final ValueNode falseValue;

        public InstanceOfUsageReplacer(Instantiation instantiation, FloatingNode instanceOf, ValueNode trueValue, ValueNode falseValue) {
            this.instantiation = instantiation;
            this.instanceOf = instanceOf;
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        public abstract void replaceUsingInstantiation();
    }

    public static class NonMaterializationUsageReplacer
    extends InstanceOfUsageReplacer {
        private final Node usage;

        public NonMaterializationUsageReplacer(Instantiation instantiation, ValueNode trueValue, ValueNode falseValue, FloatingNode instanceOf, Node usage) {
            super(instantiation, instanceOf, trueValue, falseValue);
            this.usage = usage;
        }

        @Override
        public void replaceUsingInstantiation() {
            this.usage.replaceFirstInput(this.instanceOf, this.instantiation.asCondition(this.trueValue));
        }

        @Override
        public void replace(ValueNode oldNode, ValueNode newNode) {
            assert (newNode instanceof PhiNode) : Assertions.errorMessage(oldNode, newNode, this.instanceOf);
            assert (oldNode == this.instanceOf) : Assertions.errorMessage(oldNode, newNode, this.instanceOf);
            newNode.inferStamp();
            this.instantiation.initialize(newNode, this.trueValue, this.falseValue);
            this.usage.replaceFirstInput(oldNode, this.instantiation.asCondition(this.trueValue));
        }
    }

    public static class MaterializationUsageReplacer
    extends InstanceOfUsageReplacer {
        public final ConditionalNode usage;

        public MaterializationUsageReplacer(Instantiation instantiation, ValueNode trueValue, ValueNode falseValue, FloatingNode instanceOf, ConditionalNode usage) {
            super(instantiation, instanceOf, trueValue, falseValue);
            this.usage = usage;
        }

        @Override
        public void replaceUsingInstantiation() {
            ValueNode newValue = this.instantiation.asMaterialization(this.usage.graph(), this.trueValue, this.falseValue);
            this.usage.replaceAtUsages(newValue);
            assert (this.usage.hasNoUsages());
            GraphUtil.killWithUnusedFloatingInputs(this.usage);
        }

        @Override
        public void replace(ValueNode oldNode, ValueNode newNode) {
            assert (newNode instanceof PhiNode) : Assertions.errorMessage(oldNode, newNode, this.instanceOf);
            assert (oldNode == this.instanceOf) : Assertions.errorMessage(oldNode, newNode, this.instanceOf);
            newNode.inferStamp();
            this.instantiation.initialize(newNode, this.trueValue, this.falseValue);
            this.usage.replaceAtUsages(newNode);
            assert (this.usage.hasNoUsages());
            GraphUtil.killWithUnusedFloatingInputs(this.usage);
        }
    }
}

